package com.xebialabs.xlrelease.actors

import com.esotericsoftware.kryo.io.{Input, Output}
import com.esotericsoftware.kryo.serializers.CompatibleFieldSerializer
import com.esotericsoftware.kryo.util.DefaultClassResolver
import com.esotericsoftware.kryo.{ClassResolver, Kryo, Registration, Serializer}
import com.xebialabs.xlrelease.repository.proxy.ResolvableLazyConfigurationItem
import com.xebialabs.xlrelease.support.serialization.SerializableMsg
import grizzled.slf4j.Logging

class XlrClassResolver(delegate: DefaultClassResolver) extends ClassResolver with Logging {
  private val resolvableLazyConfigurationItemClazz = classOf[ResolvableLazyConfigurationItem]
  private val m = classOf[DefaultClassResolver].getDeclaredMethod("writeName", classOf[Output], classOf[Class[_]], classOf[Registration])
  m.setAccessible(true)
  private var _kryo: Kryo = _

  override def setKryo(kryo: Kryo): Unit = {
    _kryo = kryo
    delegate.setKryo(kryo)
  }

  def doWriteName(output: Output, typ: Class[_], registration: Registration): Unit = {
    m.invoke(delegate, output, typ, registration)
  }

  override def register(registration: Registration): Registration = {
    val typ = registration.getType
    if (classOf[SerializableMsg].isAssignableFrom(typ)) {
      val serializer: Serializer[_] = new CompatibleFieldSerializer(_kryo, typ)
      registration.setSerializer(serializer)
    }
    delegate.register(registration)
  }

  override def unregister(classID: Int): Registration = delegate.unregister(classID)

  override def registerImplicit(typ: Class[_]): Registration = delegate.registerImplicit(typ)

  override def getRegistration(typ: Class[_]): Registration = delegate.getRegistration(typ)

  override def getRegistration(classID: Int): Registration = delegate.getRegistration(classID)

  override def writeClass(output: Output, typ: Class[_]): Registration = {
    if (null != typ && resolvableLazyConfigurationItemClazz.isAssignableFrom(typ)) {
      val registration = delegate.getRegistration(resolvableLazyConfigurationItemClazz)
      doWriteName(output, resolvableLazyConfigurationItemClazz, registration)
      registration
    } else {
      delegate.writeClass(output, typ)
    }
  }

  override def readClass(input: Input): Registration = delegate.readClass(input)

  override def reset(): Unit = delegate.reset()
}
