/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.UserTokenPermission;
import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokensDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003E\u0001\u0011\u0005Q\tC\u0003v\u0001\u0011\u0005a\u000fC\u0003~\u0001\u0011\u0005a\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!!\u001c\u0001\t\u0013\tyG\u0001\tVg\u0016\u0014Hk\\6f]N+'O^5dK*\u0011\u0011CE\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019B#A\u0005yYJ,G.Z1tK*\u0011QCF\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aF\u0001\u0004G>l7\u0001A\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005)1\u000f\u001c45U*\tQ%\u0001\u0005he&T(\u0010\\3e\u0013\t9#EA\u0004M_\u001e<\u0017N\\4\u0002\u0011\u00154XM\u001c;CkN\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\r\u00154XM\u001c;t\u0013\tq3F\u0001\u0005Fm\u0016tGOQ;t\u0003M)8/\u001a:U_.,gNU3q_NLGo\u001c:z!\t\tD'D\u00013\u0015\t\u0019$#\u0001\u0006sKB|7/\u001b;pefL!!\u000e\u001a\u0003'U\u001bXM\u001d+pW\u0016t'+\u001a9pg&$xN]=\u00025A,'o]8oC2\f5mY3tgR{7.\u001a8GK\u0006$XO]3\u0011\u0005aZT\"A\u001d\u000b\u0005i\u0012\u0012\u0001\u00034fCR,(/Z:\n\u0005qJ$A\u0007)feN|g.\u00197BG\u000e,7o\u001d+pW\u0016tg)Z1ukJ,\u0017A\u0002\u001fj]&$h\b\u0006\u0003@\u0003\n\u001b\u0005C\u0001!\u0001\u001b\u0005\u0001\u0002\"\u0002\u0015\u0005\u0001\u0004I\u0003\"B\u0018\u0005\u0001\u0004\u0001\u0004\"\u0002\u001c\u0005\u0001\u00049\u0014aD2sK\u0006$X-V:feR{7.\u001a8\u0015\u000b\u0019c\u0015lW3\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u0013\u0012A\u00023p[\u0006Lg.\u0003\u0002L\u0011\nIQk]3s)>\\WM\u001c\u0005\u0006\u001b\u0016\u0001\rAT\u0001\tkN,'O\\1nKB\u0011qJ\u0016\b\u0003!R\u0003\"!\u0015\u000f\u000e\u0003IS!a\u0015\r\u0002\rq\u0012xn\u001c;?\u0013\t)F$\u0001\u0004Qe\u0016$WMZ\u0005\u0003/b\u0013aa\u0015;sS:<'BA+\u001d\u0011\u0015QV\u00011\u0001O\u0003%!xn[3o\u001d>$X\rC\u0003]\u000b\u0001\u0007Q,\u0001\u0006fqBL'/\u001f#bi\u0016\u0004\"AX2\u000e\u0003}S!\u0001Y1\u0002\tU$\u0018\u000e\u001c\u0006\u0002E\u0006!!.\u0019<b\u0013\t!wL\u0001\u0003ECR,\u0007\"\u00024\u0006\u0001\u00049\u0017!E4m_\n\fG\u000eU3s[&\u001c8/[8ogB\u0019q\n\u001b(\n\u0005%D&aA*fi\"\u0012Qa\u001b\t\u0003YNl\u0011!\u001c\u0006\u0003]>\f!\"\u00198o_R\fG/[8o\u0015\t\u0001\u0018/A\u0004nKR\u0014\u0018nY:\u000b\u0005I4\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005Ql'!\u0002+j[\u0016$\u0017a\u00043fY\u0016$X-V:feR{7.\u001a8\u0015\u0005]T\bCA\u000ey\u0013\tIHD\u0001\u0003V]&$\b\"B>\u0007\u0001\u00041\u0015!C;tKJ$vn[3oQ\t11.\u0001\neK2,G/Z!mYV\u001bXM\u001d+pW\u0016tGCA<\u0000\u0011\u0015iu\u00011\u0001OQ\t91.\u0001\u0003gS:$GCBA\u0004\u0003;\ty\u0002E\u0003\u0002\n\u0005ea)\u0004\u0002\u0002\f)\u0019\u0011*!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0005I\u0006$\u0018M\u0003\u0003\u0002\u0014\u0005U\u0011aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0005\u0005]\u0011aA8sO&!\u00111DA\u0006\u0005\u0011\u0001\u0016mZ3\t\u000b5C\u0001\u0019\u0001(\t\u000f\u0005\u0005\u0002\u00021\u0001\u0002$\u0005A\u0001/Y4fC\ndW\r\u0005\u0003\u0002\n\u0005\u0015\u0012\u0002BA\u0014\u0003\u0017\u0011\u0001\u0002U1hK\u0006\u0014G.\u001a\u0015\u0003\u0011-\f1BZ5oI\nK8)[+jIR!\u0011qFA\u001b!\u0011Y\u0012\u0011\u0007$\n\u0007\u0005MBD\u0001\u0004PaRLwN\u001c\u0005\b\u0003oI\u0001\u0019AA\u001d\u0003\u0015\u0019\u0017.V5e!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA C\u0006!A.\u00198h\u0013\u0011\t\u0019%!\u0010\u0003\u000f%sG/Z4fe\"\u0012\u0011b[\u0001\u0010M&tGMQ=Vg\u0016\u0014Hk\\6f]R!\u0011qFA&\u0011\u0019\tiE\u0003a\u0001\u001d\u0006IAo\\6f]\"\u000b7\u000f\u001b\u0015\u0003\u0015-\f\u0011D\\8uS\u001aLHk\\6f]N\f%m\\;u)>,\u0005\u0010]5sKR\tq\u000f\u000b\u0002\fW\u0006yQo]3s)>\\WM\\#ySN$8\u000f\u0006\u0004\u0002\\\u0005\u0005\u00141\r\t\u00047\u0005u\u0013bAA09\t9!i\\8mK\u0006t\u0007\"B'\r\u0001\u0004q\u0005\"\u0002.\r\u0001\u0004q\u0005F\u0001\u0007l\u0003A1\u0018\r\\5eCR,G)\u001e:bi&|g\u000eF\u0002x\u0003WBQ\u0001X\u0007A\u0002u\u000b\u0001\u0004];cY&\u001c\b\u000eV8lK:\u001c%/Z1uK\u0012,e/\u001a8u)\r9\u0018\u0011\u000f\u0005\u0006w:\u0001\rA\u0012")
public class UserTokenService
implements Logging {
    private final EventBus eventBus;
    private final UserTokenRepository userTokenRepository;
    private final PersonalAccessTokenFeature personalAccessTokenFeature;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenService userTokenService = this;
        synchronized (userTokenService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public UserToken createUserToken(String username, String tokenNote, Date expiryDate, scala.collection.immutable.Set<String> globalPermissions) {
        this.validateDuration(expiryDate);
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RPA());
        UserToken userToken = new UserToken();
        userToken.tokenNote_$eq(tokenNote);
        userToken.username_$eq(username);
        userToken.createdDate_$eq(new Date());
        if (expiryDate == null) {
            userToken.expiryDate_$eq(expiryDate);
        } else {
            LocalDateTime localExpiryDate = expiryDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            userToken.expiryDate_$eq(Date.from(localExpiryDate.atZone(ZoneId.systemDefault()).toInstant()));
        }
        UserTokenPermission userTokenPermission = (UserTokenPermission)Type.valueOf(UserTokenPermission.class).getDescriptor().newInstance(null);
        if (globalPermissions != null && globalPermissions.nonEmpty()) {
            userTokenPermission.globalPermissions_$eq(CollectionConverters$.MODULE$.SetHasAsJava((Set)globalPermissions.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{PlatformPermissions.LOGIN.getPermissionName()})))).asJava());
        }
        userToken.userTokenPermission_$eq(userTokenPermission);
        Integer ciUid = this.userTokenRepository.create(userToken, TokenGenerator$.MODULE$.hash(token));
        userToken.ciUid_$eq(ciUid);
        userToken.token_$eq(token);
        this.publishTokenCreatedEvent(userToken);
        return userToken;
    }

    @Timed
    public void deleteUserToken(UserToken userToken) {
        this.userTokenRepository.delete(userToken.ciUid());
        this.eventBus.publish((XLReleaseEvent)new UserTokenDeletedEvent(userToken));
    }

    @Timed
    public void deleteAllUserToken(String username) {
        if (Strings.isNotBlank((String)username)) {
            this.userTokenRepository.delete(username);
            this.eventBus.publish((XLReleaseEvent)new UserTokensDeletedEvent(username));
            return;
        }
        throw new IllegalArgumentException("Username can't be blank");
    }

    @Timed
    public Page<UserToken> find(String username, Pageable pageable) {
        return this.userTokenRepository.query(new UserTokenRepository.ByUsername(username), pageable);
    }

    @Timed
    public Option<UserToken> findByCiUid(Integer ciUid) {
        return this.userTokenRepository.findByCiUid(ciUid);
    }

    @Timed
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.userTokenRepository.findByUserToken(tokenHash);
    }

    @Timed
    public void notifyTokensAboutToExpire() {
        LocalDateTime localTime = Instant.now().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX).plusDays(1L);
        Date expiryDate = Date.from(localTime.atZone(ZoneId.systemDefault()).toInstant());
        Buffer tokensAboutToExpire = CollectionConverters$.MODULE$.ListHasAsScala(this.userTokenRepository.query(new UserTokenRepository.TokensAboutToExpire(expiryDate), (Pageable)PageRequest.ofSize((int)1024)).getContent()).asScala();
        tokensAboutToExpire.foreach((Function1 & Serializable)userToken -> {
            UserTokenService.$anonfun$notifyTokensAboutToExpire$1(this, userToken);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public boolean userTokenExists(String username, String tokenNote) {
        Option<UserToken> option = this.userTokenRepository.findByUserAndNote(username, tokenNote);
        if (option instanceof Some) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was found with user[" + username + "] and note[" + tokenNote + "]");
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was not found with user[" + username + "] and note[" + tokenNote + "]");
            return false;
        }
        throw new MatchError(option);
    }

    private void validateDuration(Date expiryDate) {
        boolean noPresetExpirationLimit;
        int maximumPresetExpirationDays = this.personalAccessTokenFeature.maxTokenExpiry();
        boolean bl = noPresetExpirationLimit = maximumPresetExpirationDays == -1;
        if (!noPresetExpirationLimit) {
            boolean tokenReqExceedsPresetExpirationLimit;
            LocalDateTime today = new Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            Date maximumExpiryDate = Date.from(today.plusDays(maximumPresetExpirationDays).atZone(ZoneId.systemDefault()).toInstant());
            boolean tokenReqHasExpiryDate = expiryDate != null;
            boolean tokenReqExceedsMaximumExpiryDate = tokenReqHasExpiryDate && expiryDate.after(maximumExpiryDate);
            boolean tokenReqIsNonExpiringButNotAllowed = !tokenReqHasExpiryDate && !noPresetExpirationLimit;
            boolean bl2 = tokenReqExceedsPresetExpirationLimit = tokenReqExceedsMaximumExpiryDate || tokenReqIsNonExpiringButNotAllowed;
            if (tokenReqExceedsPresetExpirationLimit) {
                throw new IllegalArgumentException("Personal access token expiration cannot exceed " + maximumPresetExpirationDays + " days.");
            }
            return;
        }
    }

    private void publishTokenCreatedEvent(UserToken userToken) {
        UserToken userTokenForEvent = CiCloneHelper.cloneCi(userToken);
        userTokenForEvent.token_$eq(PasswordVerificationUtils$.MODULE$.PASSWORD_MASK());
        this.eventBus.publish((XLReleaseEvent)new UserTokenCreatedEvent(userTokenForEvent));
    }

    public static final /* synthetic */ void $anonfun$notifyTokensAboutToExpire$1(UserTokenService $this, UserToken userToken) {
        $this.eventBus.publish((XLReleaseEvent)new UserTokenAboutToExpireEvent(userToken));
        $this.userTokenRepository.updateTokenExpiredNotified(userToken.ciUid());
    }

    public UserTokenService(EventBus eventBus, UserTokenRepository userTokenRepository, PersonalAccessTokenFeature personalAccessTokenFeature) {
        this.eventBus = eventBus;
        this.userTokenRepository = userTokenRepository;
        this.personalAccessTokenFeature = personalAccessTokenFeature;
        Logging.$init$((Logging)this);
    }
}

