/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.io.StreamWrappingOverthereFile;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.configuration.CustomLogoContentType;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.domain.events.TemplateLogoUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.utils.IdUtils;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.AttachmentSizeLimiter;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TemplateMetadataRepository;
import com.xebialabs.xlrelease.service.AttachmentService;
import com.xebialabs.xlrelease.utils.FileContentValidation;
import jakarta.activation.FileTypeMap;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.jdk.javaapi.OptionConverters;

@Service
public class UploadService {
    private static final Logger logger = LoggerFactory.getLogger(UploadService.class);
    public static final String NEWLINES = "[\n\r]";
    private final AttachmentService attachmentService;
    private final ReleaseRepository releaseRepository;
    private final AttachmentRepository attachmentRepository;
    private final ReleaseActorService releaseActorService;
    private final TemplateMetadataRepository templateMetadataRepository;
    private final EventBus eventBus;

    @Autowired
    public UploadService(AttachmentService attachmentService, ReleaseRepository releaseRepository, AttachmentRepository attachmentRepository, ReleaseActorService releaseActorService, TemplateMetadataRepository templateMetadataRepository, EventBus eventBus) {
        this.attachmentService = attachmentService;
        this.releaseRepository = releaseRepository;
        this.attachmentRepository = attachmentRepository;
        this.releaseActorService = releaseActorService;
        this.templateMetadataRepository = templateMetadataRepository;
        this.eventBus = eventBus;
    }

    @Timed
    public List<Attachment> addAttachment(String ciId, Iterator<Part> attachments) throws IOException {
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        while (attachments.hasNext()) {
            Part item = attachments.next();
            String filename = item.getSubmittedFileName();
            String contentType = item.getContentType();
            InputStream stream = item.getInputStream();
            try {
                InputStream validatedInputStream = (InputStream)FileContentValidation.apply(filename, stream).get();
                try {
                    logger.debug("Attaching {} to {}", (Object)filename.replaceAll(NEWLINES, "_"), (Object)ciId.replaceAll(NEWLINES, "_"));
                    attachmentList.add(this.addAttachment(ciId, filename, contentType, validatedInputStream));
                }
                finally {
                    if (validatedInputStream == null) continue;
                    validatedInputStream.close();
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return attachmentList;
    }

    @Timed
    public TemplateLogo addLogo(String ciId, Iterator<Part> logo) throws IOException {
        if (logo.hasNext()) {
            Part item = logo.next();
            String filename = item.getSubmittedFileName();
            String contentType = item.getContentType();
            if (!CustomLogoContentType.getAllTypes().contains(contentType)) {
                throw new IllegalArgumentException(String.format("Content type %s not allowed. Allowed content types are: %s", contentType, CustomLogoContentType.getBrowserTypes().toString()));
            }
            try (InputStream stream = item.getInputStream();){
                TemplateLogo templateLogo;
                block14: {
                    InputStream validatedInputStream = (InputStream)FileContentValidation.apply(filename, stream).get();
                    try {
                        templateLogo = this.addLogo(ciId, filename, contentType, validatedInputStream);
                        if (validatedInputStream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (validatedInputStream != null) {
                            try {
                                validatedInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    validatedInputStream.close();
                }
                return templateLogo;
            }
        }
        return null;
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, byte[] fileByteArray) {
        return this.addAttachment(ciId, fileName, FileTypeMap.getDefaultFileTypeMap().getContentType(fileName), new ByteArrayInputStream(fileByteArray));
    }

    @Timed
    public Attachment addAttachment(String ciId, String fileName, String contentType, InputStream inputStream) {
        logger.debug("Attaching {} to {}", (Object)fileName.replaceAll(NEWLINES, "_"), (Object)ciId.replaceAll(NEWLINES, "_"));
        Release release = this.releaseRepository.findById(Ids.releaseIdFrom((String)ciId));
        Task task = null;
        if (!Ids.isReleaseId((String)ciId)) {
            task = release.getTask(ciId);
        }
        Attachment attachment = this.attachmentService.attachToRelease(release, fileName, contentType, inputStream);
        if (task != null) {
            task.getAttachments().add(attachment);
        }
        this.attachmentRepository.insertAttachment(release.getId(), attachment);
        if (null != task) {
            return this.releaseActorService.createAttachmentOnTask(task.getId(), attachment);
        }
        return this.releaseActorService.createAttachmentOnRelease(release.getId(), attachment);
    }

    @Timed
    public TemplateLogo addLogo(String releaseId, String fileName, String contentType, InputStream inputStream) {
        logger.debug("Attaching logo to {}", (Object)releaseId);
        Optional releaseUid = OptionConverters.toJava(this.releaseRepository.getUid(releaseId));
        if (releaseUid.isPresent()) {
            TemplateLogo logo = this.createLogo(releaseId, fileName, contentType, inputStream);
            TemplateLogo createdLogo = this.templateMetadataRepository.createOrUpdateLogo((Integer)releaseUid.get(), logo);
            this.eventBus.publish((XLReleaseEvent)new TemplateLogoUpdatedEvent(releaseId, createdLogo));
            return createdLogo;
        }
        throw new NotFoundException("Repository entity [%s] not found", new Object[]{releaseId});
    }

    private TemplateLogo createLogo(String releaseId, String filename, String contentType, InputStream bytes) {
        AttachmentSizeLimiter limiter = new AttachmentSizeLimiter(TemplateLogo.getDefaultMaxLogoSize(), bytes);
        StreamWrappingOverthereFile file = new StreamWrappingOverthereFile(filename, (InputStream)((Object)limiter));
        String logoId = IdUtils.getUniqueId((Type)Type.valueOf(TemplateLogo.class), (String)releaseId);
        TemplateLogo templateLogo = new TemplateLogo((OverthereFile)file, contentType);
        templateLogo.setId(logoId);
        templateLogo.getExportFilename();
        String releaseTitle = this.releaseRepository.getTitle(releaseId);
        templateLogo.setProperty("parentTitle", (Object)releaseTitle);
        templateLogo.getPortableFilename();
        return templateLogo;
    }
}

