/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.events.FolderCreatedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletedEvent;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.FolderMovedEvent;
import com.xebialabs.xlrelease.domain.events.FolderMovingAction;
import com.xebialabs.xlrelease.domain.events.FolderRenamedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseMovedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsMergedEvent;
import com.xebialabs.xlrelease.domain.events.TeamsRemovedInTemplateEvent;
import com.xebialabs.xlrelease.domain.events.TeamsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TemplateMovingAction;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams$;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService$FolderAndEvents$;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.utils.Limits$;
import com.xebialabs.xlrelease.views.TemplateFilters;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0005e\u0001\u0002*T\u0001qC\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005g\"Aq\u000f\u0001B\u0001B\u0003%\u0001\u0010\u0003\u0005|\u0001\t\u0005\t\u0015!\u0003}\u0011%y\bA!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\b\u0001\u0011\t\u0011)A\u0005\u0003\u0013A!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0004\u0005\u000b\u0003K\u0001!\u0011!Q\u0001\n\u0005\u001d\u0002BCA\u001a\u0001\t\u0005\t\u0015!\u0003\u00026!9\u00111\b\u0001\u0005\u0002\u0005u\u0002\"CA+\u0001\t\u0007I\u0011AA,\u0011!\tI\u0007\u0001Q\u0001\n\u0005e\u0003\"CA6\u0001\t\u0007I\u0011AA,\u0011!\ti\u0007\u0001Q\u0001\n\u0005e\u0003bBA8\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\t)\f\u0001C\u0001\u0003oCq!!0\u0001\t\u0003\ty\fC\u0005\u0002`\u0002\t\n\u0011\"\u0001\u0002b\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\b\"\u0003B\u0002\u0001E\u0005I\u0011AAq\u0011%\u0011)\u0001AI\u0001\n\u0003\u00119\u0001C\u0004\u0003\f\u0001!\tA!\u0004\t\u0013\tu\u0001!%A\u0005\u0002\t}\u0001b\u0002B\u0012\u0001\u0011\u0005!Q\u0005\u0005\n\u0005\u0013\u0002\u0011\u0013!C\u0001\u0005\u000fA\u0011Ba\u0013\u0001#\u0003%\tAa\u0002\t\u000f\t5\u0003\u0001\"\u0001\u0003P!9!\u0011\f\u0001\u0005\u0002\tm\u0003b\u0002B3\u0001\u0011\u0005!q\r\u0005\n\u0005\u000b\u0003\u0011\u0013!C\u0001\u0005\u000fAqAa\"\u0001\t\u0003\u0011I\tC\u0005\u00036\u0002\t\n\u0011\"\u0001\u00038\"9!1\u0018\u0001\u0005\u0002\tu\u0006\"\u0003Bf\u0001E\u0005I\u0011\u0001B\u0004\u0011\u001d\u0011i\r\u0001C\u0001\u0005\u001fDqA!4\u0001\t\u0003\u00119\u000eC\u0004\u0003d\u0002!IA!:\t\u000f\t-\b\u0001\"\u0003\u0003n\"911\u0001\u0001\u0005\n\r\u0015aABB\u0004\u0001\u0001\u001bI\u0001\u0003\u0006\u0002H*\u0012)\u001a!C\u0001\u0007GA!b!\n+\u0005#\u0005\u000b\u0011BAa\u0011)\tiC\u000bBK\u0002\u0013\u00051q\u0005\u0005\u000b\u0007sQ#\u0011#Q\u0001\n\r%\u0002bBA\u001eU\u0011\u000511\b\u0005\n\u0007\u000bR\u0013\u0011!C\u0001\u0007\u000fB\u0011b!\u0014+#\u0003%\taa\u0014\t\u0013\rM#&%A\u0005\u0002\rU\u0003\"CB-U\u0005\u0005I\u0011IA,\u0011%\u0019YFKA\u0001\n\u0003\u0019i\u0006C\u0005\u0004`)\n\t\u0011\"\u0001\u0004b!I1Q\u000e\u0016\u0002\u0002\u0013\u00053q\u000e\u0005\n\u0007{R\u0013\u0011!C\u0001\u0007\u007fB\u0011ba!+\u0003\u0003%\te!\"\t\u0013\r%%&!A\u0005B\r-\u0005\"CBGU\u0005\u0005I\u0011IBH\u0011%\u0019\tJKA\u0001\n\u0003\u001a\u0019jB\u0005\u0004\u0018\u0002\t\t\u0011#\u0001\u0004\u001a\u001aI1q\u0001\u0001\u0002\u0002#\u000511\u0014\u0005\b\u0003wiD\u0011ABZ\u0011%\u0019i)PA\u0001\n\u000b\u001ay\tC\u0005\u00046v\n\t\u0011\"!\u00048\"I1QX\u001f\u0012\u0002\u0013\u00051Q\u000b\u0005\n\u0007\u007fk\u0014\u0011!CA\u0007\u0003D\u0011ba5>#\u0003%\ta!\u0016\t\u000f\rU\u0007\u0001\"\u0001\u0004X\"91q\u001c\u0001\u0005\u0002\r\u0005\bbBBt\u0001\u0011%1\u0011\u001e\u0005\b\u0007g\u0004A\u0011BB{\u0011\u001d!9\u0001\u0001C\u0005\t\u0013Aq\u0001b\u0004\u0001\t\u0013!\t\u0002C\u0004\u0005\u001a\u0001!I\u0001b\u0007\t\u000f\u0011}\u0001\u0001\"\u0003\u0005\"!9A1\u0006\u0001\u0005\u0002\u00115\u0002b\u0002C$\u0001\u0011%A\u0011\n\u0005\b\t/\u0002A\u0011\u0002C-\u0011\u001d!i\u0007\u0001C\u0005\t_Bq\u0001\"\u001e\u0001\t\u0013!9\bC\u0004\u0005|\u0001!I\u0001\" \u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0015\t!V+A\u0004tKJ4\u0018nY3\u000b\u0005Y;\u0016!\u0003=me\u0016dW-Y:f\u0015\tA\u0016,A\u0005yK\nL\u0017\r\\1cg*\t!,A\u0002d_6\u001c\u0001aE\u0002\u0001;\u000e\u0004\"AX1\u000e\u0003}S\u0011\u0001Y\u0001\u0006g\u000e\fG.Y\u0005\u0003E~\u0013a!\u00118z%\u00164\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0017\u0001C4sSjTH.\u001a3\n\u0005),'a\u0002'pO\u001eLgnZ\u0001\bM>dG-\u001a:t!\ti\u0007/D\u0001o\u0015\tyW+\u0001\u0006sKB|7/\u001b;pefL!!\u001d8\u0003!\u0019{G\u000eZ3s%\u0016\u0004xn]5u_JL\u0018a\u0003;fC6\u001cVM\u001d<jG\u0016\u0004\"\u0001^;\u000e\u0003MK!A^*\u0003\u0017Q+\u0017-\\*feZL7-Z\u0001\u0012e\u0016dW-Y:f%\u0016\u0004xn]5u_JL\bCA7z\u0013\tQhNA\tSK2,\u0017m]3SKB|7/\u001b;pef\f1\u0002^1tWN+'O^5dKB\u0011A/`\u0005\u0003}N\u00131\u0002V1tWN+'O^5dK\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0004[\u0006\r\u0011bAA\u0003]\n92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\fG&LEmU3sm&\u001cW\rE\u0002u\u0003\u0017I1!!\u0004T\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002)I,G.Z1tKN+\u0017M]2i'\u0016\u0014h/[2f!\r!\u00181C\u0005\u0004\u0003+\u0019&\u0001\u0006*fY\u0016\f7/Z*fCJ\u001c\u0007nU3sm&\u001cW-A\u0006qKJl\u0017n]:j_:\u001c\b\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}Q+\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\u0019#!\b\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0005fm\u0016tGOQ;t!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017+\u00061QM^3oiNLA!!\r\u0002,\t\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002!\u0005\u00148\r[5wS:<7+\u001a:wS\u000e,\u0007c\u0001;\u00028%\u0019\u0011\u0011H*\u0003!\u0005\u00138\r[5wS:<7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\f\u0002@\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*!\t!\b\u0001C\u0003l\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u00071\u000fC\u0003x\u0017\u0001\u0007\u0001\u0010C\u0003|\u0017\u0001\u0007A\u0010\u0003\u0004\u0000\u0017\u0001\u0007\u0011\u0011\u0001\u0005\b\u0003\u000fY\u0001\u0019AA\u0005\u0011\u001d\tya\u0003a\u0001\u0003#Aq!a\u0006\f\u0001\u0004\tI\u0002C\u0004\u0002&-\u0001\r!a\n\t\u000f\u0005M2\u00021\u0001\u00026\u0005)1\u000bT!T\u0011V\u0011\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\u001a\u0002^\t11\u000b\u001e:j]\u001e\faa\u0015'B'\"\u0003\u0013\u0001D*M\u0003NCuLR(M\t\u0016\u0013\u0016!D*M\u0003NCuLR(M\t\u0016\u0013\u0006%A\tdQ\u0016\u001c7NR8mI\u0016\u0014X\t_5tiN$B!a\u001d\u0002zA\u0019a,!\u001e\n\u0007\u0005]tL\u0001\u0003V]&$\bbBA>!\u0001\u0007\u0011QP\u0001\tM>dG-\u001a:JIB!\u0011qPAG\u001d\u0011\t\t)!#\u0011\u0007\u0005\ru,\u0004\u0002\u0002\u0006*\u0019\u0011qQ.\u0002\rq\u0012xn\u001c;?\u0013\r\tYiX\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0014q\u0012\u0006\u0004\u0003\u0017{\u0006f\u0001\t\u0002\u0014B!\u0011QSAR\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006m\u0015AC1o]>$\u0018\r^5p]*!\u0011QTAP\u0003\u001diW\r\u001e:jGNT1!!)Z\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAS\u0003/\u0013Q\u0001V5nK\u0012\fa!\u001a=jgR\u001cH\u0003BAV\u0003c\u00032AXAW\u0013\r\tyk\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\tY(\u0005a\u0001\u0003{B3!EAJ\u0003!9W\r\u001e+ji2,G\u0003BA?\u0003sCq!a\u001f\u0013\u0001\u0004\ti\bK\u0002\u0013\u0003'\u000b\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0007\u0003\u0003\f\t.a5\u0011\t\u0005\r\u0017QZ\u0007\u0003\u0003\u000bTA!a2\u0002J\u00061am\u001c7eKJT1!a3V\u0003\u0019!w.\\1j]&!\u0011qZAc\u0005\u00191u\u000e\u001c3fe\"9\u00111P\nA\u0002\u0005u\u0004\"CAk'A\u0005\t\u0019AAl\u0003\u0015!W\r\u001d;i!\u0011\tY&!7\n\t\u0005m\u0017Q\f\u0002\b\u0013:$XmZ3sQ\r\u0019\u00121S\u0001\u0013M&tGMQ=JI\u0012\"WMZ1vYR$#'\u0006\u0002\u0002d*\"\u0011q[AsW\t\t9\u000f\u0005\u0003\u0002j\u0006EXBAAv\u0015\u0011\ti/a<\u0002\u0013Ut7\r[3dW\u0016$'bAAM?&!\u00111_Av\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$\u0002\"!1\u0002z\u0006m\u0018Q \u0005\b\u0003w*\u0002\u0019AA?\u0011%\t).\u0006I\u0001\u0002\u0004\t9\u000eC\u0005\u0002\u0000V\u0001\n\u00111\u0001\u0002,\u0006\tRM\u001c4pe\u000e,\u0007+\u001a:nSN\u001c\u0018n\u001c8)\u0007U\t\u0019*A\u0011gS:$g+[3xC\ndWMR8mI\u0016\u00148OQ=JI\u0012\"WMZ1vYR$#'A\u0011gS:$g+[3xC\ndWMR8mI\u0016\u00148OQ=JI\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\n)\"\u00111VAs\u0003)1\u0017N\u001c3CsB\u000bG\u000f\u001b\u000b\u0007\u0003\u0003\u0014yAa\u0005\t\u000f\tE\u0001\u00041\u0001\u0002~\u0005!\u0001/\u0019;i\u0011%\t)\u000e\u0007I\u0001\u0002\u0004\u0011)\u0002E\u0002_\u0005/I1A!\u0007`\u0005\rIe\u000e\u001e\u0015\u00041\u0005M\u0015\u0001\u00064j]\u0012\u0014\u0015\u0010U1uQ\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\")\"!QCAs\u0003Ma\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:t))\u00119Ca\r\u00038\t\u0005#Q\t\t\u0007\u0005S\u0011y#!1\u000e\u0005\t-\"\u0002\u0002B\u0017\u0003C\nA!\u001e;jY&!!\u0011\u0007B\u0016\u0005\u0011a\u0015n\u001d;\t\u000f\tU\"\u00041\u0001\u0002~\u0005A\u0001/\u0019:f]RLE\rC\u0004\u0003:i\u0001\rAa\u000f\u0002\tA\fw-\u001a\t\u0004[\nu\u0012b\u0001B ]\n!\u0001+Y4f\u0011%\u0011\u0019E\u0007I\u0001\u0002\u0004\tY+A\feK\u000e|'/\u0019;f/&$\b\u000eU3s[&\u001c8/[8og\"I\u0011q \u000e\u0011\u0002\u0003\u0007\u00111\u0016\u0015\u00045\u0005M\u0015!\b7jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002;1L7\u000f\u001e,jK^\f'\r\\3G_2$WM]:%I\u00164\u0017-\u001e7uIQ\nA!\\8wKR1\u0011\u0011\u0019B)\u0005'Bq!a\u001f\u001e\u0001\u0004\ti\bC\u0004\u0003Vu\u0001\r!! \u0002\u00179,w\u000fU1sK:$\u0018\n\u001a\u0015\u0004;\u0005M\u0015A\u0002:f]\u0006lW\r\u0006\u0004\u0002B\nu#q\f\u0005\b\u0003wr\u0002\u0019AA?\u0011\u001d\u0011\tG\ba\u0001\u0003{\nqA\\3x\u001d\u0006lW\rK\u0002\u001f\u0003'\u000bqb]3be\u000eDG+Z7qY\u0006$Xm\u001d\u000b\u000b\u0005S\u0012\u0019H!\u001e\u0003\u0000\t\u0005\u0005C\u0002B\u0015\u0005_\u0011Y\u0007\u0005\u0003\u0003n\t=TBAAe\u0013\u0011\u0011\t(!3\u0003\u000fI+G.Z1tK\"9\u00111P\u0010A\u0002\u0005u\u0004b\u0002B<?\u0001\u0007!\u0011P\u0001\fe\u0016dW-Y:f\u0017&tG\r\u0005\u0003\u0003n\tm\u0014\u0002\u0002B?\u0003\u0013\u00141BU3mK\u0006\u001cXmS5oI\"9!\u0011H\u0010A\u0002\tm\u0002\"CA\u0000?A\u0005\t\u0019AAVQ\ry\u00121S\u0001\u001ag\u0016\f'o\u00195UK6\u0004H.\u0019;fg\u0012\"WMZ1vYR$C'\u0001\btK\u0006\u00148\r\u001b*fY\u0016\f7/Z:\u0015\u0011\t-%q\u0013BM\u0005c\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0004\u0005#+\u0016AB:fCJ\u001c\u0007.\u0003\u0003\u0003\u0016\n=%a\u0005*fY\u0016\f7/Z*fCJ\u001c\u0007NU3tk2$\bbBA>C\u0001\u0007\u0011Q\u0010\u0005\b\u00057\u000b\u0003\u0019\u0001BO\u0003\u001d1\u0017\u000e\u001c;feN\u0004BAa(\u0003.6\u0011!\u0011\u0015\u0006\u0005\u0005G\u0013)+A\u0003g_Jl7O\u0003\u0003\u0003(\n%\u0016A\u0001<2\u0015\r\u0011Y+V\u0001\u0004CBL\u0017\u0002\u0002BX\u0005C\u0013qBU3mK\u0006\u001cXm\u001d$jYR,'o\u001d\u0005\n\u0005s\t\u0003\u0013!a\u0001\u0005wA3!IAJ\u0003a\u0019X-\u0019:dQJ+G.Z1tKN$C-\u001a4bk2$HeM\u000b\u0003\u0005sSCAa\u000f\u0002f\u0006aQn\u001c<f)\u0016l\u0007\u000f\\1uKRA\u0011Q\u0010B`\u0005\u0003\u0014)\rC\u0004\u0002|\r\u0002\r!! \t\u000f\t\r7\u00051\u0001\u0002~\u0005QA/Z7qY\u0006$X-\u00133\t\u0013\t\u001d7\u0005%AA\u0002\u0005-\u0016\u0001E:i_VdG-T3sO\u0016$V-Y7tQ\r\u0019\u00131S\u0001\u0017[>4X\rV3na2\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u000511M]3bi\u0016$b!!1\u0003R\nM\u0007b\u0002B\u001bK\u0001\u0007\u0011Q\u0010\u0005\b\u0003\u000f,\u0003\u0019AAaQ\r)\u00131\u0013\u000b\t\u0003\u0003\u0014INa7\u0003^\"9!Q\u0007\u0014A\u0002\u0005u\u0004bBAdM\u0001\u0007\u0011\u0011\u0019\u0005\b\u0005?4\u0003\u0019AAV\u0003I\u0019'/Z1uK\u0012+g-Y;miR+\u0017-\\:)\u0007\u0019\n\u0019*A\u0006dQ\u0016\u001c7\u000eT5nSR\u001cHCBA:\u0005O\u0014I\u000fC\u0004\u0002|\u001d\u0002\r!! \t\u000f\tUs\u00051\u0001\u0002~\u0005\u00012\r[3dW\u001a{G\u000eZ3s\t\u0016\u0004H\u000f\u001b\u000b\t\u0003g\u0012yO!=\u0003t\"9\u00111\u0010\u0015A\u0002\u0005u\u0004b\u0002B+Q\u0001\u0007\u0011Q\u0010\u0005\b\u0005kD\u0003\u0019\u0001B|\u00039a\u0017.\\5ugN+G\u000f^5oON\u0004BA!?\u0003\u00006\u0011!1 \u0006\u0004\u0005{,\u0016!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0004\u0002\tm(a\u0004$fCR,(/Z*fiRLgnZ:\u0002#\u001d,G\u000fT5nSR\u001c8+\u001a;uS:<7/\u0006\u0002\u0003x\nyai\u001c7eKJ\fe\u000eZ#wK:$8o\u0005\u0004+;\u000e-1\u0011\u0003\t\u0004=\u000e5\u0011bAB\b?\n9\u0001K]8ek\u000e$\b\u0003BB\n\u0007;qAa!\u0006\u0004\u001a9!\u00111QB\f\u0013\u0005\u0001\u0017bAB\u000e?\u00069\u0001/Y2lC\u001e,\u0017\u0002BB\u0010\u0007C\u0011AbU3sS\u0006d\u0017N_1cY\u0016T1aa\u0007`+\t\t\t-A\u0004g_2$WM\u001d\u0011\u0016\u0005\r%\u0002CBB\n\u0007W\u0019y#\u0003\u0003\u0004.\r\u0005\"aA*fcB!1\u0011GB\u001b\u001b\t\u0019\u0019D\u0003\u0003\u0002.\u0005%\u0017\u0002BB\u001c\u0007g\u0011a\u0002\u0017'SK2,\u0017m]3Fm\u0016tG/A\u0004fm\u0016tGo\u001d\u0011\u0015\r\ru2\u0011IB\"!\r\u0019yDK\u0007\u0002\u0001!9\u0011qY\u0018A\u0002\u0005\u0005\u0007\"CA\u0017_A\u0005\t\u0019AB\u0015\u0003\u0011\u0019w\u000e]=\u0015\r\ru2\u0011JB&\u0011%\t9\r\rI\u0001\u0002\u0004\t\t\rC\u0005\u0002.A\u0002\n\u00111\u0001\u0004*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAB)U\u0011\t\t-!:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u000b\u0016\u0005\u0007S\t)/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005+\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0004d\r%\u0004c\u00010\u0004f%\u00191qM0\u0003\u0007\u0005s\u0017\u0010C\u0005\u0004lU\n\t\u00111\u0001\u0003\u0016\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"a!\u001d\u0011\r\rM4\u0011PB2\u001b\t\u0019)HC\u0002\u0004x}\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019Yh!\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\u001b\t\tC\u0005\u0004l]\n\t\u00111\u0001\u0004d\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tIfa\"\t\u0013\r-\u0004(!AA\u0002\tU\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tU\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002,\u000eU\u0005\"CB6w\u0005\u0005\t\u0019AB2\u0003=1u\u000e\u001c3fe\u0006sG-\u0012<f]R\u001c\bcAB {M)Qh!(\u0004*BQ1qTBS\u0003\u0003\u001cIc!\u0010\u000e\u0005\r\u0005&bABR?\u00069!/\u001e8uS6,\u0017\u0002BBT\u0007C\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83!\u0011\u0019Yk!-\u000e\u0005\r5&\u0002BBX\u0003C\n!![8\n\t\r}1Q\u0016\u000b\u0003\u00073\u000bQ!\u00199qYf$ba!\u0010\u0004:\u000em\u0006bBAd\u0001\u0002\u0007\u0011\u0011\u0019\u0005\n\u0003[\u0001\u0005\u0013!a\u0001\u0007S\tq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019\u0019ma4\u0011\u000by\u001b)m!3\n\u0007\r\u001dwL\u0001\u0004PaRLwN\u001c\t\b=\u000e-\u0017\u0011YB\u0015\u0013\r\u0019im\u0018\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\rE')!AA\u0002\ru\u0012a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII\nqc\u0019:fCR,w+\u001b;i_V$\b+\u001e2mSND\u0017N\\4\u0015\u0011\ru2\u0011\\Bn\u0007;DqA!\u000eE\u0001\u0004\ti\bC\u0004\u0002H\u0012\u0003\r!!1\t\u000f\t}G\t1\u0001\u0002,\u00061A-\u001a7fi\u0016$B!a\u001d\u0004d\"9\u00111P#A\u0002\u0005u\u0004fA#\u0002\u0014\u0006y\u0011M]2iSZ,wJ\u001d#fY\u0016$X\r\u0006\u0004\u0002t\r-8q\u001e\u0005\b\u0007[4\u0005\u0019\u0001B\u000b\u0003%1w\u000e\u001c3feVKG\rC\u0004\u0004r\u001a\u0003\r!! \u0002\u0013I,G.Z1tK&#\u0017AC7fe\u001e,G+Z1ngRA\u00111OB|\u0007s\u001cY\u0010C\u0004\u0002|\u001d\u0003\r!! \t\u000f\t\rw\t1\u0001\u0002~!91Q`$A\u0002\r}\u0018!\u0004;f[Bd\u0017\r^3UK\u0006l7\u000f\u0005\u0004\u0004\u0014\r-B\u0011\u0001\t\u0005\u0005[\"\u0019!\u0003\u0003\u0005\u0006\u0005%'\u0001\u0002+fC6\fAB]3qY\u0006\u001cW\rV3b[N$b!a\u001d\u0005\f\u00115\u0001bBA>\u0011\u0002\u0007\u0011Q\u0010\u0005\b\u0005\u0007D\u0005\u0019AA?\u0003miWM]4f)\u0016l\u0007\u000f\\1uK\u0006sGMR8mI\u0016\u0014H+Z1ngR11q C\n\t/Aq\u0001\"\u0006J\u0001\u0004\u0019y0A\u0006g_2$WM\u001d+fC6\u001c\bbBB\u007f\u0013\u0002\u00071q`\u0001\u000ee\u0016\u001cX\r\u001e+bg.$V-Y7\u0015\t\u0005MDQ\u0004\u0005\b\u0005\u0007T\u0005\u0019AA?\u0003y\u0019'/Z1uK\u0012+g-Y;miR+\u0017-\\:G_J$\u0006.\u001a$pY\u0012,'\u000f\u0006\u0004\u0005$\u0011\u001dB\u0011\u0006\t\u0007\u0007'!)ca\f\n\t\tE2\u0011\u0005\u0005\b\u0003\u000f\\\u0005\u0019AAa\u0011\u001d\u0011)d\u0013a\u0001\u0003{\nqdZ3u\u001d>t\u0017J\u001c5fe&$X\r\u001a$pY\u0012,'OU3gKJ,gnY3t)\u0019!y\u0003\"\u0011\u0005DA1A\u0011\u0007C\u001c\twi!\u0001b\r\u000b\t\u0011U2QO\u0001\b[V$\u0018M\u00197f\u0013\u0011!I\u0004b\r\u0003\u0007M+G\u000f\u0005\u0003\u0003n\u0011u\u0012\u0002\u0002C \u0003\u0013\u0014\u0011CQ1tK\u000e{gNZ5hkJ\fG/[8o\u0011\u001d\tY\b\u0014a\u0001\u0003{Bq\u0001\"\u0012M\u0001\u0004\ti(A\u0006oK^4w\u000e\u001c3fe&#\u0017!F2iK\u000e\\gi\u001c7eKJ\u001c\u0015M\u001c\"f\u001b>4X\r\u001a\u000b\t\u0003g\"Y\u0005\"\u0014\u0005T!9\u00111P'A\u0002\u0005u\u0004b\u0002C(\u001b\u0002\u0007A\u0011K\u0001\u0012]\u0016<hm\u001c7eKJLEm\u00149uS>t\u0007#\u00020\u0004F\u0006u\u0004b\u0002C+\u001b\u0002\u0007\u0011QP\u0001\n_B,'/\u0019;j_:\fQb\u0019:fCR,G)\u001a;bS2\u001cH\u0003CA-\t7\"\t\u0007\"\u001a\t\u000f\u0011uc\n1\u0001\u0005`\u0005q\u0011m\u0019;jm\u0016\u0014V\r\\3bg\u0016\u001c\bCBB\n\u0007W\u0011Y\u0007C\u0004\u0005d9\u0003\r\u0001b\u0018\u00021\u0005,Ho\\*uCJ$\b+\u001a8eS:<'+\u001a7fCN,7\u000fC\u0004\u0005h9\u0003\r\u0001\"\u001b\u0002\u0017%tg/\u00197jIJ+gm\u001d\t\u0007\u0007g\"Y\u0007b\u000f\n\t\u0011e2QO\u0001\u0018G\",7m\u001b+f[Bd\u0017\r^3DC:\u0014U-T8wK\u0012$b!a\u001d\u0005r\u0011M\u0004b\u0002Bb\u001f\u0002\u0007\u0011Q\u0010\u0005\b\u0003wz\u0005\u0019AA?\u0003I9W\r\u001e*v]:Lgn\u001a*fY\u0016\f7/Z:\u0015\t\u0011}C\u0011\u0010\u0005\b\u0003w\u0002\u0006\u0019AA?\u0003m9W\r^!vi>\u001cF/\u0019:u!\u0016tG-\u001b8h%\u0016dW-Y:fgR!Aq\fC@\u0011\u001d\tY(\u0015a\u0001\u0003{\u0002")
public class FolderService
implements Logging {
    private volatile FolderService$FolderAndEvents$ FolderAndEvents$module;
    private final FolderRepository folders;
    private final TeamService teamService;
    private final ReleaseRepository releaseRepository;
    private final TaskService taskService;
    private final ConfigurationRepository configurationRepository;
    private final CiIdService ciIdService;
    private final ReleaseSearchService releaseSearchService;
    private final PermissionChecker permissions;
    private final XLReleaseEventBus eventBus;
    private final ArchivingService archivingService;
    private final String SLASH;
    private final String SLASH_FOLDER;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public FolderService$FolderAndEvents$ FolderAndEvents() {
        if (this.FolderAndEvents$module == null) {
            this.FolderAndEvents$lzycompute$1();
        }
        return this.FolderAndEvents$module;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String SLASH() {
        return this.SLASH;
    }

    public String SLASH_FOLDER() {
        return this.SLASH_FOLDER;
    }

    @Timed
    public void checkFolderExists(String folderId) {
        this.folders.checkFolderExists(folderId);
    }

    @Timed
    public boolean exists(String folderId) {
        return this.folders.exists(folderId);
    }

    @Timed
    public String getTitle(String folderId) {
        String string = folderId;
        String string2 = Ids.ROOT_FOLDER_ID;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new NotFoundException("Folder " + Ids.ROOT_FOLDER_ID + " cannot be found", new Object[0]);
        }
        return (String)this.folders.getTitle(folderId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    @Timed
    public Folder findById(String folderId, Integer depth) {
        return (Folder)this.folders.findById(folderId, depth).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    public Integer findById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    @Timed
    public Folder findViewableFoldersById(String folderId, Integer depth, boolean enforcePermission) {
        return (Folder)this.folders.findViewableFoldersById(folderId, depth, enforcePermission).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find Folder " + folderId, new Object[0]);
        });
    }

    public Integer findViewableFoldersById$default$2() {
        return Predef$.MODULE$.int2Integer(Integer.MAX_VALUE);
    }

    public boolean findViewableFoldersById$default$3() {
        return true;
    }

    @Timed
    public Folder findByPath(String path, int depth) {
        return this.folders.findByPath(path, depth);
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public java.util.List<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions, boolean enforcePermission) {
        block0: {
            if (!enforcePermission) break block0;
            this.permissions.checkViewFolder(parentId);
        }
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.folders.listViewableFolders(parentId, page, decorateWithPermissions, enforcePermission)).asJava();
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    public boolean listViewableFolders$default$4() {
        return true;
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        this.checkFolderExists(newParentId);
        this.checkLimits(folderId, newParentId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)new Some((Object)newParentId), "move");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderMovingAction(folderId, Ids.getParentId((String)folderId), newParentId));
        Folder folder = this.folders.move(folderId, newParentId);
        this.eventBus.publish((XLReleaseEvent)new FolderMovedEvent(folder, Ids.getParentId((String)folderId), newParentId));
        return folder;
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        Checks.checkArgument((!newName.trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Folder folder = this.folders.rename(folderId, newName);
        this.eventBus.publish((XLReleaseEvent)new FolderRenamedEvent(folder, newName));
        return folder;
    }

    @Timed
    public java.util.List<Release> searchTemplates(String folderId, ReleaseKind releaseKind, Page page, boolean enforcePermission) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        TemplateFilters filters = new TemplateFilters();
        filters.setParentId(folderId);
        filters.setKind(releaseKind);
        return this.releaseSearchService.searchTemplates(filters, page.page(), page.resultsPerPage(), enforcePermission).getReleases();
    }

    public boolean searchTemplates$default$4() {
        return true;
    }

    @Timed
    public ReleaseSearchResult searchReleases(String folderId, ReleasesFilters filters, Page page) {
        Checks.checkNotNull((Object)folderId, (String)"missing folderId");
        this.checkFolderExists(folderId);
        filters.setParentId(folderId);
        return this.releaseSearchService.search(filters, page.page(), page.resultsPerPage());
    }

    public Page searchReleases$default$3() {
        return Page$.MODULE$.default();
    }

    @Timed
    public String moveTemplate(String folderId, String templateId, boolean shouldMergeTeams) {
        String newTemplateId = folderId + "/" + Ids.getName((String)templateId);
        this.checkTemplateCanBeMoved(templateId, folderId);
        String string = Ids.getParentId((String)templateId);
        String string2 = folderId;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.logger().info((Function0 & Serializable)() -> "Attempted to move template " + templateId + " to same folder " + folderId + ". Will be ignored.");
            return templateId;
        }
        scala.collection.immutable.Seq templateTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getStoredTeams(templateId)).asScala().toSeq();
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new TemplateMovingAction(templateId, folderId));
        this.releaseRepository.move(templateId, newTemplateId);
        if (shouldMergeTeams) {
            this.mergeTeams(folderId, newTemplateId, (scala.collection.immutable.Seq<Team>)templateTeams);
        } else {
            this.replaceTeams(folderId, newTemplateId);
        }
        this.eventBus.publish((XLReleaseEvent)new ReleaseMovedEvent(templateId, newTemplateId));
        return newTemplateId;
    }

    public boolean moveTemplate$default$3() {
        return true;
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        int allowedFolderDepth;
        String[] folderDepth = parentId.split(this.SLASH_FOLDER());
        FeatureSettings limitsSettings = this.getLimitsSettings();
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)limitsSettings.getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled && folderDepth.length - 1 > (allowedFolderDepth = BoxesRunTime.unboxToInt((Object)limitsSettings.getProperty(Limits$.MODULE$.MAX_FOLDER_DEPTH())))) {
            throw new IllegalArgumentException("Creating Folder exceeds allowed sub-folder depth " + allowedFolderDepth);
        }
        return this.create(parentId, folder, true);
    }

    @Timed
    public Folder create(String parentId, Folder folder, boolean createDefaultTeams) {
        FolderAndEvents result = this.createWithoutPublishing(parentId, folder, createDefaultTeams);
        result.events().foreach((Function1 & Serializable)event -> {
            this.eventBus.publish(event);
            return BoxedUnit.UNIT;
        });
        return result.folder();
    }

    private void checkLimits(String folderId, String newParentId) {
        FeatureSettings limitsSettings = this.getLimitsSettings();
        boolean limitsEnabled = BoxesRunTime.unboxToBoolean((Object)this.getLimitsSettings().getProperty(Limits$.MODULE$.ENABLED()));
        if (limitsEnabled) {
            this.checkFolderDepth(folderId, newParentId, limitsSettings);
            return;
        }
    }

    private void checkFolderDepth(String folderId, String newParentId, FeatureSettings limitsSettings) {
        int newFolderIdSplitLength;
        int allowedFolderDepth = BoxesRunTime.unboxToInt((Object)limitsSettings.getProperty(Limits$.MODULE$.MAX_FOLDER_DEPTH()));
        int newParentIdFolderDepth = newParentId.split(this.SLASH_FOLDER()).length - 1;
        if (newParentIdFolderDepth > allowedFolderDepth) {
            throw new IllegalArgumentException("Moving folder/folders is not within the allowed sub-folder depth " + allowedFolderDepth);
        }
        String[] newFolderIdSplit = folderId.split(this.SLASH());
        String newFolderIdInDb = newFolderIdSplit[(newFolderIdSplitLength = newFolderIdSplit.length) - 1];
        int findChildrenOfNewFolder = this.folders.findNumberOfChildrenForAFolder(newFolderIdInDb);
        int newToBeFolderLength = newParentIdFolderDepth + findChildrenOfNewFolder;
        if (newToBeFolderLength > allowedFolderDepth) {
            throw new IllegalArgumentException("Moving folder/folders is not within the allowed sub-folder depth " + allowedFolderDepth);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FeatureSettings getLimitsSettings() {
        void var1_1;
        Optional<void> optional = this.configurationRepository.findFirstByType(Type.valueOf((String)Limits$.MODULE$.TYPE_LIMITS()));
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)Limits$.MODULE$.TYPE_LIMITS()).getDescriptor().newInstance("");
        feature.generateId();
        return (FeatureSettings)optional.orElse(var1_1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public FolderAndEvents createWithoutPublishing(String parentId, Folder folder, boolean createDefaultTeams) {
        Checks.checkArgument((!folder.getTitle().trim().isEmpty() ? 1 : 0) != 0, (String)"Folder name cannot be blank", (Object[])new Object[0]);
        Checks.checkArgument((folder.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Folder name must be 255 characters or less", (Object[])new Object[0]);
        this.checkFolderExists(parentId);
        this.folders.checkNameIsUnique(parentId, folder.getTitle());
        if (Ids.isNullId((String)folder.getId()) || !Ids.isFolderId((String)folder.getId())) {
            folder.setId(this.ciIdService.getUniqueId(Type.valueOf(Folder.class), parentId));
        } else {
            folder.setId(parentId + "/" + Ids.getName((String)folder.getId()));
        }
        this.logger().info((Function0 & Serializable)() -> "Creating folder " + folder.getTitle() + " with id " + folder.getId());
        Folder saved = this.folders.create(Ids.getParentId((String)folder.getId()), folder);
        .colon.colon events = new .colon.colon((Object)new FolderCreatedEvent(folder), (List)Nil$.MODULE$);
        if (createDefaultTeams) {
            String string = parentId;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                events = (scala.collection.immutable.Seq)events.$plus$plus(this.createDefaultTeamsForTheFolder(saved, parentId));
                return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
            }
        }
        events = (scala.collection.immutable.Seq)events.$colon$plus((Object)new TeamsUpdatedEvent(folder.getId()));
        return new FolderAndEvents(this, saved, (scala.collection.immutable.Seq<XLReleaseEvent>)events);
    }

    @Timed
    public void delete(String folderId) {
        String string = Ids.ROOT_FOLDER_ID;
        String string2 = folderId;
        Checks.checkArgument(((string == null ? string2 != null : !string.equals(string2)) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.checkFolderExists(folderId);
        this.checkFolderCanBeMoved(folderId, (Option<String>)None$.MODULE$, "delete");
        this.eventBus.publishAndFailOnError((XLReleaseEvent)new FolderDeletingAction(folderId));
        this.logger().info((Function0 & Serializable)() -> "Deleting folder " + folderId);
        Folder folder = (Folder)this.folders.findById(folderId, this.folders.findById$default$2()).get();
        this.folders.delete(folderId, (Function2<Object, String, BoxedUnit>)(Function2 & Serializable)(folderUid, releaseId) -> {
            this.archiveOrDelete(BoxesRunTime.unboxToInt((Object)folderUid), releaseId);
            return BoxedUnit.UNIT;
        });
        this.eventBus.publish((XLReleaseEvent)new FolderDeletedEvent(folder));
    }

    private void archiveOrDelete(int folderUid, String releaseId) {
        ReleaseStatus status = this.releaseRepository.getStatus(releaseId);
        this.logger().trace((Function0 & Serializable)() -> "archiveOrDelete(" + folderUid + ", " + releaseId + "): status=" + status + " [inactive? " + status.isInactive() + "]");
        if (status.isInactive()) {
            Release release = this.releaseRepository.findById(releaseId);
            if (this.archivingService.shouldArchive(release)) {
                this.archivingService.preArchiveRelease(release);
            }
            this.logger().trace((Function0 & Serializable)() -> "archiveRelease(" + releaseId + ")");
            this.archivingService.archiveRelease(releaseId);
            return;
        }
        this.logger().trace((Function0 & Serializable)() -> "deleteRelease(" + releaseId + ")");
        this.releaseRepository.delete(releaseId);
    }

    private void mergeTeams(String folderId, String templateId, scala.collection.immutable.Seq<Team> templateTeams) {
        if (templateTeams.nonEmpty()) {
            scala.collection.immutable.Seq folderTeams = CollectionConverters$.MODULE$.ListHasAsScala(this.teamService.getEffectiveTeams(folderId)).asScala().toSeq();
            String folderTeamsContainerId = (String)folderTeams.headOption().map((Function1 & Serializable)team -> Ids.getParentId((String)team.getId())).getOrElse((Function0 & Serializable)() -> folderId);
            scala.collection.immutable.Seq<Team> mergedTeams = this.mergeTemplateAndFolderTeams((scala.collection.immutable.Seq<Team>)folderTeams, templateTeams);
            String folderTitle = this.getTitle(folderId);
            this.teamService.saveTeamsToPlatform(folderTeamsContainerId, CollectionConverters$.MODULE$.SeqHasAsJava(mergedTeams).asJava());
            this.teamService.deleteTeamsFromPlatform(templateId);
            this.eventBus.publish((XLReleaseEvent)new TeamsMergedEvent(templateId, folderTitle));
            return;
        }
    }

    private void replaceTeams(String folderId, String templateId) {
        this.resetTaskTeam(templateId);
        String folderTitle = this.getTitle(folderId);
        this.eventBus.publish((XLReleaseEvent)new TeamsRemovedInTemplateEvent(templateId, folderTitle));
        this.teamService.deleteTeamsFromPlatform(templateId);
    }

    private scala.collection.immutable.Seq<Team> mergeTemplateAndFolderTeams(scala.collection.immutable.Seq<Team> folderTeams, scala.collection.immutable.Seq<Team> templateTeams) {
        Map folderTeamsMap = (Map)Map$.MODULE$.apply(((IterableOnceOps)folderTeams.map((Function1 & Serializable)team -> new Tuple2((Object)team.getTeamName(), team))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq());
        templateTeams.foreach((Function1 & Serializable)templateTeam -> {
            Option option = folderTeamsMap.get((Object)templateTeam.getTeamName());
            if (None$.MODULE$.equals(option)) {
                templateTeam.setId(null);
                return folderTeamsMap.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)templateTeam.getTeamName()), templateTeam));
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                Team folderTeam = (Team)some.value();
                scala.collection.immutable.Set memberSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getMembers()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getMembers()).asScala().toSet());
                scala.collection.immutable.Set roleSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getRoles()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getRoles()).asScala().toSet());
                scala.collection.immutable.Set permissionSet = (scala.collection.immutable.Set)CollectionConverters$.MODULE$.ListHasAsScala(folderTeam.getPermissions()).asScala().toSet().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(templateTeam.getPermissions()).asScala().toSet());
                folderTeam.setMembers(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)memberSet.toSeq()).asJava());
                folderTeam.setRoles(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)roleSet.toSeq()).asJava());
                folderTeam.setPermissions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)permissionSet.toSeq()).asJava());
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)option);
        });
        return folderTeamsMap.values().toSeq();
    }

    private void resetTaskTeam(String templateId) {
        Release template = this.releaseRepository.findById(templateId);
        if (!template.isWorkflow()) {
            template.getAllTasks().forEach(task -> $this.taskService.applyNewTeam(null, (Task)task, false));
            return;
        }
    }

    private List<XLReleaseEvent> createDefaultTeamsForTheFolder(Folder folder, String parentId) {
        String currentUser = Permissions.getAuthenticatedUserName();
        Team folderOwner = FolderService.newTeam$1();
        folderOwner.setTeamName("Folder Owner");
        folderOwner.setPermissions(CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getFolderPermissions()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$createDefaultTeamsForTheFolder$1(x$1)))).asJava());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getReleaseGroupPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDeliveryPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getDashboardPermissions());
        folderOwner.getPermissions().addAll(XLReleasePermissions.getAppPipelinesPermissions());
        Team templateOwner = FolderService.newTeam$1();
        templateOwner.setTeamName("Template Owner");
        templateOwner.setPermissions(XLReleasePermissions.getTemplateOnlyPermissions());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_FOLDER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_TRIGGER.getPermissionName());
        templateOwner.getPermissions().add(XLReleasePermissions.VIEW_APP_PIPELINES.getPermissionName());
        Team releaseAdmin = FolderService.newTeam$1();
        Buffer releaseAdminPermissions = (Buffer)((SeqOps)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getReleasePermissions()).asScala().concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getTriggerPermissions()).asScala())).concat((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(XLReleasePermissions.getWorkflowExecutionPermissions()).asScala())).concat((IterableOnce)new .colon.colon((Object)XLReleasePermissions.VIEW_FOLDER.getPermissionName(), (List)new .colon.colon((Object)XLReleasePermissions.VIEW_APP_PIPELINES.getPermissionName(), (List)Nil$.MODULE$)));
        releaseAdmin.setTeamName("Release Admin");
        releaseAdmin.addPermissions((String[])releaseAdminPermissions.toArray(ClassTag$.MODULE$.apply(String.class)));
        if (currentUser != null) {
            folderOwner.addMember(currentUser);
            templateOwner.addMember(currentUser);
            releaseAdmin.addMember(currentUser);
        }
        Tuple2<java.util.List<Team>, java.util.List<XLReleaseEvent>> result = this.teamService.saveTeamsToPlatformWithoutPublishing(folder.getId(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)folderOwner, (List)new .colon.colon((Object)templateOwner, (List)new .colon.colon((Object)releaseAdmin, (List)Nil$.MODULE$)))).asJava(), true);
        return CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)result._2()).asScala().toList();
    }

    public scala.collection.mutable.Set<BaseConfiguration> getNonInheritedFolderReferences(String folderId, String newfolderId) {
        Page x$1 = new Page(0L, Integer.MAX_VALUE, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ReleaseStatus.class));
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        Buffer releases = CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala();
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        releases.foreach((Function1 & Serializable)release -> {
            FolderService.$anonfun$getNonInheritedFolderReferences$1(this, newfolderId, folderId, res, release);
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private void checkFolderCanBeMoved(String folderId, Option<String> newfolderIdOption, String operation) {
        scala.collection.mutable.Set<BaseConfiguration> set;
        scala.collection.immutable.Seq<Release> activeReleases = this.getRunningReleases(folderId);
        scala.collection.immutable.Seq<Release> autoStartPendingReleases = this.getAutoStartPendingReleases(folderId);
        Option<String> option = newfolderIdOption;
        if (option instanceof Some) {
            Some some = (Some)option;
            String newFolderId = (String)some.value();
            set = this.getNonInheritedFolderReferences(folderId, newFolderId);
        } else if (None$.MODULE$.equals(option)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.mutable.Set<BaseConfiguration> invalidRefs = set;
        if (activeReleases.nonEmpty() || autoStartPendingReleases.nonEmpty() || invalidRefs.nonEmpty()) {
            this.logger().warn((Function0 & Serializable)() -> "Tried to " + operation + " folder " + folderId + ", which has active releases " + ((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$2 -> x$2.getId())).mkString(", ") + " or pending releases with auto start option enabled: " + ((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$3 -> x$3.getId())).mkString(", "));
            String details = this.createDetails(activeReleases, autoStartPendingReleases, (Set<BaseConfiguration>)invalidRefs);
            throw new ItemInUseException("You cannot " + operation + " this folder. The folder or its subfolders contain " + details, new Object[0]);
        }
    }

    private String createDetails(scala.collection.immutable.Seq<Release> activeReleases, scala.collection.immutable.Seq<Release> autoStartPendingReleases, Set<BaseConfiguration> invalidRefs) {
        Object details;
        block2: {
            details = "";
            if (activeReleases.nonEmpty()) {
                details = (String)details + "active releases: " + ((IterableOnceOps)activeReleases.map((Function1 & Serializable)x$4 -> x$4.getTitle())).mkString("\"", "\", \"", "\"");
            }
            if (autoStartPendingReleases.nonEmpty()) {
                details = (String)details + "pending releases with auto start: " + ((IterableOnceOps)autoStartPendingReleases.map((Function1 & Serializable)x$5 -> x$5.getTitle())).mkString("\"", "\", \"", "\"");
            }
            if (!invalidRefs.nonEmpty()) break block2;
            details = (String)details + "configuration references not inherited by the destination folder: " + ((IterableOnceOps)invalidRefs.map((Function1 & Serializable)x$6 -> x$6.getTitle())).mkString("\"", "\", \"", "\"");
        }
        return details;
    }

    private void checkTemplateCanBeMoved(String templateId, String folderId) {
        Release template = this.releaseRepository.findById(templateId);
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)template)).asScala();
        if (!((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$1(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).forall((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$checkTemplateCanBeMoved$3(folderId, c)))) {
            throw new ItemInUseException("You cannot move this template. It contains references to configurations that are not global or not inherited by the destination folder.", new Object[0]);
        }
    }

    private scala.collection.immutable.Seq<Release> getRunningReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = ReleaseStatus.ACTIVE_STATUSES;
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        String x$4 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        boolean x$6 = ReleaseSearchByParams$.MODULE$.apply$default$6();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$4, x$5, x$6))).asScala().toSeq();
    }

    private scala.collection.immutable.Seq<Release> getAutoStartPendingReleases(String folderId) {
        Page x$1 = new Page(0L, 15L, Predef$.MODULE$.int2Integer(1), Page$.MODULE$.apply$default$4());
        ReleaseStatus[] x$2 = (ReleaseStatus[])((Object[])new ReleaseStatus[]{ReleaseStatus.PLANNED});
        Right<String, String> x$3 = ReleaseSearchByParams$.MODULE$.byAncestor(folderId);
        boolean x$4 = true;
        String x$5 = ReleaseSearchByParams$.MODULE$.apply$default$4();
        String x$6 = ReleaseSearchByParams$.MODULE$.apply$default$5();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.releaseRepository.search(new ReleaseSearchByParams(x$1, (Either<String, String>)x$3, x$2, x$5, x$6, true))).asScala().toSeq();
    }

    private final void FolderAndEvents$lzycompute$1() {
        FolderService folderService = this;
        synchronized (folderService) {
            if (this.FolderAndEvents$module == null) {
                this.FolderAndEvents$module = new FolderService$FolderAndEvents$(this);
            }
        }
    }

    private static final Team newTeam$1() {
        return (Team)Type.valueOf(Team.class).getDescriptor().newInstance(null);
    }

    public static final /* synthetic */ boolean $anonfun$createDefaultTeamsForTheFolder$1(String x$1) {
        String string = x$1;
        String string2 = XLReleasePermissions.EDIT_FOLDER_TEAMS.getPermissionName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getNonInheritedFolderReferences$2(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ void $anonfun$getNonInheritedFolderReferences$1(FolderService $this, String newfolderId$1, String folderId$7, scala.collection.mutable.Set res$1, Release release) {
        scala.collection.mutable.Set refs = CollectionConverters$.MODULE$.SetHasAsScala(CiHelper.getExternalReferences((ConfigurationItem)release)).asScala();
        ((IterableOnceOps)((IterableOps)refs.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)FolderService.$anonfun$getNonInheritedFolderReferences$2(c)))).map((Function1 & Serializable)c -> $this.configurationRepository.read(c.getId()))).foreach((Function1 & Serializable)c -> {
            if (c.getFolderId() != null && !newfolderId$1.startsWith(c.getFolderId()) && !c.getFolderId().equals(folderId$7)) {
                return BoxesRunTime.boxToBoolean((boolean)res$1.add(c));
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$1(ConfigurationItem c) {
        return c instanceof BaseConfiguration;
    }

    public static final /* synthetic */ boolean $anonfun$checkTemplateCanBeMoved$3(String folderId$9, BaseConfiguration c) {
        return c.getFolderId() == null || folderId$9.startsWith(c.getFolderId());
    }

    public FolderService(FolderRepository folders, TeamService teamService, ReleaseRepository releaseRepository, TaskService taskService, ConfigurationRepository configurationRepository, CiIdService ciIdService, ReleaseSearchService releaseSearchService, PermissionChecker permissions, XLReleaseEventBus eventBus, ArchivingService archivingService) {
        this.folders = folders;
        this.teamService = teamService;
        this.releaseRepository = releaseRepository;
        this.taskService = taskService;
        this.configurationRepository = configurationRepository;
        this.ciIdService = ciIdService;
        this.releaseSearchService = releaseSearchService;
        this.permissions = permissions;
        this.eventBus = eventBus;
        this.archivingService = archivingService;
        Logging.$init$((Logging)this);
        this.SLASH = "/";
        this.SLASH_FOLDER = "/Folder";
    }

    public class FolderAndEvents
    implements Product,
    Serializable {
        private final Folder folder;
        private final scala.collection.immutable.Seq<XLReleaseEvent> events;
        public final /* synthetic */ FolderService $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Folder folder() {
            return this.folder;
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> events() {
            return this.events;
        }

        public FolderAndEvents copy(Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            return new FolderAndEvents(this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer(), folder, events);
        }

        public Folder copy$default$1() {
            return this.folder();
        }

        public scala.collection.immutable.Seq<XLReleaseEvent> copy$default$2() {
            return this.events();
        }

        public String productPrefix() {
            return "FolderAndEvents";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.folder();
                }
                case 1: {
                    return this.events();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FolderAndEvents;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "folder";
                }
                case 1: {
                    return "events";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FolderAndEvents)) return false;
            if (((FolderAndEvents)object).com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() != this.com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FolderAndEvents folderAndEvents = (FolderAndEvents)x$1;
            Folder folder = this.folder();
            Folder folder2 = folderAndEvents.folder();
            if (folder == null) {
                if (folder2 != null) {
                    return false;
                }
            } else if (!folder.equals(folder2)) return false;
            scala.collection.immutable.Seq<XLReleaseEvent> seq = this.events();
            scala.collection.immutable.Seq<XLReleaseEvent> seq2 = folderAndEvents.events();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!folderAndEvents.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ FolderService com$xebialabs$xlrelease$service$FolderService$FolderAndEvents$$$outer() {
            return this.$outer;
        }

        public FolderAndEvents(FolderService $outer, Folder folder, scala.collection.immutable.Seq<XLReleaseEvent> events) {
            this.folder = folder;
            this.events = events;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

