/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.authentication;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.xlplatform.utils.SecureRandomHolder;
import com.xebialabs.xlrelease.repository.CustomPersistentTokenRepository;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.AbstractRememberMeServices;
import org.springframework.security.web.authentication.rememberme.CookieTheftException;
import org.springframework.security.web.authentication.rememberme.InvalidCookieException;
import org.springframework.security.web.authentication.rememberme.PersistentRememberMeToken;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationException;
import org.springframework.util.Assert;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001\u0002\u0010 \u0001!B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001d)\u0007A1A\u0005\n\u0019Daa\u001b\u0001!\u0002\u00139\u0007b\u00027\u0001\u0005\u0004%IA\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B4\t\u000f9\u0004\u0001\u0019!C\u0005M\"9q\u000e\u0001a\u0001\n\u0013\u0001\bB\u0002<\u0001A\u0003&q\rC\u0004x\u0001\u0001\u0007I\u0011\u00024\t\u000fa\u0004\u0001\u0019!C\u0005s\"11\u0010\u0001Q!\n\u001dDQ\u0001 \u0001\u0005\nuDq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u0011Q\u000e\u0001\u0005B\u0005=\u0004bBA<\u0001\u0011E\u0011\u0011\u0010\u0005\b\u0003w\u0002A\u0011CA=\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!a$\u0001\t\u0013\t\t\nC\u0004\u0002\u0016\u0002!\t!a&\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006\u0002DAU\u0001A\u0005\t\u0011!A\u0005\u0002\u0005-\u0006\u0002DA^\u0001A\u0005\t\u0011!A\u0005\u0002\u0005u&a\t-m!\u0016\u00148/[:uK:$Hk\\6f]J+W.Z7cKJlUmU3sm&\u001cWm\u001d\u0006\u0003A\u0005\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002#G\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003I\u0015\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0019\n1aY8n\u0007\u0001\u0019\"\u0001A\u0015\u0011\u0005)2T\"A\u0016\u000b\u00051j\u0013A\u0003:f[\u0016l'-\u001a:nK*\u0011\u0001E\f\u0006\u0003_A\n1a^3c\u0015\t\t$'\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u0019D'A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005)\u0014aA8sO&\u0011qg\u000b\u0002\u001b\u0003\n\u001cHO]1diJ+W.Z7cKJlUmU3sm&\u001cWm]\u0001\u0004W\u0016L\bC\u0001\u001eD\u001d\tY\u0014\t\u0005\u0002=\u007f5\tQH\u0003\u0002?O\u00051AH]8pizR\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\na\u0001\u0015:fI\u00164\u0017B\u0001#F\u0005\u0019\u0019FO]5oO*\u0011!iP\u0001\u0013kN,'\u000fR3uC&d7oU3sm&\u001cW\r\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006YQo]3sI\u0016$\u0018-\u001b7t\u0015\ta\u0005'\u0001\u0003d_J,\u0017B\u0001(J\u0005I)6/\u001a:EKR\f\u0017\u000e\\:TKJ4\u0018nY3\u0002\u001fQ|7.\u001a8SKB|7/\u001b;pef\u0004\"!\u0015+\u000e\u0003IS!aU\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002V%\ny2)^:u_6\u0004VM]:jgR,g\u000e\u001e+pW\u0016t'+\u001a9pg&$xN]=\u0002'M,'O^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005a[V\"A-\u000b\u0005i\u001b\u0013\u0001\u00033fa2|\u00170\u001b;\n\u0005qK&aE*feZ,'oQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0003`C\n\u001cG\r\u0005\u0002a\u00015\tq\u0004C\u00039\u000b\u0001\u0007\u0011\bC\u0003G\u000b\u0001\u0007q\tC\u0003P\u000b\u0001\u0007\u0001\u000bC\u0003W\u000b\u0001\u0007q+A\u000bE\u000b\u001a\u000bU\u000b\u0014+`'\u0016\u0013\u0016*R*`\u0019\u0016su\t\u0016%\u0016\u0003\u001d\u0004\"\u0001[5\u000e\u0003}J!A[ \u0003\u0007%sG/\u0001\fE\u000b\u001a\u000bU\u000b\u0014+`'\u0016\u0013\u0016*R*`\u0019\u0016su\t\u0016%!\u0003Q!UIR!V\u0019R{FkT&F\u001d~cUIT$U\u0011\u0006)B)\u0012$B+2#v\fV(L\u000b:{F*\u0012(H)\"\u0003\u0013\u0001D:fe&,7\u000fT3oORD\u0017\u0001E:fe&,7\u000fT3oORDw\fJ3r)\t\tH\u000f\u0005\u0002ie&\u00111o\u0010\u0002\u0005+:LG\u000fC\u0004v\u0017\u0005\u0005\t\u0019A4\u0002\u0007a$\u0013'A\u0007tKJLWm\u001d'f]\u001e$\b\u000eI\u0001\fi>\\WM\u001c'f]\u001e$\b.A\bu_.,g\u000eT3oORDw\fJ3r)\t\t(\u0010C\u0004v\u001d\u0005\u0005\t\u0019A4\u0002\u0019Q|7.\u001a8MK:<G\u000f\u001b\u0011\u0002\r\u001d|\u0007+Y:u)\u0015q\u0018QBA\t!\ry\u0018\u0011B\u0007\u0003\u0003\u0003QA!a\u0001\u0002\u0006\u0005!Q\u000f^5m\u0015\t\t9!\u0001\u0003kCZ\f\u0017\u0002BA\u0006\u0003\u0003\u0011A\u0001R1uK\"1\u0011q\u0002\tA\u0002y\f\u0011bZ5wK:$\u0015\r^3\t\u000f\u0005M\u0001\u00031\u0001\u0002\u0016\u0005AA/[7f\u0013:l5\u000fE\u0002i\u0003/I1!!\u0007@\u0005\u0011auN\\4\u0002\u0011\u001d|g)\u001e;ve\u0016$RA`A\u0010\u0003CAa!a\u0004\u0012\u0001\u0004q\bbBA\n#\u0001\u0007\u0011QC\u0001\u000f_:dunZ5o'V\u001c7-Z:t)\u001d\t\u0018qEA \u0003\u0013Bq!!\u000b\u0013\u0001\u0004\tY#A\u0004sKF,Xm\u001d;\u0011\t\u00055\u00121H\u0007\u0003\u0003_QA!!\r\u00024\u0005!\u0001\u000e\u001e;q\u0015\u0011\t)$a\u000e\u0002\u000fM,'O\u001e7fi*\u0011\u0011\u0011H\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\ti$a\f\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f\u001e\u0005\b\u0003\u0003\u0012\u0002\u0019AA\"\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BA\u0017\u0003\u000bJA!a\u0012\u00020\t\u0019\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\"9\u00111\n\nA\u0002\u00055\u0013\u0001G:vG\u000e,7o\u001d4vY\u0006+H\u000f[3oi&\u001c\u0017\r^5p]B!\u0011qJA)\u001b\u0005Y\u0015bAA*\u0017\nq\u0011)\u001e;iK:$\u0018nY1uS>t\u0017A\u00069s_\u000e,7o]!vi>dunZ5o\u0007>|7.[3\u0015\u0011\u0005e\u0013qLA5\u0003W\u00022\u0001SA.\u0013\r\ti&\u0013\u0002\f+N,'\u000fR3uC&d7\u000fC\u0004\u0002bM\u0001\r!a\u0019\u0002\u0019\r|wn[5f)>\\WM\\:\u0011\t!\f)'O\u0005\u0004\u0003Oz$!B!se\u0006L\bbBA\u0015'\u0001\u0007\u00111\u0006\u0005\b\u0003\u0003\u001a\u0002\u0019AA\"\u0003\u0019awnZ8viR9\u0011/!\u001d\u0002t\u0005U\u0004bBA\u0015)\u0001\u0007\u00111\u0006\u0005\b\u0003\u0003\"\u0002\u0019AA\"\u0011\u0019\u0001C\u00031\u0001\u0002N\u0005\u0011r-\u001a8fe\u0006$XmU3sS\u0016\u001cH)\u0019;b+\u0005I\u0014!E4f]\u0016\u0014\u0018\r^3U_.,g\u000eR1uC\u0006I\u0011\r\u001a3D_>\\\u0017.\u001a\u000b\bc\u0006\u0005\u00151RAG\u0011\u001d\t\u0019i\u0006a\u0001\u0003\u000b\u000bQ\u0001^8lK:\u00042AKAD\u0013\r\tIi\u000b\u0002\u001a!\u0016\u00148/[:uK:$(+Z7f[\n,'/T3U_.,g\u000eC\u0004\u0002*]\u0001\r!a\u000b\t\u000f\u0005\u0005s\u00031\u0001\u0002D\u0005iq-\u001a;D_>\\\u0017.\u001a)bi\"$2!OAJ\u0011\u001d\tI\u0003\u0007a\u0001\u0003W\tqb]3u'\u0016\u0014\u0018.Z:MK:<G\u000f\u001b\u000b\u0004c\u0006e\u0005\"\u00028\u001a\u0001\u00049\u0017AD:fiR{7.\u001a8MK:<G\u000f\u001b\u000b\u0004c\u0006}\u0005\"B<\u001b\u0001\u00049\u0017aF:fiR{7.\u001a8WC2LG-\u001b;z'\u0016\u001cwN\u001c3t)\r\t\u0018Q\u0015\u0005\u0007\u0003O[\u0002\u0019A4\u0002)Q|7.\u001a8WC2LG-\u001b;z'\u0016\u001cwN\u001c3t\u0003]\u0001(o\u001c;fGR,G\rJ4fi\u000e{wn[5f\u001d\u0006lW\r\u0006\u0003\u0002.\u0006eFCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&\u0002BA[\u0003\u000b\tA\u0001\\1oO&\u0019A)a-\t\u000fUd\u0012\u0011!a\u0001?\u00061\u0002O]8uK\u000e$X\r\u001a\u0013eK\u000e|G-Z\"p_.LW\r\u0006\u0003\u0002@\u0006\u001dG\u0003BAa\u0003\u0007\u0004R\u0001[A3\u0003_Cq!!2\u001e\u0001\u0004\ty+A\u0006d_>\\\u0017.\u001a,bYV,\u0007bB;\u001e\u0003\u0003\u0005\ra\u0018")
public class XlPersistentTokenRememberMeServices
extends AbstractRememberMeServices {
    private final CustomPersistentTokenRepository tokenRepository;
    private final ServerConfiguration serverConfiguration;
    private final int DEFAULT_SERIES_LENGTH;
    private final int DEFAULT_TOKEN_LENGTH;
    private int seriesLength;
    private int tokenLength;

    public /* synthetic */ String protected$getCookieName(XlPersistentTokenRememberMeServices x$1) {
        return x$1.getCookieName();
    }

    public /* synthetic */ String[] protected$decodeCookie(XlPersistentTokenRememberMeServices x$1, String cookieValue) {
        return x$1.decodeCookie(cookieValue);
    }

    private int DEFAULT_SERIES_LENGTH() {
        return this.DEFAULT_SERIES_LENGTH;
    }

    private int DEFAULT_TOKEN_LENGTH() {
        return this.DEFAULT_TOKEN_LENGTH;
    }

    private int seriesLength() {
        return this.seriesLength;
    }

    private void seriesLength_$eq(int x$1) {
        this.seriesLength = x$1;
    }

    private int tokenLength() {
        return this.tokenLength;
    }

    private void tokenLength_$eq(int x$1) {
        this.tokenLength = x$1;
    }

    private Date goPast(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long pastTime = givenTimeInMs - timeInMs;
        return new Date(pastTime);
    }

    private Date goFuture(Date givenDate, long timeInMs) {
        long givenTimeInMs = givenDate.getTime();
        long futureTime = givenTimeInMs + timeInMs;
        return new Date(futureTime);
    }

    public void onLoginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        if (this.serverConfiguration.isClientSessionRememberEnabled()) {
            String username = successfulAuthentication.getName();
            this.logger.debug((Object)("Creating new persistent login for user " + username));
            PersistentRememberMeToken persistentToken = new PersistentRememberMeToken(username.toLowerCase(), this.generateSeriesData(), this.generateTokenData(), new Date());
            try {
                this.tokenRepository.createNewToken(persistentToken);
                this.addCookie(persistentToken, request, response);
            }
            catch (Exception e) {
                this.logger.error((Object)"Failed to save persistent token ", (Throwable)e);
            }
            return;
        }
    }

    public UserDetails processAutoLoginCookie(String[] cookieTokens, HttpServletRequest request, HttpServletResponse response) {
        if (cookieTokens.length != 2) {
            throw new InvalidCookieException("Cookie token did not contain " + 2 + " tokens, but contained '" + Arrays.asList((Object[])new String[][]{cookieTokens}) + "'");
        }
        String presentedSeries = cookieTokens[0];
        String presentedToken = cookieTokens[1];
        PersistentRememberMeToken token = this.tokenRepository.getTokenForSeries(presentedSeries);
        if (token == null) {
            throw new RememberMeAuthenticationException("No persistent token found for series id: " + presentedSeries);
        }
        String string = presentedToken;
        String string2 = token.getTokenValue();
        if (string == null ? string2 != null : !string.equals(string2)) {
            List<PersistentRememberMeToken> previousTokenList = this.tokenRepository.getPreviousTokenForSeries(presentedSeries, token.getTokenValue());
            Optional<PersistentRememberMeToken> previousOldToken = previousTokenList.stream().filter(previousToken -> {
                String string = previousToken.getTokenValue();
                String string2 = presentedToken;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).findFirst();
            if (!previousOldToken.isPresent()) {
                this.tokenRepository.removeUserTokens(token.getUsername());
                throw new CookieTheftException(this.messages.getMessage("PersistentTokenBasedRememberMeServices.cookieStolen", "Invalid remember-me token (Series/token) mismatch. Implies previous cookie theft attack."));
            }
            this.tokenRepository.removeTokenInSeriesBeforeGivenDate(token.getSeries(), this.goPast(previousOldToken.get().getDate(), 60000L));
        }
        if (this.goFuture(token.getDate(), (long)this.getTokenValiditySeconds() * 1000L).getTime() < System.currentTimeMillis()) {
            throw new RememberMeAuthenticationException("Remember-me login has expired");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing persistent login token for user '" + token.getUsername() + "', series '" + token.getSeries() + "'"));
        }
        if (!this.serverConfiguration.isClientSessionRememberEnabled()) {
            throw new RememberMeAuthenticationException("Remember-me login is disabled");
        }
        try {
            if (this.goFuture(token.getDate(), 30000L).getTime() < System.currentTimeMillis()) {
                PersistentRememberMeToken newToken = new PersistentRememberMeToken(token.getUsername().toLowerCase(), token.getSeries(), this.generateTokenData(), new Date());
                this.tokenRepository.createNewToken(newToken);
                this.addCookie(newToken, request, response);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to update token: ", (Throwable)e);
            throw new RememberMeAuthenticationException("Autologin failed due to data access problem");
        }
        return this.getUserDetailsService().loadUserByUsername(token.getUsername());
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication != null) {
            this.tokenRepository.removeUserTokens(authentication.getName().toLowerCase());
        } else {
            Option$.MODULE$.apply((Object)request.getCookies()).foreach((Function1 & Serializable)cookies -> {
                XlPersistentTokenRememberMeServices.$anonfun$logout$1(this, cookies);
                return BoxedUnit.UNIT;
            });
        }
        SecurityContextLogoutHandler securityContextLogoutHandler = new SecurityContextLogoutHandler();
        securityContextLogoutHandler.logout(request, response, null);
    }

    public String generateSeriesData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.seriesLength())));
    }

    public String generateTokenData() {
        return new String(Base64.getEncoder().encode(SecureRandomHolder.getRandomByteArray((int)this.tokenLength())));
    }

    private void addCookie(PersistentRememberMeToken token, HttpServletRequest request, HttpServletResponse response) {
        String cookieValue = this.encodeCookie((String[])((Object[])new String[]{token.getSeries(), token.getTokenValue()}));
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        int maxAge = this.getTokenValiditySeconds();
        cookie.setMaxAge(maxAge);
        cookie.setPath(this.getCookiePath(request));
        if (maxAge < 1) {
            cookie.setVersion(1);
        }
        if (!this.serverConfiguration.isSsl()) {
            cookie.setSecure(this.serverConfiguration.isSecureCookieEnabled());
        } else {
            cookie.setSecure(request.isSecure());
        }
        cookie.setHttpOnly(true);
        cookie.setComment("__SAME_SITE_STRICT__");
        response.addCookie(cookie);
    }

    private String getCookiePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(contextPath))) {
            return contextPath;
        }
        return "/";
    }

    public void setSeriesLength(int seriesLength) {
        this.seriesLength_$eq(seriesLength);
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength_$eq(tokenLength);
    }

    public void setTokenValiditySeconds(int tokenValiditySeconds) {
        Assert.isTrue((tokenValiditySeconds > 0 ? 1 : 0) != 0, (String)"tokenValiditySeconds must be positive for this implementation");
        super.setTokenValiditySeconds(tokenValiditySeconds);
    }

    public static final /* synthetic */ boolean $anonfun$logout$2(XlPersistentTokenRememberMeServices $this, Cookie x$1) {
        String string = x$1.getName();
        String string2 = $this.protected$getCookieName($this);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$logout$3(XlPersistentTokenRememberMeServices $this, Cookie c) {
        String[] values = $this.protected$decodeCookie($this, c.getValue());
        ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable)series -> {
            $this.tokenRepository.removeUserTokensBasedOnSeries(series);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logout$1(XlPersistentTokenRememberMeServices $this, Cookie[] cookies) {
        ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])cookies), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)XlPersistentTokenRememberMeServices.$anonfun$logout$2($this, x$1))).foreach((Function1 & Serializable)c -> {
            XlPersistentTokenRememberMeServices.$anonfun$logout$3($this, c);
            return BoxedUnit.UNIT;
        });
    }

    public XlPersistentTokenRememberMeServices(String key, UserDetailsService userDetailsService, CustomPersistentTokenRepository tokenRepository, ServerConfiguration serverConfiguration) {
        this.tokenRepository = tokenRepository;
        this.serverConfiguration = serverConfiguration;
        super(key, userDetailsService);
        this.DEFAULT_SERIES_LENGTH = 16;
        this.DEFAULT_TOKEN_LENGTH = 16;
        this.seriesLength = this.DEFAULT_SERIES_LENGTH();
        this.tokenLength = this.DEFAULT_TOKEN_LENGTH();
    }
}

