/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.core.rest.api.PermissionResource;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.risk.domain.progress.ReleaseProgress;
import com.xebialabs.xlrelease.search.PlanItemSearchResult;
import com.xebialabs.xlrelease.search.ReleaseCountResults;
import com.xebialabs.xlrelease.search.ReleaseDateRangeResults;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.PhaseService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.SseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.AbortReleaseForm;
import com.xebialabs.xlrelease.views.BulkActionResultView;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.PhaseFullView;
import com.xebialabs.xlrelease.views.PhaseOverview;
import com.xebialabs.xlrelease.views.PlanItemSearchView;
import com.xebialabs.xlrelease.views.ReleaseForm;
import com.xebialabs.xlrelease.views.ReleaseFullView;
import com.xebialabs.xlrelease.views.ReleaseOverviewResultsView;
import com.xebialabs.xlrelease.views.ReleaseOverviewSearchView;
import com.xebialabs.xlrelease.views.ReleasePermissionsView;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TemplateFilters;
import com.xebialabs.xlrelease.views.TemplateOverviewResultsView;
import com.xebialabs.xlrelease.views.converters.PhaseViewConverter;
import com.xebialabs.xlrelease.views.converters.PlanItemViewConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseFormConverter;
import com.xebialabs.xlrelease.views.converters.ReleaseViewConverter;
import com.xebialabs.xlrelease.views.converters.TasksViewConverter;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

@Path(value="/releases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ReleaseResource {
    private ReleaseService releaseService;
    private PermissionChecker permissions;
    private ReleaseSearchService releasesSearch;
    private ReleaseActorService releaseActorService;
    private TaskAccessService taskAccessService;
    private ReleaseViewConverter releaseViewConverter;
    private PhaseViewConverter phaseViewConverter;
    private TasksViewConverter tasksViewConverter;
    private PlanItemViewConverter planItemViewConverter;
    private TeamMemberViewConverter teamMemberViewConverter;
    private TeamService teamService;
    private ReleaseFormConverter releaseFormConverter;
    private EventBus eventBus;
    private PhaseService phaseService;
    private SseService sseService;

    @Autowired
    public ReleaseResource(ReleaseService releaseService, PermissionChecker permissions, ReleaseSearchService releasesSearch, ReleaseActorService releaseActorService, TaskAccessService taskAccessService, ReleaseViewConverter releaseViewConverter, PhaseViewConverter phaseViewConverter, TasksViewConverter tasksViewConverter, PlanItemViewConverter planItemViewConverter, TeamMemberViewConverter teamMemberViewConverter, TeamService teamService, ReleaseFormConverter releaseFormConverter, EventBus eventBus, PhaseService phaseService, SseService sseService) {
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.releasesSearch = releasesSearch;
        this.releaseActorService = releaseActorService;
        this.taskAccessService = taskAccessService;
        this.planItemViewConverter = planItemViewConverter;
        this.releaseViewConverter = releaseViewConverter;
        this.phaseViewConverter = phaseViewConverter;
        this.tasksViewConverter = tasksViewConverter;
        this.teamMemberViewConverter = teamMemberViewConverter;
        this.teamService = teamService;
        this.releaseFormConverter = releaseFormConverter;
        this.eventBus = eventBus;
        this.phaseService = phaseService;
        this.sseService = sseService;
    }

    @POST
    @Timed
    @Path(value="templates/search")
    public TemplateOverviewResultsView searchTemplateOverview(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, TemplateFilters templateFilters) {
        TemplateOverviewResultsView result = this.releasesSearch.templatesOverview(templateFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(this.releasesSearch.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE()));
        return result;
    }

    @GET
    @Timed
    @Path(value="templates/search")
    public PlanItemSearchView getAllTemplateIds(@QueryParam(value="page") Long page, @QueryParam(value="folderId") String folderId, @QueryParam(value="numberbypage") Long numberByPage, @QueryParam(value="permission") String permissionName, @QueryParam(value="matchTemplate") String matchTemplate) {
        PlanItemSearchResult searchResult;
        if (!StringUtils.isEmpty((Object)folderId) && !Ids.isRoot((String)folderId)) {
            this.permissions.checkViewFolder(folderId);
            this.permissions.canViewRelease(folderId);
        }
        if (permissionName == null) {
            searchResult = this.releasesSearch.findAllTemplateIdsAndTitles(page != null ? page : 0L, numberByPage, (Option<String>)OptionConverters.toScala(Optional.ofNullable(folderId)), (Option<String>)OptionConverters.toScala(Optional.ofNullable(matchTemplate)));
        } else {
            Permission permission = Permission.find((String)permissionName);
            if (permission == null) {
                throw new PermissionResource.UnknownPermissionException(permissionName);
            }
            searchResult = this.releasesSearch.findAllTemplateIdsAndTitles(page != null ? page : 0L, numberByPage, (Option<String>)OptionConverters.toScala(Optional.ofNullable(folderId)), permission, (Option<String>)OptionConverters.toScala(Optional.ofNullable(matchTemplate)));
        }
        return this.planItemViewConverter.toSearchView(searchResult);
    }

    @GET
    @Timed
    @Path(value="template/search")
    public PlanItemSearchView getTemplateTitleById(@QueryParam(value="matchTemplate") String templateId) {
        PlanItemSearchResult templateResult = this.releasesSearch.findTemplateTitleById(templateId);
        return this.planItemViewConverter.toSearchView(templateResult);
    }

    @POST
    @Timed
    @Path(value="templates")
    public ReleaseFullView createTemplate(ReleaseForm releaseForm) {
        if (releaseForm.getParentId() == null || Ids.ROOT_FOLDER_ID.equals(releaseForm.getParentId())) {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, releaseForm.getParentId());
        }
        Preconditions.checkArgument((boolean)releaseForm.hasTitle(), (Object)"Template title is mandatory");
        Preconditions.checkArgument((boolean)releaseForm.hasValidDates(), (Object)"Dates are not valid");
        Release release = releaseForm.getTemplateId() == null ? this.releaseService.createTemplate(this.releaseFormConverter.toRelease(releaseForm), releaseForm.getParentId()) : this.releaseService.copyTemplate(releaseForm.getTemplateId(), releaseForm.getTitle(), releaseForm.getDescription());
        return this.getReleaseFullView(release);
    }

    @DELETE
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}")
    public Response deleteTemplate(@PathParam(value="templateId") @IdParam String templateId) {
        if (Ids.isInFolder((String)templateId)) {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, Ids.getParentId((String)templateId));
        } else {
            this.permissions.check(XLReleasePermissions.CREATE_TEMPLATE);
        }
        this.releaseActorService.deleteTemplate(templateId);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PUT
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}")
    public ReleaseFullView updateTemplate(@PathParam(value="templateId") @IdParam String templateId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        return this.getReleaseFullView(this.releaseActorService.updateTemplate(templateId, this.releaseFormConverter.toRelease(releaseForm)));
    }

    @POST
    @Timed
    @Path(value="search")
    public ReleaseOverviewSearchView searchReleases(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, @QueryParam(value="depth") Integer depth, @QueryParam(value="properties") List<String> properties, @QueryParam(value="extensions") List<String> extensions, ReleasesFilters releasesFilters) {
        int RELEASE_WITH_VARIABLES_AND_PHASES_DEPTH = 2;
        Integer loadDepth = Optional.ofNullable(depth).orElse(2);
        boolean includeOriginTemplateData = extensions.contains("template");
        ReleaseSearchResult searchResult = this.releasesSearch.search(releasesFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(this.releasesSearch.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE()), false, true, includeOriginTemplateData);
        return this.releaseViewConverter.toOverviewSearchView(searchResult, properties, loadDepth, extensions);
    }

    @POST
    @Timed
    @Path(value="overview")
    public ReleaseOverviewResultsView searchReleaseOverview(@QueryParam(value="page") Long page, @QueryParam(value="numberbypage") Long numberByPage, ReleasesFilters releasesFilters) {
        ReleaseOverviewResultsView searchResult = this.releasesSearch.releasesOverview(releasesFilters, page != null ? page : 0L, Optional.ofNullable(numberByPage).orElse(this.releasesSearch.DEFAULT_NUMBER_OF_RELEASES_PER_PAGE()));
        return searchResult;
    }

    @POST
    @Timed
    @Path(value="count")
    public ReleaseCountResults countReleases(ReleasesFilters releasesFilters) {
        return this.releasesSearch.count(releasesFilters);
    }

    @POST
    @Timed
    @Path(value="daterange")
    public ReleaseDateRangeResults getReleaseDateRange(ReleasesFilters releasesFilters) {
        return this.releasesSearch.getReleaseDateRange(releasesFilters);
    }

    @POST
    public ReleaseFullView createRelease(ReleaseForm releaseForm) {
        Release release;
        Preconditions.checkArgument((boolean)releaseForm.hasTitle(), (Object)"Release title is mandatory");
        if (!releaseForm.hasValidDates()) {
            throw new BadRequestException("Scheduled start date must be before due date");
        }
        if (releaseForm.isFromTemplate()) {
            String parentId = releaseForm.getParentId();
            String targetFolderId = parentId != null ? parentId : Ids.findFolderId((String)releaseForm.getTemplateId());
            this.permissions.checkIsAllowedToCreateReleaseFromTemplate(releaseForm.getTemplateId(), targetFolderId);
            release = this.releaseService.createFromTemplate(releaseForm.getTemplateId(), this.releaseFormConverter.toRelease(releaseForm), releaseForm.getParentId());
        } else {
            if (releaseForm.getKind() != ReleaseKind.RELEASE) {
                throw new IllegalArgumentException("Kind must be 'RELEASE'");
            }
            this.permissions.checkIsAllowedToCreateReleaseInFolder(releaseForm.getParentId(), releaseForm.getKind());
            release = this.releaseService.createWithoutTemplate(this.releaseFormConverter.toRelease(releaseForm), releaseForm.getParentId());
        }
        return this.getReleaseFullView(release);
    }

    @PUT
    @Timed
    @Path(value="{releaseId:((?!templates).)*Release[^/-]*}")
    public ReleaseFullView updateRelease(@PathParam(value="releaseId") @IdParam String releaseId, ReleaseForm releaseForm) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        return this.getReleaseFullViewWithProperties(this.releaseActorService.updateRelease(releaseId, this.releaseFormConverter.toRelease(releaseForm)), Collections.singletonList("riskProfile"));
    }

    @GET
    @Timed
    @Path(value="templates/{templateId:.*Release[^/-]*}/duration")
    public Integer getTemplateDuration(@PathParam(value="templateId") @IdParam String templateId) {
        Release template = this.releaseService.findByIdIncludingArchived(templateId);
        if (!template.isTemplate()) {
            throw new BadRequestException("templateId does not belong to a template");
        }
        this.permissions.checkView(template);
        Duration duration = this.releaseService.getDurationOf(template);
        return duration.toStandardSeconds().getSeconds();
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/start")
    public ReleaseFullView startRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.check(XLReleasePermissions.START_RELEASE, releaseId);
        this.releaseService.checkCanBeStarted(releaseId);
        return this.getReleaseFullView(this.releaseActorService.startRelease(releaseId, User.AUTHENTICATED_USER));
    }

    @POST
    @Path(value="start")
    public BulkActionResultView startReleases(List<String> releaseIds) {
        List<String> allowedReleaseIds = this.permissions.filterStartableReleases(releaseIds);
        if (allowedReleaseIds.isEmpty()) {
            return new BulkActionResultView(allowedReleaseIds);
        }
        List<Release> startedReleases = this.releaseActorService.startReleases(allowedReleaseIds, User.AUTHENTICATED_USER);
        List startedReleaseIds = startedReleases.stream().map(BaseConfigurationItem::getId).map(arg_0 -> ((IdType)IdType.DOMAIN).convertToViewId(arg_0)).collect(Collectors.toList());
        return new BulkActionResultView(startedReleaseIds);
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/abort")
    public ReleaseFullView abortRelease(@PathParam(value="releaseId") @IdParam String releaseId, AbortReleaseForm abortReleaseForm) {
        this.permissions.checkAbort(releaseId);
        return this.getReleaseFullView(this.releaseActorService.abortRelease(releaseId, abortReleaseForm.getAbortComment()));
    }

    @POST
    @Path(value="abort")
    public BulkActionResultView abortReleases(AbortReleaseForm abortReleaseForm) {
        List<String> allowedReleaseIds = this.permissions.filterAbortableReleases(abortReleaseForm.getReleasesIds());
        if (allowedReleaseIds.isEmpty()) {
            return new BulkActionResultView(allowedReleaseIds);
        }
        List<Release> abortedReleases = this.releaseActorService.abortReleases(allowedReleaseIds, abortReleaseForm.getAbortComment());
        List abortedReleaseIds = abortedReleases.stream().map(BaseConfigurationItem::getId).map(arg_0 -> ((IdType)IdType.DOMAIN).convertToViewId(arg_0)).collect(Collectors.toList());
        return new BulkActionResultView(abortedReleaseIds);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}")
    public ReleaseFullView getRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        this.permissions.checkView(release);
        return this.getReleaseFullViewWithProperties(release, Collections.singletonList("riskProfile"));
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/status")
    public ReleaseStatus getReleaseStatus(@PathParam(value="releaseId") @IdParam String releaseId) {
        return this.releaseService.getStatus(releaseId);
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/move")
    public PhaseFullView movePhase(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        return this.getPhaseFullView(this.releaseActorService.movePhase(releaseId, movementIndexes));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tasks/move")
    public TaskFullView moveTask(@PathParam(value="releaseId") @IdParam String releaseId, MovementIndexes movementIndexes) {
        this.permissions.checkEdit(releaseId);
        return this.getTaskFullView(this.releaseActorService.moveTask(releaseId, movementIndexes));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/add")
    public PhaseFullView addPhase(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEdit(releaseId);
        Phase phase = this.releaseActorService.addPhase(releaseId);
        return this.getPhaseFullView(phase);
    }

    @PUT
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tasks/duplicate/{taskId:.*Task[^/-]*}")
    public TaskFullView duplicateTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String originTaskId) {
        this.permissions.checkEdit(releaseId);
        return this.getTaskFullView(this.releaseActorService.duplicateTask(releaseId, originTaskId));
    }

    @PUT
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/phases/duplicate/{phaseId:.*Phase[^/-]*}")
    public PhaseFullView duplicatePhase(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="phaseId") @IdParam String originPhaseId) {
        this.permissions.checkEdit(releaseId);
        return this.getPhaseFullView(this.releaseActorService.duplicatePhase(releaseId, originPhaseId));
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/permissions")
    public ReleasePermissionsView getPermissions(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkEditSecurity(releaseId);
        Release release = this.releaseService.findByIdIncludingArchived(releaseId);
        List permissions = release.isTemplate() ? XLReleasePermissions.getTemplatePermissions() : XLReleasePermissions.getReleasePermissions();
        return new ReleasePermissionsView(permissions, release, this.teamMemberViewConverter);
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/restartPhases")
    public ReleaseFullView restartPhases(@PathParam(value="releaseId") @IdParam String releaseId, @QueryParam(value="fromPhaseId") @IdParam String phaseId, @QueryParam(value="fromTaskId") @IdParam String taskId, @QueryParam(value="phaseVersion") PhaseVersion phaseVersion) {
        this.permissions.check(XLReleasePermissions.RESTART_PHASE, releaseId);
        return this.getReleaseFullView(this.releaseActorService.restartPhase(releaseId, phaseId, taskId, phaseVersion));
    }

    @POST
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/resume")
    public ReleaseFullView resume(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkAny(releaseId, XLReleasePermissions.RESTART_PHASE, XLReleasePermissions.EDIT_RELEASE);
        return this.getReleaseFullView(this.releaseActorService.resume(releaseId));
    }

    @DELETE
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/attachments/{attachmentId:.*Attachment[^/-]*}")
    public void deleteAttachment(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE, releaseId);
        this.releaseActorService.deleteAttachment(releaseId, attachmentId);
    }

    @DELETE
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/{taskId:.*Task[^/-]*}/attachments/{attachmentId:.*Attachment[^/-]*}")
    public void deleteAttachmentFromTask(@PathParam(value="releaseId") @IdParam String releaseId, @PathParam(value="taskId") @IdParam String taskId, @PathParam(value="attachmentId") @IdParam String attachmentId) {
        this.permissions.checkIsAllowedToEditAttachmentsOnTask(taskId);
        this.releaseActorService.deleteAttachmentFromTask(releaseId, taskId, attachmentId);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/teams/assignable")
    public Collection<Team> getAssignableTeams(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkReassignTaskPermission(releaseId);
        List<Team> teamsIncludingInherited = this.teamService.getEffectiveTeams(releaseId);
        Predicate<Team> withoutTemplateOwner = team -> !team.getTeamName().equals("Template Owner");
        return teamsIncludingInherited.stream().filter(withoutTemplateOwner).collect(Collectors.toList());
    }

    @POST
    @Path(value="{releaseId:.*Release[^/-]*}/follow")
    public void followRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releaseService.findById(releaseId, ResolveOptions.WITHOUT_DECORATORS());
        this.permissions.checkView(release);
        this.sseService.subscribeTopicToUser(release.getId());
    }

    @DELETE
    @Path(value="{releaseId:.*Release[^/-]*}/follow")
    public void unfollowRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        Release release = this.releaseService.findById(releaseId, ResolveOptions.WITHOUT_DECORATORS());
        this.sseService.unsubscribeTopicToUser(release.getId());
    }

    @GET
    @Path(value="tags")
    public Set<String> getAllTags() {
        return this.releaseService.getAllTags(500);
    }

    @GET
    @Path(value="tags/archived")
    public Set<String> getAllArchivedTags() {
        return this.releaseService.getAllArchivedTags(500);
    }

    private ReleaseFullView getReleaseFullView(Release release) {
        return this.getReleaseFullViewWithProperties(release, Collections.emptyList());
    }

    private ReleaseFullView getReleaseFullViewWithProperties(Release release, List<String> properties) {
        return this.releaseViewConverter.toFullView(release, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser(), properties, Collections.singletonList("progress"), Integer.MAX_VALUE);
    }

    private PhaseFullView getPhaseFullView(Phase phase) {
        return this.phaseViewConverter.toFullView(phase, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    private TaskFullView getTaskFullView(Task task) {
        return this.tasksViewConverter.toFullView(task, this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser());
    }

    @GET
    @Path(value="{releaseId:.*Release[^/-]*}/phases")
    public List<PhaseOverview> getPhases(@PathParam(value="releaseId") @IdParam String releaseId) {
        List<Phase> phases = this.releaseService.getPhases(releaseId);
        ReleaseProgress releaseProgress = this.releaseService.getProgress(releaseId);
        List<PhaseOverview> results = phases.stream().map(p -> {
            String phaseProgress;
            PhaseOverview overview = new PhaseOverview();
            String justPhaseId = Ids.getReleaselessChildId((String)p.getId());
            String fullPhaseId = releaseId + "/" + justPhaseId;
            overview.setId(fullPhaseId);
            overview.setColor(p.getColor());
            overview.setTitle(p.getTitle());
            overview.setStatus(p.getStatus());
            long totalTasks = 0L;
            long doneTasks = 0L;
            if (releaseProgress != null && null != (phaseProgress = (String)releaseProgress.getPhasesProgress().get(overview.getId()))) {
                String[] vals = phaseProgress.split(";");
                totalTasks = Long.parseLong(vals[0]);
                doneTasks = Long.parseLong(vals[1]);
            }
            overview.setTotalTasks(totalTasks);
            overview.setTasksCompleted(doneTasks);
            return overview;
        }).collect(Collectors.toList());
        return results;
    }
}

