/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.views.TaskAccessView;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.customscripts.ScriptTypes;
import com.xebialabs.xlrelease.domain.ContainerTaskDefinition;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskDefinition;
import com.xebialabs.xlrelease.domain.utils.TaskTypes;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.ConfigurationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskAccessService {
    private final ScriptTypes scriptTypes;
    private final ConfigurationRepository configurationRepository;
    private final ConfigurationService configurationService;
    private final RoleService roleService;
    private final PermissionEnforcer permissionEnforcer;

    @Autowired
    public TaskAccessService(ScriptTypes scriptTypes, ConfigurationRepository configurationRepository, ConfigurationService configurationService, RoleService roleService, PermissionEnforcer permissionEnforcer) {
        this.scriptTypes = scriptTypes;
        this.configurationRepository = configurationRepository;
        this.configurationService = configurationService;
        this.roleService = roleService;
        this.permissionEnforcer = permissionEnforcer;
    }

    @Timed
    public List<TaskAccessView> getTaskAccesses() {
        List<TaskAccessView> taskAccessViews = this.getAllTaskAccessViews();
        List<TaskAccess> taskAccesses = this.readTaskAccesses();
        return this.mergeWithTaskAccesses(taskAccessViews, taskAccesses);
    }

    private List<TaskAccessView> getAllTaskAccessViews() {
        return Stream.of(TaskTypes.getDefaultTaskTypes(), this.scriptTypes.getPythonScriptTypes(), this.scriptTypes.getContainerTaskTypes()).flatMap(Collection::stream).map(this::taskToAccessView).collect(Collectors.toList());
    }

    private TaskAccessView taskToAccessView(Type defaultType) {
        return new TaskAccessView(TaskDefinition.getDisplayGroup((Type)defaultType), defaultType.toString(), TaskDefinition.getDisplayName((Type)defaultType), true, new ArrayList());
    }

    private List<TaskAccess> readTaskAccesses() {
        return this.configurationRepository.findAllByType(Type.valueOf(TaskAccess.class));
    }

    private List<TaskAccessView> mergeWithTaskAccesses(List<TaskAccessView> taskAccessViews, List<TaskAccess> taskAccesses) {
        ImmutableMap accessesByTaskType = Maps.uniqueIndex(taskAccessViews, TaskAccessView::getTaskType);
        for (TaskAccess taskAccess : taskAccesses) {
            String taskType = taskAccess.getName();
            if (!accessesByTaskType.containsKey(taskType)) continue;
            TaskAccessView taskAccessView = (TaskAccessView)accessesByTaskType.get(taskType);
            taskAccessView.setAllowedToAll(taskAccess.isAllowedToAll());
            taskAccessView.getRoles().addAll(taskAccess.getRoles());
        }
        return taskAccessViews;
    }

    @Timed
    public List<Type> getAllowedTaskTypesForAuthenticatedUser() {
        List roles = this.roleService.getRolesFor(Permissions.getAuthentication());
        boolean isAdmin = this.permissionEnforcer.isCurrentUserAdmin();
        HashSet<String> roleNamesForAuthenticatedUser = new HashSet<String>(this.transform(roles, Role::getName));
        return this.getTaskAccesses().stream().filter(taskAccess -> isAdmin || taskAccess.isGrantedForRoles(roleNamesForAuthenticatedUser)).map(TaskAccessView::toType).collect(Collectors.toList());
    }

    private <T, R> List<R> transform(List<T> collection, Function<T, R> transform) {
        return collection.stream().map(transform).collect(Collectors.toList());
    }

    @Timed
    public List<TaskDefinition> getTaskDefinitions() {
        List<Type> allowedTaskTypesForAuthenticatedUser = this.getAllowedTaskTypesForAuthenticatedUser();
        return this.transform(this.getAllTaskAccessViews(), taskAccessView -> {
            Type type = taskAccessView.toType();
            boolean isAllowed = allowedTaskTypesForAuthenticatedUser.stream().anyMatch(allowedType -> allowedType.equals((Object)type));
            if (PythonScriptDefinition.isScriptDefinition((Type)type)) {
                return new PythonScriptDefinition(type, isAllowed);
            }
            if (ContainerTaskDefinition.isContainerTaskDefinition((Type)type)) {
                return new ContainerTaskDefinition(type, isAllowed);
            }
            return new TaskDefinition(type, isAllowed);
        });
    }

    @Timed
    public void checkIfAuthenticatedUserCanUseTask(Task task) {
        this.checkIfAuthenticatedUserCanUseTasks(Collections.singletonList(task));
    }

    @Timed
    public void checkIfAuthenticatedUserCanUseTasks(List<Task> tasks) {
        this.checkIfAuthenticatedUserCanUseTaskTypes(this.transform(tasks, Task::getTaskType));
    }

    @Timed
    public void checkIfAuthenticatedUserCanUseTaskType(Type taskType) {
        this.checkIfAuthenticatedUserCanUseTaskTypes(Collections.singletonList(taskType));
    }

    @Timed
    public void checkIfAuthenticatedUserCanUseTaskTypes(List<Type> taskTypes) {
        if (null == Permissions.getAuthenticatedUserName()) {
            return;
        }
        HashSet<Type> rejectedTaskTypes = new HashSet<Type>(taskTypes);
        this.getAllowedTaskTypesForAuthenticatedUser().forEach(rejectedTaskTypes::remove);
        if (!rejectedTaskTypes.isEmpty() && !ScriptTypes.UNKNOWN_TYPES.containsAll(rejectedTaskTypes)) {
            throw PermissionDeniedException.withMessage((String)String.format("Task use is not granted to you for types : '%s'", ((Object)rejectedTaskTypes).toString()));
        }
    }

    @Timed
    public void updateTaskAccesses(List<TaskAccessView> taskAccessesView) {
        taskAccessesView.stream().map(taskAccessView -> new TaskAccess(taskAccessView.getTaskType(), taskAccessView.isAllowedToAll(), taskAccessView.getRoles())).toList().forEach(this.configurationService::createOrUpdate);
    }

    public List<Type> getAllTaskTypes() {
        return Stream.of(TaskTypes.getDefaultTaskTypes(), this.scriptTypes.getPythonScriptTypes(), this.scriptTypes.getContainerTaskTypes()).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

