/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.configuration.ArchivingSettings;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.configuration.CustomLogoSettings;
import com.xebialabs.xlrelease.configuration.ExecutionLogPurgeSettings;
import com.xebialabs.xlrelease.configuration.FeatureSettings;
import com.xebialabs.xlrelease.configuration.PollingSettings;
import com.xebialabs.xlrelease.configuration.ReportsSettings;
import com.xebialabs.xlrelease.configuration.ThemeColor;
import com.xebialabs.xlrelease.configuration.ThemeColors$;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.BaseSettings;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001B\t\u0013\u0001mA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)\u0001\b\u0001C\u0001s!)a\b\u0001C\u0001\u007f!)a\b\u0001C\u0001A\")q\r\u0001C\u0001Q\")!\u000e\u0001C\u0001W\")\u0011\u000f\u0001C\u0001e\")Q\u000f\u0001C\u0001m\")Q\u0010\u0001C\u0005}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003{Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002P\u0001!\t!!\u0015\u0003)\r{gNZ5hkJ\fG/[8o'\u0016\u0014h/[2f\u0015\t\u0019B#A\u0004tKJ4\u0018nY3\u000b\u0005U1\u0012!\u0003=me\u0016dW-Y:f\u0015\t9\u0002$A\u0005yK\nL\u0017\r\\1cg*\t\u0011$A\u0002d_6\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012)\u001b\u0005!#BA\u0013'\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00059\u0013\u0001C4sSjTH.\u001a3\n\u0005%\"#a\u0002'pO\u001eLgnZ\u0001\u0018G>tg-[4ve\u0006$\u0018n\u001c8SKB|7/\u001b;pef\u0004\"\u0001L\u0018\u000e\u00035R!A\f\u000b\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00021[\t92i\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/_\u0001\tKZ,g\u000e\u001e\"vgB\u00111GN\u0007\u0002i)\u0011Q\u0007F\u0001\u0007KZ,g\u000e^:\n\u0005]\"$!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"2A\u000f\u001f>!\tY\u0004!D\u0001\u0013\u0011\u0015Q3\u00011\u0001,\u0011\u0015\t4\u00011\u00013\u00039\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016$2\u0001\u0011$T!\t\tE)D\u0001C\u0015\t\u0019E#\u0001\u0004e_6\f\u0017N\\\u0005\u0003\u000b\n\u0013\u0011CQ1tK\u000e{gNZ5hkJ\fG/[8o\u0011\u00159E\u00011\u0001I\u0003\tIG\r\u0005\u0002J!:\u0011!J\u0014\t\u0003\u0017zi\u0011\u0001\u0014\u0006\u0003\u001bj\ta\u0001\u0010:p_Rt\u0014BA(\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=s\u0002\"\u0002+\u0005\u0001\u0004\u0001\u0015!E2p]\u001aLw-\u001e:bi&|g.\u0013;f[\"\u0012AA\u0016\t\u0003/zk\u0011\u0001\u0017\u0006\u00033j\u000b!\"\u00198o_R\fG/[8o\u0015\tYF,A\u0004nKR\u0014\u0018nY:\u000b\u0005uC\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005}C&!\u0002+j[\u0016$GCA1e!\ti\"-\u0003\u0002d=\t!QK\\5u\u0011\u0015)W\u00011\u0001A\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"\u0012QAV\u0001\u0005e\u0016\fG\r\u0006\u0002AS\")qI\u0002a\u0001\u0011\u00061Q\r_5tiN$\"\u0001\\8\u0011\u0005ui\u0017B\u00018\u001f\u0005\u001d\u0011un\u001c7fC:DQaR\u0004A\u0002!C#a\u0002,\u0002\r\u0011,G.\u001a;f)\t\t7\u000fC\u0003H\u0011\u0001\u0007\u0001\n\u000b\u0002\t-\u0006\u0001r-\u001a;UQ\u0016lWmU3ui&twm]\u000b\u0002oB\u0011\u0001P_\u0007\u0002s*\u0011Q\rF\u0005\u0003wf\u0014Q\u0002\u00165f[\u0016\u001cV\r\u001e;j]\u001e\u001c\bFA\u0005W\u0003Y\u0019wN\u001c<feR\u001cu\u000e\\8s\u001d\u0006lW\rV8D_\u0012,GCA<\u0000\u0011\u0019\t\tA\u0003a\u0001o\u0006iA\u000f[3nKN+G\u000f^5oON\fab]1wK\u000e+8\u000f^8n\u0019><w\u000e\u0006\u0003\u0002\b\u00055\u0001c\u0001=\u0002\n%\u0019\u00111B=\u0003%\r+8\u000f^8n\u0019><wnU3ui&twm\u001d\u0005\b\u0003\u001fY\u0001\u0019AA\u0004\u0003I\u0019Wo\u001d;p[2{wm\\*fiRLgnZ:)\u0005-1\u0016AE4fi\u001a+\u0017\r^;sKN+G\u000f^5oON$\"!a\u0006\u0011\r\u0005e\u00111EA\u0014\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011\u0001B;uS2T!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYB\u0001\u0003MSN$\bc\u0001=\u0002*%\u0019\u00111F=\u0003\u001f\u0019+\u0017\r^;sKN+G\u000f^5oOND#\u0001\u0004,\u0002#\u001d,GoU=ti\u0016l7+\u001a;uS:<7\u000f\u0006\u0002\u00024A1\u0011\u0011DA\u0012\u0003k\u00012!QA\u001c\u0013\r\tID\u0011\u0002\r\u0005\u0006\u001cXmU3ui&twm\u001d\u0015\u0003\u001bY#B!a\n\u0002@!1\u0011\u0011\t\bA\u0002!\u000b1BZ3biV\u0014X\rV=qK\"\u0012aBV\u0001\u0014g\u00064XMR3biV\u0014XmU3ui&twm\u001d\u000b\u0004C\u0006%\u0003bBA&\u001f\u0001\u0007\u0011qC\u0001\tM\u0016\fG/\u001e:fg\"\u0012qBV\u0001\rg\u00064XmU3ui&twm\u001d\u000b\u0004C\u0006M\u0003bBA+!\u0001\u0007\u00111G\u0001\tg\u0016$H/\u001b8hg\"\u0012\u0001C\u0016\u0015\u0004\u0001\u0005m\u0003\u0003BA/\u0003Wj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u000bgR,'/Z8usB,'\u0002BA3\u0003O\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0003\u0003S\n1a\u001c:h\u0013\u0011\ti'a\u0018\u0003\u000fM+'O^5dK\u0002")
public class ConfigurationService
implements Logging {
    private final ConfigurationRepository configurationRepository;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ConfigurationService configurationService = this;
        synchronized (configurationService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public BaseConfiguration createOrUpdate(String id, BaseConfiguration configurationItem) {
        BaseConfiguration baseConfiguration = configurationItem;
        if (baseConfiguration instanceof ReportsSettings) {
            ReportsSettings reportsSettings = (ReportsSettings)baseConfiguration;
            reportsSettings.validate();
        } else if (baseConfiguration instanceof ArchivingSettings) {
            ArchivingSettings archivingSettings = (ArchivingSettings)baseConfiguration;
            archivingSettings.validate();
        } else if (baseConfiguration instanceof PollingSettings) {
            PollingSettings pollingSettings = (PollingSettings)baseConfiguration;
            pollingSettings.validate();
        } else if (baseConfiguration instanceof AuditReportSettings) {
            AuditReportSettings auditReportSettings = (AuditReportSettings)baseConfiguration;
            auditReportSettings.validate();
        } else if (baseConfiguration instanceof ExecutionLogPurgeSettings) {
            ExecutionLogPurgeSettings executionLogPurgeSettings = (ExecutionLogPurgeSettings)baseConfiguration;
            executionLogPurgeSettings.validate();
        } else if (baseConfiguration instanceof CustomLogoSettings) {
            CustomLogoSettings customLogoSettings = (CustomLogoSettings)baseConfiguration;
            customLogoSettings.validateContentType();
        }
        configurationItem.setId(id);
        this.createOrUpdate(configurationItem);
        return this.read(id);
    }

    @Timed
    public void createOrUpdate(BaseConfiguration configuration) {
        if (!Ids.isNullId((String)configuration.getId()) && this.configurationRepository.exists(configuration.getId())) {
            Object original = this.configurationRepository.read(configuration.getId());
            PasswordVerificationUtils$.MODULE$.replacePasswordPropertiesInCiIfNeeded((Option<ConfigurationItem>)new Some(original), (ConfigurationItem)configuration);
            this.configurationRepository.update(configuration);
            this.eventBus.publish((XLReleaseEvent)new ConfigurationUpdatedEvent(configuration));
            return;
        }
        this.configurationRepository.create(configuration);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationCreatedEvent(configuration));
    }

    public BaseConfiguration read(String id) {
        Object baseConfiguration = this.configurationRepository.read(id);
        Object t = baseConfiguration;
        if (t instanceof ThemeSettings) {
            ThemeSettings themeSettings = (ThemeSettings)t;
            return this.convertColorNameToCode(themeSettings);
        }
        return t;
    }

    @Timed
    public boolean exists(String id) {
        return this.configurationRepository.exists(id);
    }

    @Timed
    public void delete(String id) {
        block3: {
            block2: {
                String string = id;
                String string2 = "Configuration/settings/ThemeSettings";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = id;
                String string4 = "Configuration/settings/CustomLogoSettings";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            throw new IllegalArgumentException("Configuration with id " + id + " can't be deleted");
        }
        Object conf = this.configurationRepository.read(id);
        this.configurationRepository.delete(id);
        this.eventBus.publish((XLReleaseEvent)new ConfigurationDeletedEvent(conf));
    }

    @Timed
    public ThemeSettings getThemeSettings() {
        ThemeSettings themeSettings = this.configurationRepository.getThemeSettings();
        return this.convertColorNameToCode(themeSettings);
    }

    private ThemeSettings convertColorNameToCode(ThemeSettings themeSettings) {
        themeSettings.setHeaderAccentColor(ThemeColors$.MODULE$.colorCode(ThemeColor.valueOf((String)themeSettings.getHeaderAccentColor().toUpperCase())));
        return themeSettings;
    }

    @Timed
    public CustomLogoSettings saveCustomLogo(CustomLogoSettings customLogoSettings) {
        customLogoSettings.validateContentType();
        return (CustomLogoSettings)this.createOrUpdate("Configuration/settings/CustomLogoSettings", (BaseConfiguration)customLogoSettings);
    }

    @Timed
    public List<FeatureSettings> getFeatureSettings() {
        Buffer features = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(FeatureSettings.class))).asScala();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(DescriptorRegistry.getSubtypes((Type)Type.valueOf(FeatureSettings.class))).asScala().map((Function1 & Serializable)featureType -> (FeatureSettings)features.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationService.$anonfun$getFeatureSettings$2(featureType, x$1))).getOrElse((Function0 & Serializable)() -> {
            FeatureSettings feature = (FeatureSettings)featureType.getDescriptor().newInstance("");
            feature.generateId();
            return feature;
        }))).toList().sortBy((Function1 & Serializable)x$2 -> x$2.getType().getDescriptor().getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    @Timed
    public List<BaseSettings> getSystemSettings() {
        Buffer features = CollectionConverters$.MODULE$.ListHasAsScala(this.configurationRepository.findAllByType(Type.valueOf(BaseSettings.class))).asScala();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)features.toList().sortBy((Function1 & Serializable)x$3 -> x$3.getType().getDescriptor().getLabel(), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    @Timed
    public FeatureSettings getFeatureSettings(String featureType) {
        return (FeatureSettings)Try$.MODULE$.apply((Function0 & Serializable)() -> $this.configurationRepository.findFirstByType(Type.valueOf((String)featureType)).orElse(ConfigurationService.getDefaultSettings$1(featureType))).getOrElse((Function0 & Serializable)() -> ConfigurationService.getDefaultSettings$1(featureType));
    }

    @Timed
    public void saveFeatureSettings(List<FeatureSettings> features) {
        CollectionConverters$.MODULE$.ListHasAsScala(features).asScala().foreach((Function1 & Serializable)configuration -> {
            this.createOrUpdate(configuration);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void saveSettings(List<BaseSettings> settings) {
        CollectionConverters$.MODULE$.ListHasAsScala(settings).asScala().foreach((Function1 & Serializable)setting -> this.createOrUpdate(setting.getId(), (BaseConfiguration)setting));
    }

    public static final /* synthetic */ boolean $anonfun$getFeatureSettings$2(Type featureType$1, FeatureSettings x$1) {
        Type type = x$1.getType();
        Type type2 = featureType$1;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    private static final FeatureSettings getDefaultSettings$1(String featureType$2) {
        FeatureSettings feature = (FeatureSettings)Type.valueOf((String)featureType$2).getDescriptor().newInstance("");
        feature.generateId();
        return feature;
    }

    public ConfigurationService(ConfigurationRepository configurationRepository, XLReleaseEventBus eventBus) {
        this.configurationRepository = configurationRepository;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

