/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handlers;

import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedAttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedAttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedCommentCreatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedCommentDeletedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedCommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedReleaseActorStarted;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedReleaseActorStopped;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedReleaseExecutedEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedTaskStatusChangeEvent;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedTaskStatusLineUpdated;
import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.AttachmentEvent;
import com.xebialabs.xlrelease.domain.events.CommentCreatedEvent;
import com.xebialabs.xlrelease.domain.events.CommentDeletedEvent;
import com.xebialabs.xlrelease.domain.events.CommentEvent;
import com.xebialabs.xlrelease.domain.events.CommentUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseActorEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseActorStarted;
import com.xebialabs.xlrelease.domain.events.ReleaseActorStopped;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutedEvent;
import com.xebialabs.xlrelease.domain.events.TaskExecutionEvent;
import com.xebialabs.xlrelease.domain.events.TaskStatusLineUpdated;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.service.BroadcastService;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u000514A\u0001C\u0005\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003;\u0001\u0011%1\bC\u0003K\u0001\u0011%1\nC\u0003R\u0001\u0011%!\u000bC\u0003X\u0001\u0011%\u0001LA\fESN$(/\u001b2vi\u0016$WI^3oi\u0006#\u0017\r\u001d;fe*\u0011!bC\u0001\tQ\u0006tG\r\\3sg*\u0011A\"D\u0001\u0007KZ,g\u000e^:\u000b\u00059y\u0011!\u0003=me\u0016dW-Y:f\u0015\t\u0001\u0012#A\u0005yK\nL\u0017\r\\1cg*\t!#A\u0002d_6\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\f\u0001C\u0019:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}i\u0011aB:feZL7-Z\u0005\u0003Cy\u0011\u0001C\u0011:pC\u0012\u001c\u0017m\u001d;TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t\u0011\u0002C\u0003\u001c\u0005\u0001\u0007A$A\u0004p]\u00163XM\u001c;\u0015\u0005%b\u0003C\u0001\f+\u0013\tYsC\u0001\u0003V]&$\b\"B\u0017\u0004\u0001\u0004q\u0013!B3wK:$\bCA\u00184\u001b\u0005\u0001$B\u0001\u00072\u0015\t\u0011T\"\u0001\u0004e_6\f\u0017N\\\u0005\u0003iA\u0012a\u0002\u0017'SK2,\u0017m]3Fm\u0016tG\u000f\u000b\u0002\u0004mA\u0011q\u0007O\u0007\u0002\u0017%\u0011\u0011h\u0003\u0002\u000f\u0003NLhnY*vEN\u001c'/\u001b2f\u0003MygNU3mK\u0006\u001cX-Q2u_J,e/\u001a8u)\tad\tE\u0002\u0017{}J!AP\f\u0003\r=\u0003H/[8o!\t\u0001E)D\u0001B\u0015\ta!I\u0003\u0002Dc\u0005YA-[:ue&\u0014W\u000f^3e\u0013\t)\u0015IA\rESN$(/\u001b2vi\u0016$\u0007\f\u0014*fY\u0016\f7/Z#wK:$\b\"B\u0017\u0005\u0001\u00049\u0005CA\u0018I\u0013\tI\u0005GA\tSK2,\u0017m]3BGR|'/\u0012<f]R\f\u0011c\u001c8BiR\f7\r[7f]R,e/\u001a8u)\taD\nC\u0003N\u000b\u0001\u0007a*A\u0001f!\tys*\u0003\u0002Qa\ty\u0011\t\u001e;bG\"lWM\u001c;Fm\u0016tG/\u0001\bp]\u000e{W.\\3oi\u00163XM\u001c;\u0015\u0005q\u001a\u0006\"B'\u0007\u0001\u0004!\u0006CA\u0018V\u0013\t1\u0006G\u0001\u0007D_6lWM\u001c;Fm\u0016tG/\u0001\u000bp]\u000e{gNZ5hkJ\fG/[8o\u000bZ,g\u000e\u001e\u000b\u0003yeCQ!T\u0004A\u0002i\u0003\"aL.\n\u0005q\u0003$AE\"p]\u001aLw-\u001e:bi&|g.\u0012<f]RD#\u0001\u00010\u0011\u0005}3W\"\u00011\u000b\u0005\u0005\u0014\u0017AC:uKJ,w\u000e^=qK*\u00111\rZ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ-A\u0002pe\u001eL!a\u001a1\u0003\u0013\r{W\u000e]8oK:$\bF\u0001\u0001j!\t9$.\u0003\u0002l\u0017\tiQI^3oi2K7\u000f^3oKJ\u0004")
public class DistributedEventAdapter {
    private final BroadcastService broadcastService;

    @AsyncSubscribe
    public void onEvent(XLReleaseEvent event) {
        Option<DistributedXLReleaseEvent> option;
        XLReleaseEvent xLReleaseEvent = event;
        if (xLReleaseEvent instanceof DistributedXLReleaseEvent) {
            option = None$.MODULE$;
        } else if (xLReleaseEvent instanceof ConfigurationEvent) {
            ConfigurationEvent configurationEvent = (ConfigurationEvent)xLReleaseEvent;
            option = this.onConfigurationEvent(configurationEvent);
        } else if (xLReleaseEvent instanceof AttachmentEvent) {
            AttachmentEvent attachmentEvent = (AttachmentEvent)xLReleaseEvent;
            option = this.onAttachmentEvent(attachmentEvent);
        } else if (xLReleaseEvent instanceof CommentEvent) {
            CommentEvent commentEvent = (CommentEvent)xLReleaseEvent;
            option = this.onCommentEvent(commentEvent);
        } else if (xLReleaseEvent instanceof TaskStatusLineUpdated) {
            TaskStatusLineUpdated taskStatusLineUpdated = (TaskStatusLineUpdated)xLReleaseEvent;
            option = new Option<DistributedXLReleaseEvent>((Object)new DistributedTaskStatusLineUpdated(taskStatusLineUpdated.taskId(), taskStatusLineUpdated.statusLine()));
        } else if (xLReleaseEvent instanceof TaskExecutionEvent) {
            TaskExecutionEvent taskExecutionEvent = (TaskExecutionEvent)xLReleaseEvent;
            option = new Some((Object)new DistributedTaskStatusChangeEvent(taskExecutionEvent.task().getId(), taskExecutionEvent.task().getStatus()));
        } else if (xLReleaseEvent instanceof ReleaseExecutedEvent) {
            ReleaseExecutedEvent releaseExecutedEvent = (ReleaseExecutedEvent)xLReleaseEvent;
            option = new Some((Object)new DistributedReleaseExecutedEvent(releaseExecutedEvent.release().getId()));
        } else if (xLReleaseEvent instanceof ReleaseActorEvent) {
            ReleaseActorEvent releaseActorEvent = (ReleaseActorEvent)xLReleaseEvent;
            option = this.onReleaseActorEvent(releaseActorEvent);
        } else {
            option = None$.MODULE$;
        }
        Option<DistributedXLReleaseEvent> clusterEvent = option;
        clusterEvent.foreach((Function1 & Serializable)e -> {
            this.broadcastService.broadcast(e, true);
            return BoxedUnit.UNIT;
        });
    }

    private Option<DistributedXLReleaseEvent> onReleaseActorEvent(ReleaseActorEvent event) {
        ReleaseActorEvent releaseActorEvent = event;
        if (releaseActorEvent instanceof ReleaseActorStarted) {
            ReleaseActorStarted releaseActorStarted = (ReleaseActorStarted)releaseActorEvent;
            String releaseId = releaseActorStarted.releaseId();
            String actorPath = releaseActorStarted.actorPath();
            return new Some((Object)new DistributedReleaseActorStarted(releaseId, actorPath));
        }
        if (releaseActorEvent instanceof ReleaseActorStopped) {
            ReleaseActorStopped releaseActorStopped = (ReleaseActorStopped)releaseActorEvent;
            String releaseId = releaseActorStopped.releaseId();
            String actorPath = releaseActorStopped.actorPath();
            return new Some((Object)new DistributedReleaseActorStopped(releaseId, actorPath));
        }
        throw new MatchError((Object)releaseActorEvent);
    }

    private Option<DistributedXLReleaseEvent> onAttachmentEvent(AttachmentEvent e) {
        AttachmentEvent attachmentEvent = e;
        if (attachmentEvent instanceof AttachmentCreatedEvent) {
            AttachmentCreatedEvent attachmentCreatedEvent = (AttachmentCreatedEvent)attachmentEvent;
            String containerId = attachmentCreatedEvent.containerId();
            Attachment attachment = attachmentCreatedEvent.attachment();
            return new Some((Object)new DistributedAttachmentCreatedEvent(containerId, attachment.getId()));
        }
        if (attachmentEvent instanceof AttachmentDeletedEvent) {
            AttachmentDeletedEvent attachmentDeletedEvent = (AttachmentDeletedEvent)attachmentEvent;
            String containerId = attachmentDeletedEvent.containerId();
            Attachment attachment = attachmentDeletedEvent.attachment();
            return new Some((Object)new DistributedAttachmentDeletedEvent(containerId, attachment.getId()));
        }
        throw new MatchError((Object)attachmentEvent);
    }

    private Option<DistributedXLReleaseEvent> onCommentEvent(CommentEvent e) {
        CommentEvent commentEvent = e;
        if (commentEvent instanceof CommentCreatedEvent) {
            CommentCreatedEvent commentCreatedEvent = (CommentCreatedEvent)commentEvent;
            Task task = commentCreatedEvent.task();
            Comment comment = commentCreatedEvent.comment();
            return new Some((Object)new DistributedCommentCreatedEvent(task.getId(), comment.getId()));
        }
        if (commentEvent instanceof CommentUpdatedEvent) {
            CommentUpdatedEvent commentUpdatedEvent = (CommentUpdatedEvent)commentEvent;
            Task task = commentUpdatedEvent.task();
            Comment updated = commentUpdatedEvent.updated();
            return new Some((Object)new DistributedCommentUpdatedEvent(task.getId(), updated.getId()));
        }
        if (commentEvent instanceof CommentDeletedEvent) {
            CommentDeletedEvent commentDeletedEvent = (CommentDeletedEvent)commentEvent;
            Task task = commentDeletedEvent.task();
            Comment comment = commentDeletedEvent.comment();
            return new Some((Object)new DistributedCommentDeletedEvent(task.getId(), comment.getId()));
        }
        throw new MatchError((Object)commentEvent);
    }

    private Option<DistributedXLReleaseEvent> onConfigurationEvent(ConfigurationEvent e) {
        ConfigurationEvent configurationEvent = e;
        if (configurationEvent instanceof ConfigurationCreatedEvent) {
            ConfigurationCreatedEvent configurationCreatedEvent = (ConfigurationCreatedEvent)configurationEvent;
            BaseConfiguration conf = configurationCreatedEvent.conf();
            return new Some((Object)new DistributedConfigurationCreatedEvent(conf.getType().toString(), conf.getId()));
        }
        if (configurationEvent instanceof ConfigurationUpdatedEvent) {
            ConfigurationUpdatedEvent configurationUpdatedEvent = (ConfigurationUpdatedEvent)configurationEvent;
            BaseConfiguration updated = configurationUpdatedEvent.updated();
            return new Some((Object)new DistributedConfigurationUpdatedEvent(updated.getType().toString(), updated.getId()));
        }
        if (configurationEvent instanceof ConfigurationDeletedEvent) {
            ConfigurationDeletedEvent configurationDeletedEvent = (ConfigurationDeletedEvent)configurationEvent;
            BaseConfiguration conf = configurationDeletedEvent.conf();
            return new Some((Object)new DistributedConfigurationDeletedEvent(conf.getType().toString(), conf.getId()));
        }
        if (configurationEvent instanceof ConfigurationCopiedEvent) {
            ConfigurationCopiedEvent configurationCopiedEvent = (ConfigurationCopiedEvent)configurationEvent;
            BaseConfiguration original = configurationCopiedEvent.original();
            String newId = configurationCopiedEvent.newId();
            return new Some((Object)new DistributedConfigurationCopiedEvent(original.getType().toString(), original.getId(), newId));
        }
        throw new MatchError((Object)configurationEvent);
    }

    public DistributedEventAdapter(BroadcastService broadcastService) {
        this.broadcastService = broadcastService;
    }
}

