/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.features.TaskUpdateVersioningFeature;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.views.DependencyNode;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.ReleaseDependenciesView;
import com.xebialabs.xlrelease.views.ReleaseTree;
import com.xebialabs.xlrelease.views.converters.DependencyNodeConverter;
import com.xebialabs.xlrelease.views.converters.DependencyViewConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/dependencies")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class DependencyResource {
    private PermissionChecker permissions;
    private DependencyService dependencyService;
    private DependencyNodeConverter dependencyNodeConverter;
    private ReleaseActorService releaseActorService;
    private TaskGranularPermissions taskPermissionChecker;
    private TaskUpdateVersioningFeature taskUpdateVersioningFeature;
    private TaskService taskService;

    @Autowired
    public DependencyResource(PermissionChecker permissions, DependencyService dependencyService, DependencyNodeConverter dependencyNodeConverter, ReleaseActorService releaseActorService, TaskGranularPermissions taskPermissionChecker, TaskUpdateVersioningFeature taskUpdateVersioningFeature, TaskService taskService) {
        this.permissions = permissions;
        this.dependencyService = dependencyService;
        this.dependencyNodeConverter = dependencyNodeConverter;
        this.releaseActorService = releaseActorService;
        this.taskPermissionChecker = taskPermissionChecker;
        this.taskUpdateVersioningFeature = taskUpdateVersioningFeature;
        this.taskService = taskService;
    }

    public DependencyResource() {
    }

    @PUT
    @Timed
    @Path(value="{dependencyId:.*Dependency[^/-]*}")
    public DependencyView updateDependency(@PathParam(value="dependencyId") @IdParam String dependencyId, @QueryParam(value="modifiedAt") Long modifiedAt, DependencyView dependencyView) {
        String releaseId = Ids.releaseIdFrom((String)dependencyId);
        Dependency dependency = this.getDirectivesAndUpdate(releaseId, dependencyId, dependencyView, modifiedAt);
        DependencyView updatedDependencyView = DependencyViewConverter.toDependencyView(dependency);
        this.updateModifiedDetails(updatedDependencyView, Ids.getParentId((String)dependencyId));
        return updatedDependencyView;
    }

    private Dependency getDirectivesAndUpdate(String releaseId, String dependencyId, DependencyView dependencyView, Long modifiedAt) {
        Dependency dependency = new Dependency();
        if (this.taskPermissionChecker.hasDirectiveToUpdateAllProperties(releaseId) || this.taskPermissionChecker.hasEditTaskConfigurationGranularPermission(releaseId)) {
            this.checkViewPermissionIfNecessary(dependencyView);
            dependency = this.isTaskConcurrencyCheckEnabled() ? this.releaseActorService.updateDependencyVersioned(releaseId, dependencyId, dependencyView.toTargetIdOrVariable(), this.getModifiedAtDate(modifiedAt)) : this.releaseActorService.updateDependency(releaseId, dependencyId, dependencyView.toTargetIdOrVariable());
        }
        return dependency;
    }

    @DELETE
    @Timed
    @Path(value="{dependencyId:.*Dependency[^/-]*}")
    public void deleteDependency(@PathParam(value="dependencyId") @IdParam String dependencyId) {
        String releaseId = Ids.releaseIdFrom((String)dependencyId);
        this.permissions.checkEditTask(releaseId);
        this.releaseActorService.deleteDependency(releaseId, dependencyId);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}")
    public ReleaseDependenciesView getReleaseDependencies(@PathParam(value="releaseId") @IdParam String releaseId, @QueryParam(value="asReleases") boolean asReleases, @QueryParam(value="properties") List<String> properties, @QueryParam(value="extensions") List<String> extensions) {
        this.permissions.checkView(releaseId);
        List<String> activeIncomingGateIds = this.dependencyService.findActiveIncomingGateIds(releaseId);
        List<String> activeOutgoingTargetIds = this.dependencyService.findActiveOutgoingTargetIds(releaseId);
        if (asReleases) {
            activeIncomingGateIds = this.toReleaseIds(activeIncomingGateIds);
            activeOutgoingTargetIds = this.toReleaseIds(activeOutgoingTargetIds);
        }
        List<DependencyNode> incomingDependenciesView = this.dependencyNodeConverter.toDependencyNodes(activeIncomingGateIds, properties, extensions);
        List<DependencyNode> outgoingDependenciesView = this.dependencyNodeConverter.toDependencyNodes(activeOutgoingTargetIds, properties, extensions);
        return new ReleaseDependenciesView(releaseId, incomingDependenciesView, outgoingDependenciesView);
    }

    @GET
    @Timed
    @Path(value="{releaseId:.*Release[^/-]*}/tree")
    public ReleaseTree getReleaseTree(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        return this.dependencyService.getReleaseTree(releaseId);
    }

    private List<String> toReleaseIds(List<String> targetId) {
        return targetId.stream().map(Ids::releaseIdFrom).distinct().collect(Collectors.toList());
    }

    private void checkViewPermissionIfNecessary(DependencyView dependencyView) {
        if (dependencyView.hasFixedTarget()) {
            this.permissions.checkView(Ids.releaseIdFrom((String)dependencyView.toTargetId()));
        }
    }

    private boolean isTaskConcurrencyCheckEnabled() {
        return this.taskUpdateVersioningFeature.concurrentTaskModificationProtectionEnabled();
    }

    private DateTime getModifiedAtDate(Long modifiedAt) {
        if (modifiedAt != null) {
            return new DateTime((Object)modifiedAt);
        }
        return null;
    }

    private void updateModifiedDetails(DependencyView dependencyView, String taskId) {
        Object updatedTask = this.taskService.findById(taskId, ResolveOptions.WITHOUT_DECORATORS());
        CiAttributes ciAttributes = updatedTask.get$ciAttributes();
        dependencyView.setLastModifiedBy(ciAttributes.getLastModifiedBy());
        if (updatedTask.get$ciAttributes().getLastModifiedAt() == null) {
            dependencyView.setLastModifiedAt(null);
        } else {
            dependencyView.setLastModifiedAt(ciAttributes.getLastModifiedAt().toDate());
        }
    }
}

