package com.xebialabs.xlrelease.upgrade.json

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.domain.variables.StringVariable
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.{JsonUpgrade, UpgradeResult}
import org.codehaus.jettison.json.{JSONArray, JSONObject}
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._
import scala.language.implicitConversions

@Component
class XLRelease610ReplaceXldVariablesJsonUpgrade extends JsonUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "6.1.0#2")

  override def performUpgrade(release: JSONObject): UpgradeResult = {
    logger.debug(s"Replacing XL Deploy package and environment variables in release ${release.optString("id")}")
    val updated1 = replaceXldWithStringVariables(release.optJSONArray("variables"))
    val updated2 = release.optJSONArray("releaseTriggers") map { trigger =>
      replaceXldWithStringVariables(trigger.optJSONArray("variables"))
    } contains true

    new UpgradeResult(updated1 || updated2, Seq.empty.asJava)
  }

  private def replaceXldWithStringVariables(variables: Seq[JSONObject]): Boolean = {
    var updated = false
    variables foreach { variable =>
      variable.optString("type") match {
        case "xlrelease.XLDeployPackageVariable" | "xlrelease.XLDeployEnvironmentVariable" =>
          variable.put("type", Type.valueOf(classOf[StringVariable]).toString)
          updated = true
        case _ =>
      }
    }
    updated
  }

  private implicit def jsonArrayOfObjectsAsSeq(jsonArray: JSONArray): Seq[JSONObject] = {
    Option(jsonArray).map { array =>
      for {
        i <- 0 until array.length()
      } yield array.getJSONObject(i)
    }.getOrElse(Seq.empty)
  }
}
