package com.xebialabs.xlrelease.server.jetty;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;

/**
 * Copy of class org.springframework.boot.web.embedded.jetty.JettyEmbeddedErrorHandler
 */
class JettyEmbeddedErrorHandler extends ErrorPageErrorHandler {

	private static final Set<String> HANDLED_HTTP_METHODS = new HashSet<>(Arrays.asList("GET", "POST", "HEAD"));

	@Override
	public boolean errorPageForMethod(String method) {
		return true;
	}

	@Override
	public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException {
		if (!HANDLED_HTTP_METHODS.contains(baseRequest.getMethod())) {
			baseRequest.setMethod("GET");
		}
		super.handle(target, baseRequest, request, response);
	}

}
