package com.xebialabs.xlrelease.scheduler.strategies

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation
import com.xebialabs.xlrelease.runner.domain.JobId
import com.xebialabs.xlrelease.scheduler.Job
import com.xebialabs.xlrelease.scheduler.strategies.JobSchedulerStrategy.ScheduleResult
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Non-blocking backpressure with limited jobs", description = "")
class LimitParallelJobSchedulerStrategySettings extends NonBlockingBackpressuredJobSchedulerStrategySettings {

  @BeanProperty
  @XLProperty(label = "Desired Job Count Per Node (Attempted)",
    description = "Enter the number of jobs per node you would like the system to attempt to restrict to. " +
      "Please note that while the system will make a concerted effort to limit the number of jobs to this count, there is no guarantee of exact adherence.",
    defaultValue = "5",
    category = "input"
  )
  @validation.Range(minimum = 1, maximum = 100)
  var maxJobs: Int = _

  override def schedule(job: Job): ScheduleResult = LimitParallelJobSchedulerStrategy.schedule(this)(job)

  override def unlock(jobId: JobId, maybeTaskId: Option[String]): Unit = LimitParallelJobSchedulerStrategy.unlock(jobId, maybeTaskId)
}
