package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Permission snapshot report settings",
  description = "Flag to control if permission snapshot information should be tracked for audit report."
)
class PermissionSnapshotReportFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable capturing snapshot data on permission changes (for Audit report)",
    description = "When checked permission snapshot information will be stored on permission changes for inclusion in Audit report",
    category = "input",
    defaultValue = "false")
  var generatePermissionSnapshots: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "configuration-preferences", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "reports-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "concept/release-audit-report.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "20", hidden = true)
  var weight: Integer = _
}
