package com.xebialabs.xlrelease.api.internal.converters

import com.xebialabs.xlrelease.configuration.CustomLogoSettings
import com.xebialabs.xlrelease.views.CustomLogoSettingsView
import jakarta.servlet.http.Part
import org.springframework.stereotype.Component

import java.io.ByteArrayOutputStream
import java.util.Base64
import scala.util.Using

@Component
class CustomLogoSettingsConverter {

  def fromPart(logoInformation: Part): CustomLogoSettings = {
    var customLogoSettings: CustomLogoSettings = null

    Using.resource(logoInformation.getInputStream) { imageInFile =>
      var in = -1
      val buffer = new ByteArrayOutputStream
      while ( {
        in = imageInFile.read
        in != -1
      }) {
        buffer.write(in)
      }
      val imageData = buffer.toByteArray
      imageInFile.read(imageData)

      customLogoSettings = new CustomLogoSettings
      customLogoSettings.setFilename(logoInformation.getSubmittedFileName)
      customLogoSettings.setContentType(logoInformation.getContentType())
      customLogoSettings.setContent(Base64.getEncoder.encodeToString(imageData))
    }

    customLogoSettings
  }

  def toView(customLogoSettings: CustomLogoSettings): CustomLogoSettingsView = {
    val imageByteArray = Base64.getDecoder.decode(customLogoSettings.getContent)
    new CustomLogoSettingsView(customLogoSettings.getFilename, customLogoSettings.getContentType, imageByteArray)
  }

}
