/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.JobConfirmationActor;
import com.xebialabs.xlrelease.actors.JobConfirmed;
import com.xebialabs.xlrelease.actors.MonitorJobConfirmation;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.features.JobSchedulerFeature$;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.DefaultJobQueue;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobProvider;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRunnerQueue;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Primary
@Component
@ScalaSignature(bytes="\u0006\u0005\t\rd\u0001\u0002\u0012$\u00011B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011)\u0019!C\u0001\u0015\"A\u0011\u000b\u0001B\u0001B\u0003%1\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!I\u0006A!A!\u0002\u0013Q\u0006\"\u00023\u0001\t\u0003)\u0007\u0002C6\u0001\u0011\u000b\u0007I\u0011\u00027\t\u000fa\u0004!\u0019!C\u0005s\"9\u0011q\b\u0001!\u0002\u0013Q\bbBA!\u0001\u0011\u0005\u00131\t\u0005\b\u00037\u0002A\u0011IA/\u0011\u001d\t9\u0007\u0001C#\u0003SBq!!#\u0001\t\u0003\tY\tC\u0004\u00024\u0002!I!!.\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAk\u0001\u0011%\u0011q\u001b\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ty\u000f\u0001C!\u0003cDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0002|\u0002!\t%!@\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u00119\u0002\u0001C!\u0005+AqA!\u0007\u0001\t\u0003\u0012Y\u0002C\u0004\u0003\u001e\u0001!\tEa\b\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003\u0016!9!\u0011\u0006\u0001\u0005\n\t-\u0002b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011Y\u0004\u0001C!\u0005{\u0011qcQ1qC\nLG.\u001b;z\u0003^\f'/\u001a&pEF+X-^3\u000b\u0005\u0011*\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t1s%A\u0005yYJ,G.Z1tK*\u0011\u0001&K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AK\u0001\u0004G>l7\u0001A\n\u0007\u00015\u001atGO\u001f\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\u0005K_\n\fV/Z;f!\t!\u0004(\u0003\u0002:G\tq!+\u001e8oKJ\u0014VmZ5tiJL\bC\u0001\u001b<\u0013\ta4EA\u0006K_\n\u0004&o\u001c<jI\u0016\u0014\bC\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0015\u0001C4sSjTH.\u001a3\n\u0005\u0011{$a\u0002'pO\u001eLgnZ\u0001\tU>\u0014\u0017+^3vKB\u0011AgR\u0005\u0003\u0011\u000e\u0012q\u0002R3gCVdGOS8c#V,W/Z\u0001\u0014U>\u0014'+\u001e8oKJ\u0014V\r]8tSR|'/_\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*J\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001)N\u0005MQuN\u0019*v]:,'OU3q_NLGo\u001c:z\u0003QQwN\u0019*v]:,'OU3q_NLGo\u001c:zA\u0005\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011AkV\u0007\u0002+*\u0011a+J\u0001\u0007C\u000e$xN]:\n\u0005a+&a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017aD:qe&tw-\u0012=uK:\u001c\u0018n\u001c8\u0011\u0005m\u0013W\"\u0001/\u000b\u0005us\u0016AB:qe&twM\u0003\u0002`A\u0006)\u0001/Z6l_*\u0011\u0011-J\u0001\bgV\u0004\bo\u001c:u\u0013\t\u0019GLA\bTaJLgnZ#yi\u0016t7/[8o\u0003\u0019a\u0014N\\5u}Q)am\u001a5jUB\u0011A\u0007\u0001\u0005\u0006\u000b\u001a\u0001\rA\u0012\u0005\u0006\u0013\u001a\u0001\ra\u0013\u0005\u0006%\u001a\u0001\ra\u0015\u0005\u00063\u001a\u0001\rAW\u0001\tC\u000e$xN\u001d*fMV\tQ\u000e\u0005\u0002om6\tqN\u0003\u0002qc\u0006)\u0011m\u0019;pe*\u0011qL\u001d\u0006\u0003gR\fa!\u00199bG\",'\"A;\u0002\u0007=\u0014x-\u0003\u0002x_\nA\u0011i\u0019;peJ+g-\u0001\u0007sk:tWM])vKV,7/F\u0001{!\u001dY\u0018QAA\u0005\u0003si\u0011\u0001 \u0006\u0003{z\f!bY8oGV\u0014(/\u001a8u\u0015\ry\u0018\u0011A\u0001\u0005kRLGN\u0003\u0002\u0002\u0004\u0005!!.\u0019<b\u0013\r\t9\u0001 \u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\b\u0003BA\u0006\u0003gqA!!\u0004\u0002.9!\u0011qBA\u0014\u001d\u0011\t\t\"a\t\u000f\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\tyB\u0004\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYbK\u0001\u0007yI|w\u000e\u001e \n\u0003)J!\u0001K\u0015\n\u0005\u0019:\u0013bAA\u0013K\u00051!/\u001e8oKJLA!!\u000b\u0002,\u00051Am\\7bS:T1!!\n&\u0013\u0011\ty#!\r\u0002\u000fA\f7m[1hK*!\u0011\u0011FA\u0016\u0013\u0011\t)$a\u000e\u0003\u0011I+hN\\3s\u0013\u0012TA!a\f\u00022A\u0019A'a\u000f\n\u0007\u0005u2E\u0001\bK_\n\u0014VO\u001c8feF+X-^3\u0002\u001bI,hN\\3s#V,W/Z:!\u0003E\u0011XmZ5ti\u0016\u0014(j\u001c2Sk:tWM\u001d\u000b\u0005\u0003\u000b\nY\u0005E\u0002/\u0003\u000fJ1!!\u00130\u0005\u001d\u0011un\u001c7fC:Dq!!\u0014\u000b\u0001\u0004\ty%A\u0005k_\n\u0014VO\u001c8feB!\u0011\u0011KA,\u001b\t\t\u0019F\u0003\u0003\u0002&\u0005U#bAA\u0015K%!\u0011\u0011LA*\u0005%QuN\u0019*v]:,'/A\nv]J,w-[:uKJTuN\u0019*v]:,'\u000f\u0006\u0003\u0002`\u0005\u0015\u0004c\u0001\u0018\u0002b%\u0019\u00111M\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001bZ\u0001\u0019AA(\u0003\r9W\r\u001e\u000b\u0005\u0003W\n9\bE\u0003/\u0003[\n\t(C\u0002\u0002p=\u0012aa\u00149uS>t\u0007c\u0001\u001b\u0002t%\u0019\u0011QO\u0012\u0003\u0007){'\rC\u0004\u0002z1\u0001\r!!\u0003\u0002\u0011I,hN\\3s\u0013\u0012D3\u0001DA?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAAB_\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0015\u0011\u0011\u0002\bi\u0006LGN]3d\u00039!W\r\\1z\u001fJ\u0014Vm]3sm\u0016$b!a\u001b\u0002\u000e\u0006E\u0006bBAH\u001b\u0001\u0007\u0011\u0011S\u0001\u0004U>\u0014\u0007\u0007BAJ\u0003;\u0003R\u0001NAK\u00033K1!a&$\u0005\u001d!\u0016m]6K_\n\u0004B!a'\u0002\u001e2\u0001A\u0001DAP\u0003\u001b\u000b\t\u0011!A\u0003\u0002\u0005\u0005&aA0%cE!\u00111UAU!\rq\u0013QU\u0005\u0004\u0003O{#a\u0002(pi\"Lgn\u001a\t\u0005\u0003W\u000bi+\u0004\u0002\u0002V%!\u0011qVA+\u0005\u0011!\u0016m]6\t\u000f\u0005eT\u00021\u0001\u0002\n\u0005Q!/Z:feZ,'j\u001c2\u0015\r\u0005-\u0014qWA^\u0011\u001d\tIL\u0004a\u0001\u0003c\n1\u0002]8tg&\u0014G.\u001a&pE\"9\u0011\u0011\u0010\bA\u0002\u0005%\u0011a\u0002:fg\u0016\u0014h/\u001a\u000b\u0007\u0003c\n\t-a1\t\u000f\u0005ev\u00021\u0001\u0002r!9\u0011\u0011P\bA\u0002\u0005%\u0011aB2p]\u001aL'/\u001c\u000b\u0007\u0003\u000b\nI-a3\t\u000f\u0005e\u0004\u00031\u0001\u0002\n!9\u0011Q\u001a\tA\u0002\u0005=\u0017!\u00026pE&#\u0007\u0003BA\u0006\u0003#LA!a5\u00028\t)!j\u001c2JI\u00061rN\u001a4feR{'j\u001c2Sk:tWM])vKV,7\u000f\u0006\u0003\u0002`\u0005e\u0007bBAH#\u0001\u0007\u0011\u0011O\u0001\u001ae\u0016lwN^3Ge>l'j\u001c2Sk:tWM])vKV,7\u000f\u0006\u0003\u0002`\u0005}\u0007bBAq%\u0001\u0007\u00111]\u0001\naJ,G-[2bi\u0016\u0004b!!:\u0002l\u0006ETBAAt\u0015\r\tIO`\u0001\tMVt7\r^5p]&!\u0011Q^At\u0005%\u0001&/\u001a3jG\u0006$X-\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003?\n\u0019\u0010C\u0004\u0002\u0010N\u0001\r!!\u001d\u0002\u001dM,(-\\5u\u000bbL7\u000f^5oOR!\u0011qLA}\u0011\u001d\ty\t\u0006a\u0001\u0003c\n\u0011c];c[&$(I]8bI\u000e\f7\u000f^3e)\u0011\ty&a@\t\u000f\u0005=U\u00031\u0001\u0002r\u00059!/\u001a9mC\u000e,G\u0003BA0\u0005\u000bAq!a$\u0017\u0001\u0004\t\t(\u0001\u0004gS:L7\u000f\u001b\u000b\u0005\u0003?\u0012Y\u0001C\u0004\u0002N^\u0001\r!a4\u0002\u0011\r\fgnY3m\u0013\u001a$B!a\u0018\u0003\u0012!9\u0011\u0011\u001d\rA\u0002\u0005\r\u0018!B:uCJ$HCAA0\u0003\u0011\u0019Ho\u001c9\u0002\u0013%\u001c(+\u001e8oS:<GCAA#\u0003\u0011\u0019\u0018N_3\u0015\u0005\t\u0005\u0002c\u0001\u0018\u0003$%\u0019!QE\u0018\u0003\u0007%sG/\u0001\nsK\u001eL7\u000f^3s\u0015>\u0014'+\u001e8oKJ\u001c\u0018!E2sK\u0006$XMU;o]\u0016\u0014\u0018+^3vKR!\u0011q\fB\u0017\u0011\u001d\t)C\ba\u0001\u0003\u001f\n\u0011C]3n_Z,'+\u001e8oKJ\fV/Z;f)\u0011\tyFa\r\t\u000f\u0005\u0015r\u00041\u0001\u0002P\u0005!R\u000f\u001d3bi\u0016$\u0016m]6Ti\u0006$Xo\u001d'j]\u0016$B!a\u0018\u0003:!9\u0011q\u0012\u0011A\u0002\u0005E\u0014!C;o%\u0016\u001cXM\u001d<f)\u0011\tyFa\u0010\t\u000f\u0005=\u0015\u00051\u0001\u0002r!\u001a\u0001Aa\u0011\u0011\t\t\u0015#\u0011K\u0007\u0003\u0005\u000fRA!a!\u0003J)!!1\nB'\u0003\u001d\u0019wN\u001c;fqRT1Aa\u0014u\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\\u0017\u0002\u0002B*\u0005\u000f\u0012q\u0001\u0015:j[\u0006\u0014\u0018\u0010K\u0002\u0001\u0005/\u0002BA!\u0017\u0003`5\u0011!1\f\u0006\u0005\u0005;\u0012i%\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!\u0019\u0003\\\tI1i\\7q_:,g\u000e\u001e")
public class CapabilityAwareJobQueue
implements JobQueue,
RunnerRegistry,
JobProvider,
Logging {
    private ActorRef actorRef;
    private final DefaultJobQueue jobQueue;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final SpringExtension springExtension;
    private final ConcurrentHashMap<String, JobRunnerQueue> runnerQueues;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    private ActorRef actorRef$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$0) {
                this.actorRef = this.springExtension.actorOf(JobConfirmationActor.class, this.springExtension.actorOf$default$2(), this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private ConcurrentHashMap<String, JobRunnerQueue> runnerQueues() {
        return this.runnerQueues;
    }

    @Override
    public boolean registerJobRunner(JobRunner jobRunner) {
        boolean updateInQueue;
        Option runnerQueue = Option$.MODULE$.apply((Object)this.runnerQueues().get(jobRunner.getId()));
        boolean bl = updateInQueue = runnerQueue.isEmpty() || runnerQueue.nonEmpty() && ((JobRunnerQueue)runnerQueue.get()).isOutdated(jobRunner);
        if (updateInQueue) {
            this.logger().debug((Function0 & Serializable)() -> "Going to register runner[" + jobRunner.getId() + "]");
            this.createRunnerQueue(jobRunner);
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Runner already in queue, skipping registration for runner[" + jobRunner.getId() + "]");
        }
        return updateInQueue;
    }

    @Override
    public void unregisterJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to un-register runner[" + jobRunner.getId() + "]");
        this.removeRunnerQueue(jobRunner);
    }

    @Override
    public final Option<Job> get(String runnerId) {
        Option s;
        Option option;
        while ((option = (s = Option$.MODULE$.apply((Object)this.runnerQueues().get(runnerId)))) instanceof Some) {
            Some some = (Some)option;
            JobRunnerQueue runnerQueue = (JobRunnerQueue)some.value();
            Option option2 = Option$.MODULE$.apply((Object)runnerQueue.poll());
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Job possibleJob = (Job)some2.value();
                Job job = possibleJob;
                if (job instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job;
                    return new Some((Object)stopWorkerThread);
                }
                if (job instanceof FailJob) {
                    FailJob failJob = (FailJob)job;
                    return new Some((Object)failJob);
                }
                if (job instanceof TaskJob) {
                    TaskJob taskJob = (TaskJob)job;
                    Option<Job> reservedJob = this.delayOrReserve(taskJob, runnerId);
                    Option<Job> option3 = reservedJob;
                    if (None$.MODULE$.equals(option3)) continue;
                    return option3;
                }
                throw new MatchError((Object)job);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "No runner queue found for " + runnerId;
            this.logger().warn((Function0 & Serializable)() -> msg);
            throw new NotFoundException(msg, new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    public Option<Job> delayOrReserve(TaskJob<? extends Task> job, String runnerId) {
        Either<Job, Job> maybeDelayed = JobSchedulerFeature$.MODULE$.strategy().schedule(job);
        Either<Job, Job> either = maybeDelayed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Job delayedTaskJob = (Job)left.value();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replace(delayedTaskJob)).recover((PartialFunction)new Serializable(this, delayedTaskJob){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ CapabilityAwareJobQueue $outer;
                private final Job delayedTaskJob$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.$outer.logger().error((Function0 & Serializable)() -> "Unable to replace job " + $this.delayedTaskJob$1, (Function0 & Serializable)() -> A1);
                    return (B1)BoxedUnit.UNIT;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.delayedTaskJob$1 = delayedTaskJob$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.CapabilityAwareJobQueue$$anonfun$delayOrReserve$2 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                }
            });
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Job job2 = (Job)right.value();
            return this.reserveJob(job2, runnerId);
        }
        throw new MatchError(either);
    }

    private Option<Job> reserveJob(Job possibleJob, String runnerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.reserve(possibleJob, runnerId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> "giving " + reservedJob);
            this.updateTaskStatusLine(reservedJob);
            return new Some((Object)reservedJob);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof OptimisticLockingFailureException) {
                this.logger().debug((Function0 & Serializable)() -> "Unable to reserve job " + possibleJob);
                return None$.MODULE$;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                FailJob failJob = new FailJob(possibleJob, (Option<String>)new Some((Object)throwable2.getMessage()));
                this.runnerQueues().get(LocalJobRunner$.MODULE$.getId()).offer(failJob);
                return None$.MODULE$;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    private Job reserve(Job possibleJob, String runnerId) {
        Job job = this.jobQueue.reserve(possibleJob, runnerId);
        this.removeFromJobRunnerQueues(x$1 -> x$1.id() == possibleJob.id());
        MonitorJobConfirmation x$12 = new MonitorJobConfirmation(job);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$12);
        this.actorRef().$bang((Object)x$12, x$2);
        return job;
    }

    @Override
    public boolean confirm(String runnerId, long jobId) {
        boolean result;
        block1: {
            JobConfirmed x$1 = new JobConfirmed(jobId);
            ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
            this.actorRef().$bang((Object)x$1, x$2);
            Tuple2<Object, Option<TaskJob<?>>> tuple2 = this.jobQueue.confirm(runnerId, jobId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            Option taskJob = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)result2), (Object)taskJob);
            result = tuple22._1$mcZ$sp();
            Option taskJob2 = (Option)tuple22._2();
            if (!result || !taskJob2.isDefined()) break block1;
            this.updateTaskStatusLine((Job)taskJob2.get());
        }
        return result;
    }

    private void offerToJobRunnerQueues(Job job) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeFromJobRunnerQueues(Predicate<Job> predicate) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.cancelIf(predicate);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void submit(Job job) {
        this.jobQueue.submit(job);
        this.updateTaskStatusLine(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.jobQueue.submitExisting(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitBroadcasted(Job job) {
        this.jobQueue.submitBroadcasted(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void replace(Job job) {
        this.jobQueue.replace(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void finish(long jobId) {
        this.jobQueue.finish(jobId);
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.jobQueue.cancelIf(predicate);
        this.removeFromJobRunnerQueues(predicate);
    }

    @Override
    public void start() {
        this.registerJobRunners();
        this.jobQueue.start();
    }

    @Override
    public void stop() {
        this.jobQueue.stop();
    }

    @Override
    public boolean isRunning() {
        return this.jobQueue.isRunning();
    }

    @Override
    public int size() {
        return this.jobQueue.size();
    }

    private void registerJobRunners() {
        List<? extends JobRunner> jobRunners = this.jobRunnerRepository().findAll();
        jobRunners.forEach(runner -> this.createRunnerQueue((JobRunner)runner));
    }

    private void createRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
        JobRunnerQueue runnerQueue = new JobRunnerQueue((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(runner.getCapabilities()).asScala().toSet(), runner.capacity(), runner.evictionTime(), runner.idleTimeToLive());
        this.runnerQueues().put(runner.getId(), runnerQueue);
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.jobQueue.localJobs().iterator()).asScala().foreach((Function1 & Serializable)job -> {
            runnerQueue.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
    }

    private void updateTaskStatusLine(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            taskJob.jobStatusLine().foreach((Function1 & Serializable)statusLine -> {
                this.releaseActorService.updateTaskStatusLine(taskJob.taskId(), statusLine);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void unReserve(Job job) {
        Job unReservedJob = this.jobQueue.unReserve(job);
        this.updateTaskStatusLine(unReservedJob);
        this.replace(unReservedJob);
    }

    public CapabilityAwareJobQueue(DefaultJobQueue jobQueue, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, SpringExtension springExtension) {
        this.jobQueue = jobQueue;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.springExtension = springExtension;
        Logging.$init$((Logging)this);
        this.runnerQueues = new ConcurrentHashMap();
        this.createRunnerQueue(LocalJobRunner$.MODULE$);
    }
}

