/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.domain.events.UserTokenAboutToExpireEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenCreatedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokenDeletedEvent;
import com.xebialabs.xlrelease.domain.events.UserTokensDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.UserTokenRepository;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils$;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import com.xebialabs.xlrelease.utils.TokenTypes$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\b\u0011\u0001eA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003>\u0001\u0011\u0005a\bC\u0003E\u0001\u0011\u0005Q\tC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u0002\"\u0001!\t!a\t\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003;\u0002A\u0011BA0\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003K\u0012\u0001#V:feR{7.\u001a8TKJ4\u0018nY3\u000b\u0005E\u0011\u0012aB:feZL7-\u001a\u0006\u0003'Q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005U1\u0012!\u0003=fE&\fG.\u00192t\u0015\u00059\u0012aA2p[\u000e\u00011c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\n\u0001b\u001a:jujdW\rZ\u0005\u0003O\t\u0012q\u0001T8hO&tw-\u0001\u0005fm\u0016tGOQ;t!\tQS&D\u0001,\u0015\ta##\u0001\u0004fm\u0016tGo]\u0005\u0003]-\u0012\u0001\"\u0012<f]R\u0014Uo]\u0001\u0014kN,'\u000fV8lK:\u0014V\r]8tSR|'/\u001f\t\u0003cQj\u0011A\r\u0006\u0003gI\t!B]3q_NLGo\u001c:z\u0013\t)$GA\nVg\u0016\u0014Hk\\6f]J+\u0007o\\:ji>\u0014\u00180\u0001\u000eqKJ\u001cxN\\1m\u0003\u000e\u001cWm]:U_.,gNR3biV\u0014X\r\u0005\u00029w5\t\u0011H\u0003\u0002;%\u0005Aa-Z1ukJ,7/\u0003\u0002=s\tQ\u0002+\u001a:t_:\fG.Q2dKN\u001cHk\\6f]\u001a+\u0017\r^;sK\u00061A(\u001b8jiz\"BaP!C\u0007B\u0011\u0001\tA\u0007\u0002!!)\u0001\u0006\u0002a\u0001S!)q\u0006\u0002a\u0001a!)a\u0007\u0002a\u0001o\u0005y1M]3bi\u0016,6/\u001a:U_.,g\u000e\u0006\u0003G\u0019f[\u0006CA$K\u001b\u0005A%BA%\u0013\u0003\u0019!w.\\1j]&\u00111\n\u0013\u0002\n+N,'\u000fV8lK:DQ!T\u0003A\u00029\u000b\u0001\"^:fe:\fW.\u001a\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EcR\"\u0001*\u000b\u0005MC\u0012A\u0002\u001fs_>$h(\u0003\u0002V9\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)F\u0004C\u0003[\u000b\u0001\u0007a*A\u0005u_.,gNT8uK\")A,\u0002a\u0001;\u0006QQ\r\u001f9jef$\u0015\r^3\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017\u0001B;uS2T\u0011AY\u0001\u0005U\u00064\u0018-\u0003\u0002e?\n!A)\u0019;fQ\t)a\r\u0005\u0002h]6\t\u0001N\u0003\u0002jU\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005-d\u0017aB7fiJL7m\u001d\u0006\u0003[Z\t\u0001bY8eC\"\fG.Z\u0005\u0003_\"\u0014Q\u0001V5nK\u0012\fq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0003eV\u0004\"aG:\n\u0005Qd\"\u0001B+oSRDQA\u001e\u0004A\u0002\u0019\u000b\u0011\"^:feR{7.\u001a8)\u0005\u00191\u0017A\u00053fY\u0016$X-\u00117m+N,'\u000fV8lK:$\"A\u001d>\t\u000b5;\u0001\u0019\u0001()\u0005\u001d1\u0017\u0001\u00024j]\u0012$RA`A\n\u0003+\u0001Ba`A\b\r6\u0011\u0011\u0011\u0001\u0006\u0004\u0013\u0006\r!\u0002BA\u0003\u0003\u000f\tA\u0001Z1uC*!\u0011\u0011BA\u0006\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0007\u0003\ry'oZ\u0005\u0005\u0003#\t\tA\u0001\u0003QC\u001e,\u0007\"B'\t\u0001\u0004q\u0005bBA\f\u0011\u0001\u0007\u0011\u0011D\u0001\ta\u0006<W-\u00192mKB\u0019q0a\u0007\n\t\u0005u\u0011\u0011\u0001\u0002\t!\u0006<W-\u00192mK\"\u0012\u0001BZ\u0001\fM&tGMQ=DSVKG\r\u0006\u0003\u0002&\u0005-\u0002\u0003B\u000e\u0002(\u0019K1!!\u000b\u001d\u0005\u0019y\u0005\u000f^5p]\"9\u0011QF\u0005A\u0002\u0005=\u0012!B2j+&$\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U\u0012-\u0001\u0003mC:<\u0017\u0002BA\u001d\u0003g\u0011q!\u00138uK\u001e,'\u000f\u000b\u0002\nM\u0006ya-\u001b8e\u0005f,6/\u001a:U_.,g\u000e\u0006\u0003\u0002&\u0005\u0005\u0003BBA\"\u0015\u0001\u0007a*A\u0005u_.,g\u000eS1tQ\"\u0012!BZ\u0001\u001a]>$\u0018NZ=U_.,gn]!c_V$Hk\\#ya&\u0014X\rF\u0001sQ\tYa-A\bvg\u0016\u0014Hk\\6f]\u0016C\u0018n\u001d;t)\u0019\t\t&a\u0016\u0002ZA\u00191$a\u0015\n\u0007\u0005UCDA\u0004C_>dW-\u00198\t\u000b5c\u0001\u0019\u0001(\t\u000bic\u0001\u0019\u0001()\u000511\u0017\u0001\u0005<bY&$\u0017\r^3EkJ\fG/[8o)\r\u0011\u0018\u0011\r\u0005\u000696\u0001\r!X\u0001\u0019aV\u0014G.[:i)>\\WM\\\"sK\u0006$X\rZ#wK:$Hc\u0001:\u0002h!)aO\u0004a\u0001\r\u0002")
public class UserTokenService
implements Logging {
    private final EventBus eventBus;
    private final UserTokenRepository userTokenRepository;
    private final PersonalAccessTokenFeature personalAccessTokenFeature;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenService userTokenService = this;
        synchronized (userTokenService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public UserToken createUserToken(String username, String tokenNote, Date expiryDate) {
        this.validateDuration(expiryDate);
        String token = TokenGenerator$.MODULE$.generate(TokenTypes$.MODULE$.RPA());
        UserToken userToken = new UserToken();
        userToken.tokenNote_$eq(tokenNote);
        userToken.username_$eq(username);
        userToken.createdDate_$eq(new Date());
        if (expiryDate == null) {
            userToken.expiryDate_$eq(expiryDate);
        } else {
            LocalDateTime localExpiryDate = expiryDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            userToken.expiryDate_$eq(Date.from(localExpiryDate.atZone(ZoneId.systemDefault()).toInstant()));
        }
        Integer ciUid = this.userTokenRepository.create(userToken, TokenGenerator$.MODULE$.hash(token));
        userToken.ciUid_$eq(ciUid);
        userToken.token_$eq(token);
        this.publishTokenCreatedEvent(userToken);
        return userToken;
    }

    @Timed
    public void deleteUserToken(UserToken userToken) {
        this.userTokenRepository.delete(userToken.ciUid());
        this.eventBus.publish((XLReleaseEvent)new UserTokenDeletedEvent(userToken));
    }

    @Timed
    public void deleteAllUserToken(String username) {
        if (Strings.isNotBlank((String)username)) {
            this.userTokenRepository.delete(username);
            this.eventBus.publish((XLReleaseEvent)new UserTokensDeletedEvent(username));
            return;
        }
        throw new IllegalArgumentException("Username can't be blank");
    }

    @Timed
    public Page<UserToken> find(String username, Pageable pageable) {
        return this.userTokenRepository.query(new UserTokenRepository.ByUsername(username), pageable);
    }

    @Timed
    public Option<UserToken> findByCiUid(Integer ciUid) {
        return this.userTokenRepository.findByCiUid(ciUid);
    }

    @Timed
    public Option<UserToken> findByUserToken(String tokenHash) {
        return this.userTokenRepository.findByUserToken(tokenHash);
    }

    @Timed
    public void notifyTokensAboutToExpire() {
        LocalDateTime localTime = Instant.now().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX).plusDays(1L);
        Date expiryDate = Date.from(localTime.atZone(ZoneId.systemDefault()).toInstant());
        Buffer tokensAboutToExpire = CollectionConverters$.MODULE$.ListHasAsScala(this.userTokenRepository.query(new UserTokenRepository.TokensAboutToExpire(expiryDate), (Pageable)PageRequest.ofSize((int)1024)).getContent()).asScala();
        tokensAboutToExpire.foreach((Function1 & Serializable)userToken -> {
            UserTokenService.$anonfun$notifyTokensAboutToExpire$1(this, userToken);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public boolean userTokenExists(String username, String tokenNote) {
        Option<UserToken> option = this.userTokenRepository.findByUserAndNote(username, tokenNote);
        if (option instanceof Some) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was found with user[" + username + "] and note[" + tokenNote + "]");
            return true;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().debug((Function0 & Serializable)() -> "Personal access token was not found with user[" + username + "] and note[" + tokenNote + "]");
            return false;
        }
        throw new MatchError(option);
    }

    private void validateDuration(Date expiryDate) {
        boolean noPresetExpirationLimit;
        int maximumPresetExpirationDays = this.personalAccessTokenFeature.maxTokenExpiry();
        boolean bl = noPresetExpirationLimit = maximumPresetExpirationDays == -1;
        if (!noPresetExpirationLimit) {
            boolean tokenReqExceedsPresetExpirationLimit;
            LocalDateTime today = new Date().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
            Date maximumExpiryDate = Date.from(today.plusDays(maximumPresetExpirationDays).atZone(ZoneId.systemDefault()).toInstant());
            boolean tokenReqHasExpiryDate = expiryDate != null;
            boolean tokenReqExceedsMaximumExpiryDate = tokenReqHasExpiryDate && expiryDate.after(maximumExpiryDate);
            boolean tokenReqIsNonExpiringButNotAllowed = !tokenReqHasExpiryDate && !noPresetExpirationLimit;
            boolean bl2 = tokenReqExceedsPresetExpirationLimit = tokenReqExceedsMaximumExpiryDate || tokenReqIsNonExpiringButNotAllowed;
            if (tokenReqExceedsPresetExpirationLimit) {
                throw new IllegalArgumentException("Personal access token expiration cannot exceed " + maximumPresetExpirationDays + " days.");
            }
            return;
        }
    }

    private void publishTokenCreatedEvent(UserToken userToken) {
        UserToken userTokenForEvent = CiCloneHelper.cloneCi(userToken);
        userTokenForEvent.token_$eq(PasswordVerificationUtils$.MODULE$.PASSWORD_MASK());
        this.eventBus.publish((XLReleaseEvent)new UserTokenCreatedEvent(userTokenForEvent));
    }

    public static final /* synthetic */ void $anonfun$notifyTokensAboutToExpire$1(UserTokenService $this, UserToken userToken) {
        $this.eventBus.publish((XLReleaseEvent)new UserTokenAboutToExpireEvent(userToken));
        $this.userTokenRepository.updateTokenExpiredNotified(userToken.ciUid());
    }

    public UserTokenService(EventBus eventBus, UserTokenRepository userTokenRepository, PersonalAccessTokenFeature personalAccessTokenFeature) {
        this.eventBus = eventBus;
        this.userTokenRepository = userTokenRepository;
        this.personalAccessTokenFeature = personalAccessTokenFeature;
        Logging.$init$((Logging)this);
    }
}

