/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.engine.api.dto.Ordering;
import com.xebialabs.deployit.engine.api.dto.Paging;
import com.xebialabs.deployit.engine.spi.event.RoleDeletedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePermissionsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RolePrincipalsChangedEvent;
import com.xebialabs.deployit.engine.spi.event.RoleRenamedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.xlrelease.domain.events.GlobalRolesOrPermissionsUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.ReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.security.RolePermission;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005c\u0001B\f\u0019\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u00055\u0004\u0001\"\u0011\u0002p!9\u00111\u0010\u0001\u0005B\u0005u\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!!+\u0001\t\u0003\nY\u000bC\u0004\u0002V\u0002!\t%a6\t\u000f\u0005\u001d\b\u0001\"\u0011\u0002j\"9\u00111\u001f\u0001\u0005B\u0005U\bb\u0002B\u0005\u0001\u0011\u0005#1\u0002\u0005\b\u00057\u0001A\u0011\tB\u000f\u0011\u001d\u0011i\u0003\u0001C\u0005\u0005_AqAa\u000f\u0001\t\u0013\u0011iDA\rEK\u001a\fW\u000f\u001c;SK2,\u0017m]3S_2,7+\u001a:wS\u000e,'BA\r\u001b\u0003!\u0019XmY;sSRL(BA\u000e\u001d\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001e=\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002?\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tI#&D\u0001\u0019\u0013\tY\u0003D\u0001\nSK2,\u0017m]3S_2,7+\u001a:wS\u000e,\u0017!\u0005=m%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vgB\u0011a&M\u0007\u0002_)\u0011\u0001GG\u0001\u0007KZ,g\u000e^:\n\u0005Iz#!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006Y1-[%e'\u0016\u0014h/[2f!\t)\u0004(D\u00017\u0015\t9$$A\u0004tKJ4\u0018nY3\n\u0005e2$aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\fQC]3mK\u0006\u001cXMU8mKJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002*y%\u0011Q\b\u0007\u0002\u0016%\u0016dW-Y:f%>dWMU3q_NLGo\u001c:z\u0003}\u0011X\r\\3bg\u0016\u0014v\u000e\\3QKJl\u0017n]:j_:\u0014V\r]8tSR|'/\u001f\t\u0003S\u0001K!!\u0011\r\u0003?I+G.Z1tKJ{G.\u001a)fe6L7o]5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0006\t\u00163u\t\u0013\t\u0003S\u0001AQ\u0001L\u0003A\u00025BQaM\u0003A\u0002QBQAO\u0003A\u0002mBQAP\u0003A\u0002}\nabZ3u\u000f2|'-\u00197S_2,7\u000f\u0006\u0003L5\u001e\u001c\bc\u0001'R'6\tQJ\u0003\u0002O\u001f\u0006!Q\u000f^5m\u0015\u0005\u0001\u0016\u0001\u00026bm\u0006L!AU'\u0003\t1K7\u000f\u001e\t\u0003)bk\u0011!\u0016\u0006\u00033YS!a\u0016\u000f\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!W+\u0003\tI{G.\u001a\u0005\u00067\u001a\u0001\r\u0001X\u0001\fe>dW\rU1ui\u0016\u0014h\u000e\u0005\u0002^I:\u0011aL\u0019\t\u0003?\u0012j\u0011\u0001\u0019\u0006\u0003C\u0002\na\u0001\u0010:p_Rt\u0014BA2%\u0003\u0019\u0001&/\u001a3fM&\u0011QM\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\r$\u0003\"\u00025\u0007\u0001\u0004I\u0017A\u00029bO&tw\r\u0005\u0002kc6\t1N\u0003\u0002m[\u0006\u0019A\r^8\u000b\u00059|\u0017aA1qS*\u0011\u0001OV\u0001\u0007K:<\u0017N\\3\n\u0005I\\'A\u0002)bO&tw\rC\u0003u\r\u0001\u0007Q/A\u0003pe\u0012,'\u000f\u0005\u0002km&\u0011qo\u001b\u0002\t\u001fJ$WM]5oO\"\u0012a!\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018AC1o]>$\u0018\r^5p]*\u0011ap`\u0001\b[\u0016$(/[2t\u0015\r\t\tAH\u0001\tG>$\u0017\r[1mK&\u0019\u0011QA>\u0003\u000bQKW.\u001a3\u00027\u001d,Go\u00127pE\u0006d'k\u001c7f!JLgnY5qC24\u0016.Z<t)\u0011\tY!a\f\u0011\r\u00055\u0011qDA\u0012\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011A\u00023p[\u0006LgN\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00023bi\u0006TA!!\u0007\u0002\u001c\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\u001e\u0005\u0019qN]4\n\t\u0005\u0005\u0012q\u0002\u0002\u0005!\u0006<W\r\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICG\u0001\u0006m&,wo]\u0005\u0005\u0003[\t9C\u0001\nS_2,\u0007K]5oG&\u0004\u0018\r\\:WS\u0016<\bbBA\u0019\u000f\u0001\u0007\u00111G\u0001\ta\u0006<W-\u00192mKB!\u0011QBA\u001b\u0013\u0011\t9$a\u0004\u0003\u0011A\u000bw-Z1cY\u0016D#aB=\u0002\r\r\u0014X-\u0019;f)\u0019\ty$!\u0012\u0002JA\u00191%!\u0011\n\u0007\u0005\rCE\u0001\u0003V]&$\bBBA$\u0011\u0001\u0007A,A\np]\u000e{gNZ5hkJ\fG/[8o\u0013R,W\u000eC\u0004\u0002L!\u0001\r!!\u0014\u0002\u000bI|G.Z:\u0011\t\r\nyeU\u0005\u0004\u0003#\"#A\u0003\u001fsKB,\u0017\r^3e}!\u001a\u0001\"!\u0016\u0011\t\u0005]\u00131L\u0007\u0003\u00033R!\u0001 \u0013\n\t\u0005u\u0013\u0011\f\u0002\bm\u0006\u0014\u0018M]4tQ\tA\u00110\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003\u007f\t)'a\u001a\t\r\u0005\u001d\u0013\u00021\u0001]\u0011\u001d\tY%\u0003a\u0001\u0003\u001bB3!CA+Q\tI\u00110\u0001\tsK:\fW.Z$m_\n\fGNU8mKR1\u0011qHA9\u0003kBa!a\u001d\u000b\u0001\u0004a\u0016aB8mI:\u000bW.\u001a\u0005\u0007\u0003oR\u0001\u0019\u0001/\u0002\u000f9,wOT1nK\"\u0012!\"_\u0001\u0011I\u0016dW\r^3HY>\u0014\u0017\r\u001c*pY\u0016$B!a\u0010\u0002\u0000!1\u0011\u0011Q\u0006A\u0002q\u000b\u0001B]8mK:\u000bW.\u001a\u0015\u0003\u0017e\fQbZ3u\u000f2|'-\u00197S_2,G\u0003BAE\u0003\u001f\u0003BaIAF'&\u0019\u0011Q\u0012\u0013\u0003\r=\u0003H/[8o\u0011\u0019\t\t\t\u0004a\u00019\"\u0012A\"_\u0001\u001cO\u0016$x\t\\8cC2\u0014v\u000e\\3Qe&t7-\u001b9bYN4\u0016.Z<\u0015\t\u0005\r\u0012q\u0013\u0005\u0007\u0003\u0003k\u0001\u0019\u0001/)\u00055I\u0018\u0001E4m_\n\fGNU8mK\u0016C\u0018n\u001d;t)\u0011\ty*!*\u0011\u0007\r\n\t+C\u0002\u0002$\u0012\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002\u0002:\u0001\r\u0001\u0018\u0015\u0003\u001de\f!e\u0019:fCR,w\t\\8cC2\u0014v\u000e\\3B]\u0012\u0014v\u000e\\3QKJl\u0017n]:j_:\u001cH\u0003BA \u0003[Cq!a,\u0010\u0001\u0004\t\t,\u0001\u0005sKF,Xm\u001d;t!\u0015\u0019\u0013qJAZ!\u0011\t),a3\u000f\t\u0005]\u0016q\u0019\b\u0005\u0003s\u000b)M\u0004\u0003\u0002<\u0006\rg\u0002BA_\u0003\u0003t1aXA`\u0013\u0005y\u0012BA\u000f\u001f\u0013\tYB$\u0003\u0002\u001a5%\u0019\u0011\u0011\u001a\r\u0002%I+G.Z1tKJ{G.Z*feZL7-Z\u0005\u0005\u0003\u001b\fyMA\tS_2,7I]3bi\u0016\u0014V-];fgRT1!!3\u0019Q\ry\u0011Q\u000b\u0015\u0003\u001fe\f!%\u001e9eCR,w\t\\8cC2\u0014v\u000e\\3B]\u0012\u0014v\u000e\\3QKJl\u0017n]:j_:\u001cH\u0003BA \u00033Dq!a,\u0011\u0001\u0004\tY\u000eE\u0003$\u0003\u001f\ni\u000e\u0005\u0003\u00026\u0006}\u0017\u0002BAq\u0003\u001f\u0014\u0011CU8mKV\u0003H-\u0019;f%\u0016\fX/Z:uQ\r\u0001\u0012Q\u000b\u0015\u0003!e\f1dZ3u\u00032dw\t\\8cC2\u0014v\u000e\\3QKJl\u0017n]:j_:\u001cHCAAv!\u0011\t),!<\n\t\u0005=\u0018q\u001a\u0002\u0016\u000f2|'-\u00197S_2,\u0007+\u001a:nSN\u001c\u0018n\u001c8tQ\t\t\u00120\u0001\nhKR\u0014v\u000e\\3QKJl\u0017n]:j_:\u001cH\u0003BA|\u0003{\u0004B!!.\u0002z&!\u00111`Ah\u0005=\u0001VM]7jgNLwN\u001c(b[\u0016\u001c\bbBA\u0000%\u0001\u0007!\u0011A\u0001\u0007e>dW-\u00133\u0011\t\u0005U&1A\u0005\u0005\u0005\u000b\tyM\u0001\u0004S_2,\u0017\n\u001a\u0015\u0003%e\f1d\u0019:fCR,w\t\\8cC2\u0014v\u000e\\3QKJl\u0017n]:j_:\u001cH\u0003BA \u0005\u001bAq!a,\u0014\u0001\u0004\u0011y\u0001E\u0003$\u0003\u001f\u0012\t\u0002\u0005\u0003\u00026\nM\u0011\u0002\u0002B\u000b\u0003\u001f\u00141DU8mKB+'/\\5tg&|gn\u0011:fCR,'+Z9vKN$\bfA\n\u0002V!\u00121#_\u0001\u001ckB$\u0017\r^3HY>\u0014\u0017\r\u001c*pY\u0016\u0004VM]7jgNLwN\\:\u0015\t\u0005}\"q\u0004\u0005\b\u0003_#\u0002\u0019\u0001B\u0011!\u0015\u0019\u0013q\nB\u0012!\u0011\t)L!\n\n\t\t\u001d\u0012q\u001a\u0002\u001c%>dW\rU3s[&\u001c8/[8o+B$\u0017\r^3SKF,Xm\u001d;)\u0007Q\t)\u0006\u000b\u0002\u0015s\u0006yb-\u001b:f%>dW\rU3s[&\u001c8/[8og\u000eC\u0017M\\4fI\u00163XM\u001c;\u0015\t\u0005}\"\u0011\u0007\u0005\b\u0003_+\u0002\u0019\u0001B\u001a!\u0015\u0019\u0013q\nB\u001b!\u0011\t)La\u000e\n\t\te\u0012q\u001a\u0002\u0015%>dW\rU3s[&\u001c8/[8o\u0007\"\fgnZ3\u0002;\u0019L'/\u001a*pY\u0016\u0004&/\u001b8dSB\fGn\u00115b]\u001e,WI^3oiN$B!a\u0010\u0003@!9\u00111\n\fA\u0002\u00055\u0003")
public class DefaultReleaseRoleService
implements ReleaseRoleService {
    private final XLReleaseEventBus xlReleaseEventBus;
    private final CiIdService ciIdService;
    private final ReleaseRoleRepository releaseRoleRepository;
    private final ReleaseRolePermissionRepository releaseRolePermissionRepository;

    @Override
    public List<Role> getGlobalRoles() {
        return ReleaseRoleService.getGlobalRoles$(this);
    }

    @Override
    public void create(scala.collection.immutable.Seq<Role> roles) {
        ReleaseRoleService.create$((ReleaseRoleService)this, roles);
    }

    @Override
    public void update(scala.collection.immutable.Seq<Role> roles) {
        ReleaseRoleService.update$((ReleaseRoleService)this, roles);
    }

    @Override
    public void create(Role ... roles) {
        ReleaseRoleService.create$((ReleaseRoleService)this, roles);
    }

    @Override
    public void update(Role ... roles) {
        ReleaseRoleService.update$((ReleaseRoleService)this, roles);
    }

    @Override
    public void create(String onConfigurationItem, Role ... roles) {
        this.create(onConfigurationItem, (scala.collection.immutable.Seq<Role>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @Override
    public void update(String onConfigurationItem, Role ... roles) {
        this.update(onConfigurationItem, (scala.collection.immutable.Seq<Role>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @Override
    public void createGlobalRoleAndRolePermissions(ReleaseRoleService.RoleCreateRequest ... requests) {
        this.createGlobalRoleAndRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RoleCreateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void updateGlobalRoleAndRolePermissions(ReleaseRoleService.RoleUpdateRequest ... requests) {
        this.updateGlobalRoleAndRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RoleUpdateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void createGlobalRolePermissions(ReleaseRoleService.RolePermissionCreateRequest ... requests) {
        this.createGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    public void updateGlobalRolePermissions(ReleaseRoleService.RolePermissionUpdateRequest ... requests) {
        this.updateGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])requests));
    }

    @Override
    @Timed
    public List<Role> getGlobalRoles(String rolePattern, Paging paging, Ordering order) {
        return this.releaseRoleRepository.getGlobalRoles(rolePattern, paging, order);
    }

    @Override
    @Timed
    public Page<RolePrincipalsView> getGlobalRolePrincipalViews(Pageable pageable) {
        return this.releaseRoleRepository.getGlobalRolePrincipals(pageable);
    }

    @Override
    @Timed
    public void create(String onConfigurationItem, scala.collection.immutable.Seq<Role> roles) {
        this.releaseRoleRepository.create(onConfigurationItem, roles);
        this.fireRolePrincipalChangeEvents(roles);
    }

    @Override
    @Timed
    public void update(String onConfigurationItem, scala.collection.immutable.Seq<Role> roles) {
        this.releaseRoleRepository.update(onConfigurationItem, roles);
        this.fireRolePrincipalChangeEvents(roles);
    }

    @Override
    @Timed
    public void renameGlobalRole(String oldName, String newName) {
        this.releaseRoleRepository.renameGlobalRole(oldName, newName);
        EventBusHolder.publish((Object)new RoleRenamedEvent(oldName, newName));
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public void deleteGlobalRole(String roleName) {
        Role foundRole = (Role)this.releaseRoleRepository.getGlobalRole(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Could not find the role [%s]", new Object[]{roleName});
        });
        this.releaseRoleRepository.deleteGlobalRole(foundRole.getId());
        EventBusHolder.publish((Object)new RoleDeletedEvent(roleName));
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public Option<Role> getGlobalRole(String roleName) {
        return this.releaseRoleRepository.getGlobalRole(roleName);
    }

    @Override
    @Timed
    public RolePrincipalsView getGlobalRolePrincipalsView(String roleName) {
        return (RolePrincipalsView)this.releaseRoleRepository.getGlobalRolePrincipal(roleName).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Role [" + roleName + "] not found", new Object[0]);
        });
    }

    @Override
    @Timed
    public boolean globalRoleExists(String roleName) {
        return this.releaseRoleRepository.globalRoleExists(roleName);
    }

    @Override
    @Timed
    public void createGlobalRoleAndRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RoleCreateRequest> requests) {
        Tuple2 tuple2 = ((IterableOps)requests.map((Function1 & Serializable)request -> {
            String roleId = Ids.getName((String)$this.ciIdService.getUniqueId("Role", TeamService.GLOBAL_ROLES_ROOT));
            Role role = new Role(roleId, request.roleName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.SetHasAsScala(request.rolePrincipals()).asScala().toList()).asJava());
            ReleaseRoleService.RolePermissionCreateRequest rolePermission = new ReleaseRoleService.RolePermissionCreateRequest(roleId, role.getName(), request.rolePermissions());
            return new Tuple2((Object)role, (Object)rolePermission);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)roles, (Object)rolePermissions);
        scala.collection.immutable.Seq roles2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq rolePermissions2 = (scala.collection.immutable.Seq)tuple22._2();
        this.create((scala.collection.immutable.Seq<Role>)roles2);
        this.createGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest>)rolePermissions2);
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public void updateGlobalRoleAndRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RoleUpdateRequest> requests) {
        Tuple2 tuple2 = ((IterableOps)requests.map((Function1 & Serializable)request -> {
            Role role = new Role(request.roleId(), request.roleName(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)CollectionConverters$.MODULE$.SetHasAsScala(request.rolePrincipals()).asScala().toList()).asJava());
            ReleaseRoleService.RolePermissionUpdateRequest rolePermission = new ReleaseRoleService.RolePermissionUpdateRequest(request.roleId(), role.getName(), request.rolePermissions());
            return new Tuple2((Object)role, (Object)rolePermission);
        })).unzip(Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq roles = (scala.collection.immutable.Seq)tuple2._1();
        scala.collection.immutable.Seq rolePermissionRequests = (scala.collection.immutable.Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)roles, (Object)rolePermissionRequests);
        scala.collection.immutable.Seq roles2 = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq rolePermissionRequests2 = (scala.collection.immutable.Seq)tuple22._2();
        this.update((scala.collection.immutable.Seq<Role>)roles2);
        this.updateGlobalRolePermissions((scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest>)rolePermissionRequests2);
        this.xlReleaseEventBus.publish((XLReleaseEvent)new GlobalRolesOrPermissionsUpdatedEvent());
    }

    @Override
    @Timed
    public java.util.Map<String, Set<String>> getAllGlobalRolePermissions() {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)this.releaseRolePermissionRepository.getGlobalRolePermissions().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends RolePermission, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String roleId = A1.roleId();
                    Set<String> rps = A1.permissionNames();
                    return (B1)new Tuple2((Object)roleId, rps);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(RolePermission x1) {
                RolePermission rolePermission = x1;
                return rolePermission != null;
            }
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    @Override
    @Timed
    public Set<String> getRolePermissions(String roleId) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releaseRolePermissionRepository.getRolePermissions(roleId)).asJava();
    }

    @Override
    @Timed
    public void createGlobalRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionCreateRequest> requests) {
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> new RolePermission(request.roleId(), request.permissionNames()));
        this.releaseRolePermissionRepository.createGlobalRolePermissions((scala.collection.immutable.Seq<RolePermission>)rolePermissions);
        this.fireRolePermissionsChangedEvent(requests);
    }

    @Override
    @Timed
    public void updateGlobalRolePermissions(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionUpdateRequest> requests) {
        scala.collection.immutable.Seq rolePermissions = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> new RolePermission(request.roleId(), request.permissionNames()));
        this.releaseRolePermissionRepository.updateGlobalRolePermissions((scala.collection.immutable.Seq<RolePermission>)rolePermissions);
        this.fireRolePermissionsChangedEvent(requests);
    }

    private void fireRolePermissionsChangedEvent(scala.collection.immutable.Seq<ReleaseRoleService.RolePermissionChange> requests) {
        scala.collection.immutable.Seq msgs = (scala.collection.immutable.Seq)requests.map((Function1 & Serializable)request -> request.roleName() + " => " + request.permissionNames());
        EventBusHolder.publish((Object)new RolePermissionsChangedEvent(PermissionChecker$.MODULE$.GLOBAL_SECURITY_ALIAS(), CollectionConverters$.MODULE$.SeqHasAsJava((Seq)msgs).asJava()));
    }

    private void fireRolePrincipalChangeEvents(scala.collection.immutable.Seq<Role> roles) {
        scala.collection.immutable.Seq rolePrincipals = (scala.collection.immutable.Seq)roles.map((Function1 & Serializable)role -> role.getName() + " => " + role.getPrincipals());
        EventBusHolder.publish((Object)new RolePrincipalsChangedEvent(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)rolePrincipals).asJava()));
    }

    public DefaultReleaseRoleService(XLReleaseEventBus xlReleaseEventBus, CiIdService ciIdService, ReleaseRoleRepository releaseRoleRepository, ReleaseRolePermissionRepository releaseRolePermissionRepository) {
        this.xlReleaseEventBus = xlReleaseEventBus;
        this.ciIdService = ciIdService;
        this.releaseRoleRepository = releaseRoleRepository;
        this.releaseRolePermissionRepository = releaseRolePermissionRepository;
        ReleaseRoleService.$init$(this);
    }
}

