/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.support.pekko.spring.SpringExtension;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u000b\u0017\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!q\u0005A!A!\u0002\u0013y\u0005\"B*\u0001\t\u0003!\u0006\u0002C.\u0001\u0011\u000b\u0007I\u0011\u0002/\t\u000b!\u0004A\u0011A5\t\u000bq\u0004A\u0011A?\t\r}\u0004A\u0011AA\u0001\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!!\u001d\u0001\t\u0003\t\u0019\bC\u0004\u0002\u0004\u0002!\t!!\"\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0006bBAd\u0001\u0011\u0005\u0011\u0011Z\u0004\b\u0003k4\u0002\u0012AA|\r\u0019)b\u0003#\u0001\u0002z\"11K\u0005C\u0001\u0003wDq!!@\u0013\t\u0003\tyPA\fUCN\\W\t_3dkRLwN\u001c'pON+'O^5dK*\u0011q\u0003G\u0001\u0005Y><7O\u0003\u0002\u001a5\u0005I1o\u00195fIVdWM\u001d\u0006\u00037q\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005uq\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005y\u0012aA2p[\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000bMdg\r\u000e6\u000b\u00035\n\u0001b\u001a:jujdW\rZ\u0005\u0003_)\u0012q\u0001T8hO&tw-A\btaJLgnZ#yi\u0016t7/[8o!\t\u0011\u0014(D\u00014\u0015\t!T'\u0001\u0004taJLgn\u001a\u0006\u0003m]\nQ\u0001]3lW>T!\u0001\u000f\u000e\u0002\u000fM,\b\u000f]8si&\u0011!h\r\u0002\u0010'B\u0014\u0018N\\4FqR,gn]5p]\u0006\u0001\"M]8bI\u000e\f7\u000f^*feZL7-\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007fi\tqa]3sm&\u001cW-\u0003\u0002B}\t\u0001\"I]8bI\u000e\f7\u000f^*feZL7-Z\u0001\u000fgR|'/Y4f'\u0016\u0014h/[2f!\t!\u0005*D\u0001F\u0015\tydI\u0003\u0002H5\u000591\u000f^8sC\u001e,\u0017BA%F\u00059\u0019Fo\u001c:bO\u0016\u001cVM\u001d<jG\u0016\f1\u0002^1tWN+'O^5dKB\u0011Q\bT\u0005\u0003\u001bz\u00121\u0002V1tWN+'O^5dK\u00069B/Y:l\u000bb,7-\u001e;j_:\u0014V\r]8tSR|'/\u001f\t\u0003!Fk\u0011AF\u0005\u0003%Z\u0011q\u0003V1tW\u0016CXmY;uS>t'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)\u0019)fk\u0016-Z5B\u0011\u0001\u000b\u0001\u0005\u0006a\u0019\u0001\r!\r\u0005\u0006w\u0019\u0001\r\u0001\u0010\u0005\u0006\u0005\u001a\u0001\ra\u0011\u0005\u0006\u0015\u001a\u0001\ra\u0013\u0005\u0006\u001d\u001a\u0001\raT\u0001\u001cKb,7-\u001e;j_:dunZ,bi\u000eDWM]!di>\u0014(+\u001a4\u0016\u0003u\u0003\"A\u00184\u000e\u0003}S!\u0001Y1\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0005Y\u0012'BA2e\u0003\u0019\t\u0007/Y2iK*\tQ-A\u0002pe\u001eL!aZ0\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\fQa^1uG\"$2A[7{!\t\u00193.\u0003\u0002mI\t!QK\\5u\u0011\u0015q\u0007\u00021\u0001p\u0003\u0019!\u0018m]6JIB\u0011\u0001o\u001e\b\u0003cV\u0004\"A\u001d\u0013\u000e\u0003MT!\u0001\u001e\u0011\u0002\rq\u0012xn\u001c;?\u0013\t1H%\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<%\u0011\u0015Y\b\u00021\u0001p\u0003-)\u00070Z2vi&|g.\u00133\u0002\u0013M$x\u000e],bi\u000eDGC\u00016\u007f\u0011\u0015Y\u0018\u00021\u0001p\u0003\u00151W\r^2i)-Q\u00171AA\u0003\u0003\u000f\tY\"!\u0013\t\u000b9T\u0001\u0019A8\t\u000bmT\u0001\u0019A8\t\u000f\u0005%!\u00021\u0001\u0002\f\u0005aq.\u001e;qkR\u001cFO]3b[B!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011AA5p\u0015\t\t)\"\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003\u001f\u0011AbT;uaV$8\u000b\u001e:fC6Dq!!\b\u000b\u0001\u0004\ty\"A\u0004mCN$(j\u001c2\u0011\t\u0005\u0005\u00121\t\b\u0005\u0003G\tiD\u0004\u0003\u0002&\u0005]b\u0002BA\u0014\u0003gqA!!\u000b\u000229!\u00111FA\u0018\u001d\r\u0011\u0018QF\u0005\u0002?%\u0011QDH\u0005\u00037qI1!!\u000e\u001b\u0003\u0019\u0011XO\u001c8fe&!\u0011\u0011HA\u001e\u0003\u0019!w.\\1j]*\u0019\u0011Q\u0007\u000e\n\t\u0005}\u0012\u0011I\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\tI$a\u000f\n\t\u0005\u0015\u0013q\t\u0002\u0006\u0015>\u0014\u0017\n\u001a\u0006\u0005\u0003\u007f\t\t\u0005C\u0004\u0002L)\u0001\r!!\u0014\u0002\u00131\f7\u000f^\"ik:\\\u0007cA\u0012\u0002P%\u0019\u0011\u0011\u000b\u0013\u0003\t1{gnZ\u0001\u0013M\u0016$8\r[!mY\u0016CXmY;uS>t7\u000f\u0006\u0003\u0002X\u0005=\u0004CBA-\u0003?\n\u0019'\u0004\u0002\u0002\\)!\u0011QLA\n\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00141\f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tIGG\u0001\u0006m&,wo]\u0005\u0005\u0003[\n9G\u0001\u000bUCN\\W\t_3dkRLwN\u001c'pOZKWm\u001e\u0005\u0006].\u0001\ra\\\u0001\u0004Y><Gc\u00016\u0002v!9\u0011q\u000f\u0007A\u0002\u0005e\u0014\u0001\u00037pO\u0016sGO]=\u0011\t\u0005m\u0014qP\u0007\u0003\u0003{R1!!\u000fG\u0013\u0011\t\t)! \u0003\u00111{w-\u00128uef\fQcZ3u)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8F]R\u0014\u0018\u0010\u0006\u0004\u0002\b\u0006M\u0015Q\u0013\t\u0006G\u0005%\u0015QR\u0005\u0004\u0003\u0017##AB(qi&|g\u000eE\u0002Q\u0003\u001fK1!!%\u0017\u0005I!\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sGO]=\t\u000b9l\u0001\u0019A8\t\u000bml\u0001\u0019A8\u0002\u001b=t'j\u001c2GS:L7\u000f[3e)\rQ\u00171\u0014\u0005\b\u0003;s\u0001\u0019AAP\u0003\u0015)g/\u001a8u!\u0011\t\t+a*\u000e\u0005\u0005\r&bAAS1\u00051QM^3oiNLA!!+\u0002$\n\u0001\"j\u001c2GS:L7\u000f[3e\u000bZ,g\u000e\u001e\u0015\u0004\u001d\u00055\u0006\u0003BAX\u0003gk!!!-\u000b\u0007\u0005\u0015&$\u0003\u0003\u00026\u0006E&!C*vEN\u001c'/\u001b2f\u0003Ayg\u000eV1tW2{wm\u0011:fCR,G\rF\u0002k\u0003wCq!!0\u0010\u0001\u0004\ty,\u0001\u0007uCN\\Gj\\4Fm\u0016tG\u000fE\u0002Q\u0003\u0003L1!a1\u0017\u00059!\u0016m]6M_\u001e\u001c%/Z1uK\u0012D3aDAW\u0003Myg\u000eV1tW\u0016CXmY;uS>tGi\u001c8f)\rQ\u00171\u001a\u0005\b\u0003;\u0003\u0002\u0019AAg!\u0011\ty-!6\u000e\u0005\u0005E'\u0002BAS\u0003'T1!!\u000f\u001b\u0013\u0011\t9.!5\u0003)Q\u000b7o\u001b&pE\u0016CXmY;uK\u0012,e/\u001a8uQ\r\u0001\u0012Q\u0016\u0015\u0004\u0001\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\u000bgR,'/Z8usB,'bAAtI\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148.\u0003\u0003\u0002l\u0006\u0005(aB*feZL7-\u001a\u0015\u0004\u0001\u0005=\b\u0003BAX\u0003cLA!a=\u00022\niQI^3oi2K7\u000f^3oKJ\fq\u0003V1tW\u0016CXmY;uS>tGj\\4TKJ4\u0018nY3\u0011\u0005A\u00132C\u0001\n#)\t\t90\u0001\u0003iCNDGcA8\u0003\u0002!)a\u000e\u0006a\u0001_\u0002")
public class TaskExecutionLogService
implements Logging {
    private ActorRef executionLogWatcherActorRef;
    private final SpringExtension springExtension;
    private final BroadcastService broadcastService;
    private final StorageService storageService;
    private final TaskService taskService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static String hash(String taskId) {
        return TaskExecutionLogService$.MODULE$.hash(taskId);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$0) {
                this.executionLogWatcherActorRef = this.springExtension.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers", this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ActorRef executionLogWatcherActorRef() {
        if (!this.bitmap$0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    public void watch(String taskId, String executionId) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, User.AUTHENTICATED_USER.getName());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void stopWatch(String executionId) {
        ExecutionLogWatchActor.StopWatching x$1 = new ExecutionLogWatchActor.StopWatching(executionId, (Option<String>)new Some((Object)User.AUTHENTICATED_USER.getName()));
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                Option$.MODULE$.apply((Object)row.endDate()).foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        String x$1 = "xlr-local";
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, "xlr-local");
        URI storedEntryUri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskStatus taskStatus = this.taskService.getStatus(logEntry.taskId());
        this.logger().info((Function0 & Serializable)() -> "Adding log entry with task status: " + taskStatus);
        Option<TaskExecutionEntry> option = taskStatus.isOneOf(new TaskStatus[]{TaskStatus.COMPLETED, TaskStatus.SKIPPED, TaskStatus.ABORTED, TaskStatus.FAILED, TaskStatus.FAILING, TaskStatus.ABORT_SCRIPT_IN_PROGRESS, TaskStatus.FAILURE_HANDLER_IN_PROGRESS}) ? this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)new Some((Object)Instant.now()))) : this.taskExecutionRepository.update(new TaskExecutionRepository.UpdateWithLogEntry(workerLogEntry, (Option<Instant>)None$.MODULE$));
        this.broadcastService.broadcast(new TaskLogCreated(logEntry.taskId(), logEntry.executionId(), storedEntryUri), true);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uri());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2((Object)x$1);
        this.executionLogWatcherActorRef().$bang((Object)x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        TaskExecutionRepository.FinishExecution finishExecution = new TaskExecutionRepository.FinishExecution(event.taskId(), event.executionId(), Instant.now());
        this.taskExecutionRepository.update(finishExecution);
    }

    public TaskExecutionLogService(SpringExtension springExtension, BroadcastService broadcastService, StorageService storageService, TaskService taskService, TaskExecutionRepository taskExecutionRepository) {
        this.springExtension = springExtension;
        this.broadcastService = broadcastService;
        this.storageService = storageService;
        this.taskService = taskService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

