/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.xebialabs.xlplatform.cluster.ClusterMode;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRecoveryLogic;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NodeId;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.WorkerThread;
import com.xebialabs.xlrelease.scheduler.service.JobService;
import com.xebialabs.xlrelease.scheduler.workers.CompositeWorker;
import com.xebialabs.xlrelease.script.DefaultScriptService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.PrefixedThreadFactory$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.pekko.actor.Address;
import org.slf4j.Marker;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\u0013&\u00019B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005w!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003E\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011E\u0003!Q1A\u0005\u0002IC\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t5\u0002\u0011)\u0019!C\u00017\"A!\r\u0001B\u0001B\u0003%A\f\u0003\u0005d\u0001\t\u0015\r\u0011\"\u0001e\u0011!Y\u0007A!A!\u0002\u0013)\u0007\u0002\u00037\u0001\u0005\u000b\u0007I\u0011A7\t\u0011E\u0004!\u0011!Q\u0001\n9DQA\u001d\u0001\u0005\u0002MD!\"a\u0005\u0001\u0011\u000b\u0007I\u0011BA\u000b\u0011-\ti\u0002\u0001a\u0001\u0002\u0004%I!a\b\t\u0017\u0005U\u0002\u00011AA\u0002\u0013%\u0011q\u0007\u0005\f\u0003\u0007\u0002\u0001\u0019!A!B\u0013\t\t\u0003C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002H!A\u0011Q\u000b\u0001!\u0002\u0013\tI\u0005C\u0005\u0002X\u0001\u0011\r\u0011\"\u0003\u0002Z!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0006C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002v!A\u00111\u0011\u0001!\u0002\u0013\t9\bC\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\b\"9\u00111\u0012\u0001\u0005\n\u0005\u001d\u0005bBAG\u0001\u0011%\u0011q\u0011\u0005\b\u0003\u001f\u0003A\u0011BA\u0010\u0011\u001d\t\t\n\u0001C\u0001\u0003\u000fCq!a%\u0001\t\u0003\t)\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u00111\u0019\u0001\u0005\n\u0005\u0015'aC,pe.l\u0015M\\1hKJT!AJ\u0014\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(B\u0001\u0015*\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002+W\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002Y\u0005\u00191m\\7\u0004\u0001M\u0019\u0001aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g!\t1t'D\u0001&\u0013\tATE\u0001\tK_\n\u0014VmY8wKJLHj\\4jG\u0006I\u0001\u0010\u001c:D_:4\u0017nZ\u000b\u0002wA\u0011AhP\u0007\u0002{)\u0011ahJ\u0001\u0007G>tg-[4\n\u0005\u0001k$!\u0003-me\u000e{gNZ5h\u0003)AHN]\"p]\u001aLw\rI\u0001\tU>\u0014\u0017+^3vKV\tA\t\u0005\u00027\u000b&\u0011a)\n\u0002\t\u0015>\u0014\u0017+^3vK\u0006I!n\u001c2Rk\u0016,X\rI\u0001\u0010G>l\u0007o\\:ji\u0016<vN]6feV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002NK\u00059qo\u001c:lKJ\u001c\u0018BA(M\u0005=\u0019u.\u001c9pg&$XmV8sW\u0016\u0014\u0018\u0001E2p[B|7/\u001b;f/>\u00148.\u001a:!\u0003)QwNY*feZL7-Z\u000b\u0002'B\u0011AkV\u0007\u0002+*\u0011a+J\u0001\bg\u0016\u0014h/[2f\u0013\tAVK\u0001\u0006K_\n\u001cVM\u001d<jG\u0016\f1B[8c'\u0016\u0014h/[2fA\u0005\u0019\"n\u001c2Sk:tWM\u001d*fa>\u001c\u0018\u000e^8ssV\tA\f\u0005\u0002^A6\taL\u0003\u0002`O\u0005Q!/\u001a9pg&$xN]=\n\u0005\u0005t&a\u0005&pEJ+hN\\3s%\u0016\u0004xn]5u_JL\u0018\u0001\u00066pEJ+hN\\3s%\u0016\u0004xn]5u_JL\b%A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW-F\u0001f!\t1\u0017.D\u0001h\u0015\tAw%\u0001\u0004bGR|'o]\u0005\u0003U\u001e\u00141CU3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\fAC]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\u0013!E1di>\u00148+_:uK6Du\u000e\u001c3feV\ta\u000e\u0005\u0002g_&\u0011\u0001o\u001a\u0002\u0012\u0003\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\u0018AE1di>\u00148+_:uK6Du\u000e\u001c3fe\u0002\na\u0001P5oSRtD\u0003\u0003;vm^D\u0018P_>\u0011\u0005Y\u0002\u0001\"B\u001d\u0010\u0001\u0004Y\u0004\"\u0002\"\u0010\u0001\u0004!\u0005\"\u0002%\u0010\u0001\u0004Q\u0005\"B)\u0010\u0001\u0004\u0019\u0006\"\u0002.\u0010\u0001\u0004a\u0006\"B2\u0010\u0001\u0004)\u0007\"\u00027\u0010\u0001\u0004q\u0007FA>~!\rq\u0018qB\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u0003\u000b\t9!A\u0004d_:$X\r\u001f;\u000b\t\u0005%\u00111B\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u0011QB\u0001\u0004_J<\u0017bAA\t\u007f\n!A*\u0019>z\u0003=i\u0017\r\u001f+ie\u0016\fGm]\"pk:$XCAA\f!\r\u0001\u0014\u0011D\u0005\u0004\u00037\t$aA%oi\u0006QA\u000f\u001b:fC\u0012\u0004vn\u001c7\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003ci!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\u0016\u0003[\tA!\u001e;jY*\u0011\u0011qF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005\u0015\"aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u001dQD'/Z1e!>|Gn\u0018\u0013fcR!\u0011\u0011HA !\r\u0001\u00141H\u0005\u0004\u0003{\t$\u0001B+oSRD\u0011\"!\u0011\u0013\u0003\u0003\u0005\r!!\t\u0002\u0007a$\u0013'A\u0006uQJ,\u0017\r\u001a)p_2\u0004\u0013AE:ikR$wn\u001e8J]B\u0013xn\u001a:fgN,\"!!\u0013\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bRA!a\u0014\u0002&\u00051\u0011\r^8nS\u000eLA!a\u0015\u0002N\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\f1c\u001d5vi\u0012|wO\\%o!J|wM]3tg\u0002\nQb^8sW\u0016\u0014H\u000b\u001b:fC\u0012\u001cXCAA.!\u0019\ti&a\u001a\u0002l5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0015\u0014'\u0001\u0006d_2dWm\u0019;j_:LA!!\u001b\u0002`\t1!)\u001e4gKJ\u00042ANA7\u0013\r\ty'\n\u0002\r/>\u00148.\u001a:UQJ,\u0017\rZ\u0001\u000fo>\u00148.\u001a:UQJ,\u0017\rZ:!\u00039!\u0016iU&`\u000bb+5)\u0016+J\u001f:+\"!a\u001e\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wRA!! \u0002.\u0005!A.\u00198h\u0013\u0011\t\t)a\u001f\u0003\rM#(/\u001b8h\u0003=!\u0016iU&`\u000bb+5)\u0016+J\u001f:\u0003\u0013!B:uCJ$HCAA\u001d\u0003-\u0011XmY8wKJTuNY:\u0002\u0019M$\u0018M\u001d;UQJ,\u0017\rZ:\u0002\tM$x\u000e]\u0001\u000eO\u0016$H\u000b\u001b:fC\u0012\u0004vn\u001c7\u0002\u0011MDW\u000f\u001e3po:\faa];c[&$H\u0003BA\u001d\u0003/Cq!!'!\u0001\u0004\tY*A\u0002k_\n\u00042ANAO\u0013\r\ty*\n\u0002\u0004\u0015>\u0014\u0017a\u0002:fa2\f7-\u001a\u000b\u0005\u0003s\t)\u000bC\u0004\u0002\u001a\u0006\u0002\r!a'\u0002!\u0005\u0014wN\u001d;K_\n\u0014\u0015\u0010V1tW&#G\u0003BA\u001d\u0003WCq!!,#\u0001\u0004\ty+\u0001\u0004uCN\\\u0017\n\u001a\t\u0005\u0003c\u000byL\u0004\u0003\u00024\u0006m\u0006cAA[c5\u0011\u0011q\u0017\u0006\u0004\u0003sk\u0013A\u0002\u001fs_>$h(C\u0002\u0002>F\na\u0001\u0015:fI\u00164\u0017\u0002BAA\u0003\u0003T1!!02\u0003a\u0011X-];fgR\u0014VO\u001c8feR{\u0017IY8siR\u000b7o\u001b\u000b\u0005\u0003s\t9\rC\u0004\u0002.\u000e\u0002\r!a,)\u0007\u0001\tY\r\u0005\u0003\u0002N\u0006MWBAAh\u0015\u0011\t\t.a\u0002\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002V\u0006='aB*feZL7-\u001a")
public class WorkManager
implements JobRecoveryLogic {
    private int maxThreadsCount;
    private final XlrConfig xlrConfig;
    private final JobQueue jobQueue;
    private final CompositeWorker compositeWorker;
    private final JobService jobService;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final ActorSystemHolder actorSystemHolder;
    private ExecutorService threadPool;
    private final AtomicBoolean shutdownInProgress;
    private final Buffer<WorkerThread> workerThreads;
    private final String TASK_EXECUTION;
    private String nodeId;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public void recoverAllJobs() {
        JobRecoveryLogic.recoverAllJobs$(this);
    }

    @Override
    public void recoverJobs(String nodeId) {
        JobRecoveryLogic.recoverJobs$(this, nodeId);
    }

    @Override
    public String convertAddressToNodeId(Address address) {
        return NodeId.convertAddressToNodeId$(this, address);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private String nodeId$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.nodeId = NodeId.nodeId$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.nodeId;
    }

    @Override
    public String nodeId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.nodeId$lzycompute();
        }
        return this.nodeId;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    @Override
    public JobQueue jobQueue() {
        return this.jobQueue;
    }

    public CompositeWorker compositeWorker() {
        return this.compositeWorker;
    }

    @Override
    public JobService jobService() {
        return this.jobService;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    @Override
    public ReleaseActorService releaseActorService() {
        return this.releaseActorService;
    }

    @Override
    public ActorSystemHolder actorSystemHolder() {
        return this.actorSystemHolder;
    }

    private int maxThreadsCount$lzycompute() {
        WorkManager workManager = this;
        synchronized (workManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.maxThreadsCount = this.xlrConfig().executors().scheduler().maxThreadsCount();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.maxThreadsCount;
    }

    private int maxThreadsCount() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.maxThreadsCount$lzycompute();
        }
        return this.maxThreadsCount;
    }

    private ExecutorService threadPool() {
        return this.threadPool;
    }

    private void threadPool_$eq(ExecutorService x$1) {
        this.threadPool = x$1;
    }

    private AtomicBoolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    private Buffer<WorkerThread> workerThreads() {
        return this.workerThreads;
    }

    private String TASK_EXECUTION() {
        return this.TASK_EXECUTION;
    }

    public void start() {
        this.logger().info((Function0 & Serializable)() -> "Starting work manager with " + this.maxThreadsCount() + " threads");
        this.stop();
        this.jobQueue().cancelIf(x$2 -> true);
        this.jobQueue().start();
        if (this.xlrConfig().maintenanceModeEnabled()) {
            this.logger().debug((Function0 & Serializable)() -> "[MAINTENANCE MODE] Job recovery - DISABLED");
        } else {
            this.recoverJobs();
        }
        this.startThreads();
        this.logger().info((Function0 & Serializable)() -> "Started work manager");
    }

    public void recoverJobs() {
        try {
            this.logger().debug((Function0 & Serializable)() -> "Job recovery started");
            ClusterMode clusterMode = this.xlrConfig().cluster().mode();
            if (ClusterMode.Standalone$.MODULE$.equals(clusterMode)) {
                this.recoverAllJobs();
            } else {
                this.recoverJobs(this.nodeId());
                this.recoverJobs(null);
            }
            this.logger().debug((Function0 & Serializable)() -> "Job recovery completed, proceeding with startup");
        }
        catch (Throwable t) {
            this.logger().error((Function0 & Serializable)() -> "Job recovery failed", (Function0 & Serializable)() -> t);
        }
    }

    private void startThreads() {
        this.shutdownInProgress().set(false);
        this.threadPool_$eq(this.getThreadPool());
        this.workerThreads().clear();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.maxThreadsCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            WorkerThread workerThread = new WorkerThread(this.jobQueue(), this.compositeWorker());
            this.workerThreads().$plus$eq((Object)workerThread);
            this.threadPool().execute(workerThread);
        });
    }

    private void stop() {
        this.workerThreads().foreach((Function1 & Serializable)worker -> {
            worker.stop();
            return BoxedUnit.UNIT;
        });
        this.workerThreads().clear();
        this.jobQueue().stop();
    }

    private ExecutorService getThreadPool() {
        ExecutorService executors = Executors.newFixedThreadPool(this.maxThreadsCount(), PrefixedThreadFactory$.MODULE$.apply("task-execution", PrefixedThreadFactory$.MODULE$.apply$default$2()));
        if (this.xlrConfig().metrics().enabled()) {
            MetricRegistry registry = XlrMetricRegistry$.MODULE$.metricRegistry();
            MetricFilter filter = MetricFilter.startsWith((String)(this.TASK_EXECUTION() + "."));
            registry.removeMatching(filter);
            return new InstrumentedExecutorService(executors, registry, this.TASK_EXECUTION());
        }
        return executors;
    }

    public void shutdown() {
        if (this.shutdownInProgress().compareAndSet(false, true)) {
            this.logger().info((Function0 & Serializable)() -> "starting shutdown");
            this.stop();
            this.threadPool().shutdown();
            if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                this.logger().warn((Function0 & Serializable)() -> "There are tasks, that did not complete within shutdown grace period, going to interrupt those tasks");
                this.threadPool().shutdownNow();
                if (!this.threadPool().awaitTermination(this.xlrConfig().taskSchedulerGraceShutdownPeriod(), TimeUnit.SECONDS)) {
                    this.logger().error((Function0 & Serializable)() -> "There are tasks, that could not be interrupted, giving up");
                }
            }
            this.jobQueue().cancelIf(x$4 -> true);
            this.shutdownInProgress().set(false);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "skipping shutdown, because shutdown already happened or in progress");
    }

    public void submit(Job job) {
        this.jobQueue().submit(job);
    }

    public void replace(Job job) {
        this.jobQueue().replace(job);
    }

    public void abortJobByTaskId(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> "Aborting scheduled job " + taskId);
        this.requestRunnerToAbortTask(taskId);
        this.jobService().deleteByTaskId(taskId);
        this.jobQueue().cancelIf(x0$1 -> {
            Job job = x0$1;
            if (job instanceof TaskJob) {
                TaskJob taskJob = (TaskJob)job;
                return taskJob.taskId().equals(taskId);
            }
            return false;
        });
    }

    private void requestRunnerToAbortTask(String taskId) {
        this.jobService().findByTaskId(taskId).foreach((Function1 & Serializable)jobRow -> {
            WorkManager.$anonfun$requestRunnerToAbortTask$1(this, taskId, jobRow);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$requestRunnerToAbortTask$1(WorkManager $this, String taskId$2, JobRow jobRow) {
        JobType jobType = jobRow.jobType();
        JobType jobType2 = JobType.CONTAINER_TASK;
        if (!(jobType != null ? !((Object)((Object)jobType)).equals((Object)jobType2) : jobType2 != null)) {
            if (new .colon.colon((Object)JobStatus.RESERVED, (List)new .colon.colon((Object)JobStatus.RUNNING, (List)Nil$.MODULE$)).contains((Object)jobRow.status()) && jobRow.runnerId() != null) {
                Option<? extends JobRunner> option = $this.jobRunnerRepository().findRunner(jobRow.runnerId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JobRunner runner = (JobRunner)some.value();
                    runner.abortJob(jobRow.id());
                } else if (None$.MODULE$.equals(option)) {
                    $this.logger().error((Function0 & Serializable)() -> "Can't find runner [" + jobRow.runnerId() + "]. Can't request runner to abort the job [" + jobRow.id() + "]");
                } else {
                    throw new MatchError(option);
                }
                JobStatus jobStatus = jobRow.status();
                JobStatus jobStatus2 = JobStatus.RESERVED;
                if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus2) : jobStatus2 != null)) {
                    $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                    return;
                }
                return;
            }
            JobStatus jobStatus = jobRow.status();
            JobStatus jobStatus3 = JobStatus.QUEUED;
            if (!(jobStatus != null ? !((Object)((Object)jobStatus)).equals((Object)jobStatus3) : jobStatus3 != null)) {
                $this.releaseActorService().failTaskAsync(taskId$2, "Task was aborted", User.SYSTEM, (Option<DefaultScriptService.BaseScriptTaskResults>)None$.MODULE$);
                return;
            }
            return;
        }
    }

    public WorkManager(XlrConfig xlrConfig, JobQueue jobQueue, CompositeWorker compositeWorker, JobService jobService, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, @Lazy ActorSystemHolder actorSystemHolder) {
        this.xlrConfig = xlrConfig;
        this.jobQueue = jobQueue;
        this.compositeWorker = compositeWorker;
        this.jobService = jobService;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        NodeId.$init$(this);
        JobRecoveryLogic.$init$(this);
        this.shutdownInProgress = new AtomicBoolean(false);
        this.workerThreads = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.TASK_EXECUTION = "taskExecution";
    }
}

