/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.v1.CategoryApi;
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CategoryForm;
import com.xebialabs.xlrelease.api.v1.views.CategoryView;
import com.xebialabs.xlrelease.domain.Category;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CategoryService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u0005\u000b\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C!s!)\u0011\u000e\u0001C!U\")\u0011\u000e\u0001C!s\")Q\u0010\u0001C!}\"9\u0011Q\u0002\u0001\u0005B\u0005=!aD\"bi\u0016<wN]=Ba&LU\u000e\u001d7\u000b\u0005-a\u0011\u0001B5na2T!!\u0004\b\u0002\u0005Y\f$BA\b\u0011\u0003\r\t\u0007/\u001b\u0006\u0003#I\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005M!\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005)\u0012aA2p[\u000e\u00011c\u0001\u0001\u0019AA\u0011\u0011DH\u0007\u00025)\u00111\u0004H\u0001\u0005Y\u0006twMC\u0001\u001e\u0003\u0011Q\u0017M^1\n\u0005}Q\"AB(cU\u0016\u001cG\u000f\u0005\u0002\"E5\tA\"\u0003\u0002$\u0019\tY1)\u0019;fO>\u0014\u00180\u00119j\u0003=\u0019\u0017\r^3h_JL8+\u001a:wS\u000e,\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0011\u0003\u001d\u0019XM\u001d<jG\u0016L!AK\u0014\u0003\u001f\r\u000bG/Z4pef\u001cVM\u001d<jG\u0016\f1\u0002]3s[&\u001c8/[8ogB\u0011Q\u0006M\u0007\u0002])\u0011q\u0006E\u0001\tg\u0016\u001cWO]5us&\u0011\u0011G\f\u0002\u0012!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00025m]\u0002\"!\u000e\u0001\u000e\u0003)AQ\u0001J\u0002A\u0002\u0015BQaK\u0002A\u00021\nAc]3be\u000eD7)\u0019;fO>\u0014\u0018.Z:QC\u001e,G\u0003\u0002\u001eM)r\u00032a\u000f#G\u001b\u0005a$BA\u001f?\u0003\u0019!w.\\1j]*\u0011q\bQ\u0001\u0005I\u0006$\u0018M\u0003\u0002B\u0005\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001D\u0003\ry'oZ\u0005\u0003\u000br\u0012A\u0001U1hKB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nD\u0001\u0006m&,wo]\u0005\u0003\u0017\"\u0013AbQ1uK\u001e|'/\u001f,jK^DQ!\u0014\u0003A\u00029\u000bqbY1uK\u001e|'/\u001f$jYR,'o\u001d\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#2\taAZ5mi\u0016\u0014\u0018BA*Q\u0005=\u0019\u0015\r^3h_JLh)\u001b7uKJ\u001c\b\"B+\u0005\u0001\u00041\u0016\u0001\u00029bO\u0016\u0004\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u00131!\u00138u\u0011\u0015iF\u00011\u0001W\u00039\u0011Xm];miN\u0004VM\u001d)bO\u0016D#\u0001B0\u0011\u0005\u0001<W\"A1\u000b\u0005\t\u001c\u0017AC1o]>$\u0018\r^5p]*\u0011A-Z\u0001\b[\u0016$(/[2t\u0015\t1G#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\tA\u0017MA\u0003US6,G-A\u0006bI\u0012\u001c\u0015\r^3h_JLHCA6q!\tag.D\u0001n\u0015\ti\u0004#\u0003\u0002p[\nA1)\u0019;fO>\u0014\u0018\u0010C\u0003r\u000b\u0001\u0007!/\u0001\u0007dCR,wm\u001c:z\r>\u0014X\u000e\u0005\u0002tm6\tAO\u0003\u0002v\u0019\u0005)am\u001c:ng&\u0011q\u000f\u001e\u0002\r\u0007\u0006$XmZ8ss\u001a{'/\u001c\u0015\u0003\u000b}#\"a\u001b>\t\u000bm4\u0001\u0019A6\u0002\u0011\r\fG/Z4pefD#AB0\u0002\u001dU\u0004H-\u0019;f\u0007\u0006$XmZ8ssR!1n`A\u0005\u0011\u001d\t\ta\u0002a\u0001\u0003\u0007\tQaY5VS\u0012\u00042!GA\u0003\u0013\r\t9A\u0007\u0002\b\u0013:$XmZ3s\u0011\u0015Yx\u00011\u0001lQ\t9q,\u0001\beK2,G/Z\"bi\u0016<wN]=\u0015\t\u0005E\u0011q\u0003\t\u0004/\u0006M\u0011bAA\u000b1\n!QK\\5u\u0011\u001d\t\t\u0001\u0003a\u0001\u0003\u0007A#\u0001C0)\u0007\u0001\ti\u0002\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019\u0003Q\u0001\u000bgR,'/Z8usB,\u0017\u0002BA\u0014\u0003C\u0011!bQ8oiJ|G\u000e\\3s\u0001")
public class CategoryApiImpl
implements CategoryApi {
    private final CategoryService categoryService;
    private final PermissionChecker permissions;

    public String serviceName() {
        return super.serviceName();
    }

    @PublicApiMember
    public List<CategoryView> searchCategories(CategoryFilters categoryFilters, int page, int resultsPerPage) {
        return super.searchCategories(categoryFilters, page, resultsPerPage);
    }

    @Timed
    public Page<CategoryView> searchCategoriesPage(CategoryFilters categoryFilters, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{BoxesRunTime.boxToLong((long)100L)});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.categoryService.findBy(categoryFilters, (Pageable)pageable);
    }

    @Timed
    public Category addCategory(CategoryForm categoryForm) {
        Category category = new Category(categoryForm.getTitle(), categoryForm.isActive());
        return this.addCategory(category);
    }

    @Timed
    public Category addCategory(Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.categoryService.create(category);
    }

    @Timed
    public Category updateCategory(Integer ciUid, Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        category.setCiUid(ciUid);
        return this.categoryService.update(category);
    }

    @Timed
    public void deleteCategory(Integer ciUid) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.categoryService.delete(Predef$.MODULE$.Integer2int(ciUid));
    }

    public CategoryApiImpl(CategoryService categoryService, PermissionChecker permissions) {
        this.categoryService = categoryService;
        this.permissions = permissions;
    }
}

