/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.utils.ResourceUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Locale;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Controller;

@Path(value="/")
@Controller
public class XLReleaseStaticResource {
    @GET
    @NoCache
    @Produces(value={"text/html;charset=UTF-8"})
    public Response redirectToRoot() throws IOException {
        return this.getRoot("index.html");
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.html}")
    @NoCache
    @Produces(value={"text/html;charset=UTF-8"})
    public Response getRoot(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.otf}")
    @Produces(value={"font/opentype"})
    public Response getOtfFont(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.eot}")
    @Produces(value={"application/vnd.ms-fontobject"})
    public Response getEotFont(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : .*\\.woff}")
    @Produces(value={"application/font-woff"})
    public Response getWoffFont(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : .*\\.woff2}")
    @Produces(value={"application/font-woff2"})
    public Response getWoff2Font(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.ttf}")
    @Produces(value={"application/x-font-ttf"})
    public Response getTtfFont(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.svg}")
    @Produces(value={"image/svg+xml"})
    public Response getSvg(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWebOrClasspathRoot(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.png}")
    @Produces(value={"image/png"})
    public Response getPng(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWebOrClasspathRoot(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.gif}")
    @Produces(value={"image/gif"})
    public Response getGif(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWebOrClasspathRoot(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.jpg}")
    @Produces(value={"image/jpg"})
    public Response getJpg(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWebOrClasspathRoot(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.ico}")
    @Produces(value={"image/x-icon"})
    public Response getFavicon(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.map}")
    @Produces(value={"application/json"})
    public Response getJsMap(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.json}")
    @Produces(value={"application/json"})
    public Response getJson(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.js}")
    @Produces(value={"application/javascript"})
    public Response getJs(@PathParam(value="path") String path, @Context HttpServletRequest request) throws IOException {
        if (path.endsWith("locale.js")) {
            return this.getLocaleJs(request);
        }
        return this.streamFromWeb(path);
    }

    @GET
    @Timed
    @Path(value="{path : static/.*\\.css}")
    @Produces(value={"text/css"})
    public Response getCss(@PathParam(value="path") String path) throws IOException {
        return this.streamFromWeb(path);
    }

    private Response streamFromWeb(String path) throws IOException {
        return this.toResponse(ResourceUtils.webResource(this.removeStaticAndVersionPrefix(path)));
    }

    private Response streamFromClasspathRoot(String path) throws IOException {
        return this.toResponse(ResourceUtils.resource(this.removeStaticAndVersionPrefix(path)));
    }

    private Response streamFromWebOrClasspathRoot(String path) throws IOException {
        Response response = this.streamFromWeb(path);
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            response = this.streamFromClasspathRoot(path);
        }
        return response;
    }

    private String removeStaticAndVersionPrefix(String path) {
        return path.replaceAll("^static/[^/]+/", "");
    }

    private Response getLocaleJs(@Context HttpServletRequest request) throws IOException {
        Response response = this.getAngularLocaleResource(request.getLocale());
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            response = this.getAngularLocaleResource(Locale.ENGLISH);
        }
        return response;
    }

    private Response getAngularLocaleResource(Locale locale) throws IOException {
        String localeName = locale.toString();
        String localeNameForAngular = localeName.toLowerCase().replace("_", "-");
        String path = "components/angular-i18n/angular-locale_" + localeNameForAngular + ".js";
        return this.streamFromWeb(path);
    }

    private Response toResponse(Resource resource) throws IOException {
        if (!resource.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)resource.getInputStream()).build();
    }
}

