/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.api.v1.forms.CreatePersonalAccessTokenForm;
import com.xebialabs.xlrelease.api.v1.forms.TokenInfoForm;
import com.xebialabs.xlrelease.api.v1.views.TokenInfoView;
import com.xebialabs.xlrelease.domain.UserToken;
import com.xebialabs.xlrelease.features.PersonalAccessTokenFeature$;
import com.xebialabs.xlrelease.principaldata.PrincipalDataProvider;
import com.xebialabs.xlrelease.principaldata.UserData;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.Users;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.utils.TokenGenerator$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@Path(value="/tokens")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002`\u0001!\t!!\"\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAs\u0001\u0011%\u0011q\u001d\u0005\u0007\u0015\u0002!I!!<\u0003#U\u001bXM\u001d+pW\u0016t'+Z:pkJ\u001cWM\u0003\u0002\u0011#\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0013'\u0005\u0019\u0011\r]5\u000b\u0005Q)\u0012!\u0003=me\u0016dW-Y:f\u0015\t1r#A\u0005yK\nL\u0017\r\\1cg*\t\u0001$A\u0002d_6\u001c\u0001aE\u0002\u00017\u0005\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0007C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0013\u0001C4sSjTH.\u001a3\n\u0005!\u001a#a\u0002'pO\u001eLgnZ\u0001\fa\u0016\u0014X.[:tS>t7\u000f\u0005\u0002,]5\tAF\u0003\u0002.'\u0005A1/Z2ve&$\u00180\u0003\u00020Y\t\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0002\u0019Q|7.\u001a8TKJ4\u0018nY3\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u001a\u0012aB:feZL7-Z\u0005\u0003mM\u0012\u0001#V:feR{7.\u001a8TKJ4\u0018nY3\u0002\u000bU\u001cXM]:\u0011\u0005IJ\u0014B\u0001\u001e4\u0005\u0015)6/\u001a:t\u0003U\u0001(/\u001b8dSB\fG\u000eR1uCB\u0013xN^5eKJ\u0004\"!\u0010!\u000e\u0003yR!aP\n\u0002\u001bA\u0014\u0018N\\2ja\u0006dG-\u0019;b\u0013\t\teHA\u000bQe&t7-\u001b9bY\u0012\u000bG/\u0019)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\u0015!ei\u0012%J!\t)\u0005!D\u0001\u0010\u0011\u0015IS\u00011\u0001+\u0011\u0015\u0001T\u00011\u00012\u0011\u00159T\u00011\u00019\u0011\u0015YT\u00011\u0001=\u000359W\r^+tKJ$vn[3ogR\u0019A*X;\u0011\u000753\u0006,D\u0001O\u0015\ty\u0005+\u0001\u0004e_6\f\u0017N\u001c\u0006\u0003#J\u000bA\u0001Z1uC*\u00111\u000bV\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\tQ+A\u0002pe\u001eL!a\u0016(\u0003\tA\u000bw-\u001a\t\u00033nk\u0011A\u0017\u0006\u0003\u001fNI!\u0001\u0018.\u0003\u0013U\u001bXM\u001d+pW\u0016t\u0007\"\u00020\u0007\u0001\u0004y\u0016\u0001\u00029bO\u0016\u0004\"\u0001\b1\n\u0005\u0005l\"aA%oi\"\"QlY7o!\t!7.D\u0001f\u0015\t1w-\u0001\u0002sg*\u0011\u0001.[\u0001\u0003oNT\u0011A[\u0001\bU\u0006\\\u0017M\u001d;b\u0013\taWM\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-A\u0003wC2,X-I\u0001p\u0003\u0005\u0001\u0004\u0006B/r[R\u0004\"\u0001\u001a:\n\u0005M,'AC)vKJL\b+\u0019:b[\u0006\na\fC\u0003w\r\u0001\u0007q,\u0001\bsKN,H\u000e^:QKJ\u0004\u0016mZ3)\tU\u001cW\u000e_\u0011\u0002s\u0006\u0019\u0011\u0007\r\u0019)\tU\fXn_\u0011\u0002m\"\u0012a! \t\u0003IzL!a`3\u0003\u0007\u001d+E\u000b\u000b\u0004\u0007\u0003\u0007i\u0017\u0011\u0002\t\u0004I\u0006\u0015\u0011bAA\u0004K\n!\u0001+\u0019;iC\t\tY!\u0001\u00040kN,'o\u001d\u0015\u0004\r\u0005=\u0001\u0003BA\t\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u000bC:tw\u000e^1uS>t'\u0002BA\r\u00037\tq!\\3ue&\u001c7OC\u0002\u0002\u001e]\t\u0001bY8eC\"\fG.Z\u0005\u0005\u0003C\t\u0019BA\u0003US6,G-\u0001\u000bhKR$vn[3og\u001a{'/V:fe:\fW.\u001a\u000b\b\u0019\u0006\u001d\u00121JA)\u0011\u001d\tIc\u0002a\u0001\u0003W\t\u0001\"^:fe:\fW.\u001a\t\u0005\u0003[\tYD\u0004\u0003\u00020\u0005]\u0002cAA\u0019;5\u0011\u00111\u0007\u0006\u0004\u0003kI\u0012A\u0002\u001fs_>$h(C\u0002\u0002:u\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003\u007f\u0011aa\u0015;sS:<'bAA\u001d;!:\u0011qEA\"[\u0006%\u0003c\u00013\u0002F%\u0019\u0011qI3\u0003\u0013A\u000bG\u000f\u001b)be\u0006l\u0017EAA\u0015\u0011\u0015qv\u00011\u0001`Q\u0015\tYeY7oQ\u0015\tY%]7u\u0011\u00151x\u00011\u0001`Q\u0015\t\tfY7yQ\u0015\t\t&]7|Q\t9Q\u0010\u000b\u0004\b\u0003\u0007i\u00171L\u0011\u0003\u0003;\n\u0011cL;tKJ\u001cxf_;tKJt\u0017-\\3~\u0003E9WM\\3sCR,Wk]3s)>\\WM\u001c\u000b\u00061\u0006\r\u0014q\r\u0005\b\u0003SA\u0001\u0019AA\u0016Q\u001d\t\u0019'a\u0011n\u0003\u0013Bq!!\u001b\t\u0001\u0004\tY'A\u0007vg\u0016\u0014Hk\\6f]\u001a{'/\u001c\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u00151wN]7t\u0015\r\t)(E\u0001\u0003mFJA!!\u001f\u0002p\ti2I]3bi\u0016\u0004VM]:p]\u0006d\u0017iY2fgN$vn[3o\r>\u0014X\u000eK\u0002\t\u0003{\u00022\u0001ZA@\u0013\r\t\t)\u001a\u0002\u0005!>\u001bF\u000b\u000b\u0004\t\u0003\u0007i\u00171\f\u000b\u00041\u0006\u001d\u0005bBA5\u0013\u0001\u0007\u00111\u000e\u0015\u0004\u0013\u0005u\u0004FB\u0005\u0002\u00045\fI\u0001K\u0002\n\u0003\u001f\tq\u0002Z3mKR,Wk]3s)>\\WM\u001c\u000b\u0005\u0003'\u000bI\nE\u0002\u001d\u0003+K1!a&\u001e\u0005\u0011)f.\u001b;\t\u000f\u0005m%\u00021\u0001\u0002\u001e\u0006)1-[+jIB!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016\u0001\u00027b]\u001eT!!a*\u0002\t)\fg/Y\u0005\u0005\u0003W\u000b\tKA\u0004J]R,w-\u001a:)\u000f\u0005e\u00151I7\u00020\u0006\u0012\u00111\u0014\u0015\u0004\u0015\u0005M\u0006c\u00013\u00026&\u0019\u0011qW3\u0003\r\u0011+E*\u0012+FQ\u0019Q\u00111A7\u0002<\u0006\u0012\u0011QX\u0001\u000f_U\u001cXM]:0w\u000eLW+\u001b3~Q\rQ\u0011qB\u0001\ni>\\WM\\%oM>$B!!2\u0002RB!\u0011qYAg\u001b\t\tIM\u0003\u0003\u0002L\u0006M\u0014!\u0002<jK^\u001c\u0018\u0002BAh\u0003\u0013\u0014Q\u0002V8lK:LeNZ8WS\u0016<\bbBAj\u0017\u0001\u0007\u0011Q[\u0001\u0005M>\u0014X\u000e\u0005\u0003\u0002n\u0005]\u0017\u0002BAm\u0003_\u0012Q\u0002V8lK:LeNZ8G_Jl\u0007fA\u0006\u0002~!21\"a\u0001n\u0003?\f#!!9\u0002\u0017=\"xn[3o?&tgm\u001c\u0015\u0004\u0017\u0005=\u0011!\t<bY&$\u0017\r^3B]\u0012tuN]7bY&TX-V:feR{7.\u001a8G_JlGCBAJ\u0003S\fY\u000fC\u0004\u0002*1\u0001\r!a\u000b\t\u000f\u0005%D\u00021\u0001\u0002lQ9A*a<\u0002r\u0006M\bbBA\u0015\u001b\u0001\u0007\u00111\u0006\u0005\u0006=6\u0001\ra\u0018\u0005\u0006m6\u0001\ra\u0018\u0015\u0007\u0001\u0005\rQ.a>\"\u0005\u0005e\u0018aB\u0018u_.,gn\u001d\u0015\u0007\u0001\u0005uXNa\u0001\u0011\u0007\u0011\fy0C\u0002\u0003\u0002\u0015\u0014\u0001bQ8ogVlWm\u001d\u0017\u0003\u0005\u000b\t#Aa\u0002\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007F\u0002\u0001\u0003\f5\u0014\t\u0002E\u0002e\u0005\u001bI1Aa\u0004f\u0005!\u0001&o\u001c3vG\u0016\u001cHF\u0001B\u0003Q\r\u0001!Q\u0003\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)\u0019!1\u0004*\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003 \te!AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class UserTokenResource
implements Logging {
    private final PermissionChecker permissions;
    private final UserTokenService tokenService;
    private final Users users;
    private final PrincipalDataProvider principalDataProvider;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        UserTokenResource userTokenResource = this;
        synchronized (userTokenResource) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @GET
    @Path(value="/users")
    @Timed
    public Page<UserToken> getUserTokens(@DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        return this.getUserTokens(User.AUTHENTICATED_USER.getName(), page, resultsPerPage);
    }

    @GET
    @Path(value="/users/{username}")
    public Page<UserToken> getTokensForUsername(@PathParam(value="username") String username, @DefaultValue(value="0") @QueryParam(value="page") int page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") int resultsPerPage) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.getUserTokens(username, page, resultsPerPage);
    }

    @POST
    @Path(value="/users/{username}")
    public UserToken generateUserToken(@PathParam(value="username") String username, CreatePersonalAccessTokenForm userTokenForm) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Checks.checkArgument((boolean)this.users.userExistsInRepository(username), (String)"Personal access tokens generated by administrator are only supported for internal users", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @POST
    @Path(value="/users")
    @Timed
    public UserToken generateUserToken(CreatePersonalAccessTokenForm userTokenForm) {
        String username = User.AUTHENTICATED_USER.getName();
        UserData userData = this.principalDataProvider.getUserData(username);
        boolean personalAccessTokenSupported = PersonalAccessTokenFeature$.MODULE$.enabled() || this.users.userExistsInRepository(username) || userData.isFound();
        Checks.checkArgument((boolean)personalAccessTokenSupported, (String)"Personal access tokens are only supported for internal users and external users authenticated via LDAP, Atlassian Crowd", (Object[])new Object[0]);
        this.validateAndNormalizeUserTokenForm(username, userTokenForm);
        return this.tokenService.createUserToken(username, userTokenForm.getTokenNote(), userTokenForm.getExpiryDate());
    }

    @DELETE
    @Path(value="/users/{ciUid}")
    @Timed
    public void deleteUserToken(@PathParam(value="ciUid") Integer ciUid) {
        Option<UserToken> userToken = this.tokenService.findByCiUid(ciUid);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                this.tokenService.deleteUserToken(token);
                return;
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token ciUid[" + ciUid + "] is not valid");
        }
        throw new MatchError(option);
    }

    @POST
    @Path(value="/token_info")
    @Timed
    public TokenInfoView tokenInfo(TokenInfoForm form) {
        String hash = TokenGenerator$.MODULE$.hash(form.getToken());
        Option<UserToken> userToken = this.tokenService.findByUserToken(hash);
        Option<UserToken> option = userToken;
        if (option instanceof Some) {
            Some some = (Some)option;
            UserToken token = (UserToken)some.value();
            if (token.username().equalsIgnoreCase(User.AUTHENTICATED_USER.getName()) || this.permissions.isCurrentUserAdmin()) {
                return new TokenInfoView(token.username(), token.expiryDate());
            }
            throw new PermissionDeniedException("You don't have the permissions required to delete this personal access token.");
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException("Personal access token is not valid");
        }
        throw new MatchError(option);
    }

    private void validateAndNormalizeUserTokenForm(String username, CreatePersonalAccessTokenForm userTokenForm) {
        Checks.checkArgument((boolean)Strings.isNotBlank((String)userTokenForm.getTokenNote()), (String)"Note can't be blank", (Object[])new Object[0]);
        Checks.checkArgument((userTokenForm.getExpiryDate() == null || userTokenForm.getExpiryDate().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Expiry date is not valid", (Object[])new Object[0]);
        String tokenNote = userTokenForm.getTokenNote().trim();
        userTokenForm.setTokenNote(tokenNote);
        Checks.checkArgument((tokenNote.length() < 256 ? 1 : 0) != 0, (String)"Note must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!this.tokenService.userTokenExists(username, tokenNote) ? 1 : 0) != 0, (String)"Note has already been taken", (Object[])new Object[0]);
    }

    private Page<UserToken> getUserTokens(String username, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.tokenService.find(username, (Pageable)pageable);
    }

    public UserTokenResource(PermissionChecker permissions, UserTokenService tokenService, Users users, PrincipalDataProvider principalDataProvider) {
        this.permissions = permissions;
        this.tokenService = tokenService;
        this.users = users;
        this.principalDataProvider = principalDataProvider;
        Logging.$init$((Logging)this);
    }
}

