/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.ExportHook;
import com.xebialabs.xlrelease.domain.variables.ReferencedType;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.IdType;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ConfigurationAutoconfigService;
import com.xebialabs.xlrelease.service.SharedConfigurationService;
import com.xebialabs.xlrelease.service.SharedConfigurationStatusService;
import com.xebialabs.xlrelease.utils.PasswordVerificationUtils;
import com.xebialabs.xlrelease.variable.DefaultCiValueProvider;
import com.xebialabs.xlrelease.views.AutoconfigResponse;
import com.xebialabs.xlrelease.views.ConfigurationView;
import com.xebialabs.xlrelease.views.SharedConfigurationStatusResponse;
import com.xebialabs.xlrelease.views.converters.ConfigurationItemViewConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.ext.Providers;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SharedConfigurationResource {
    private SharedConfigurationService sharedConfigurationService;
    private PermissionChecker permissions;
    private ConfigurationItemViewConverter configurationViewConverter;
    private SharedConfigurationStatusService sharedConfigurationStatusService;
    private ConfigurationAutoconfigService configurationAutoconfigService;

    @Autowired
    public SharedConfigurationResource(SharedConfigurationService sharedConfigurationService, PermissionChecker permissions, ConfigurationItemViewConverter configurationViewConverter, SharedConfigurationStatusService sharedConfigurationStatusService, ConfigurationAutoconfigService configurationAutoconfigService) {
        this.sharedConfigurationService = sharedConfigurationService;
        this.permissions = permissions;
        this.sharedConfigurationStatusService = sharedConfigurationStatusService;
        this.configurationViewConverter = configurationViewConverter;
        this.configurationAutoconfigService = configurationAutoconfigService;
    }

    @GET
    @Timed
    @Path(value="descriptors")
    public List<Descriptor> getDescriptors() {
        return this.sharedConfigurationService.findAllConfigurationDescriptors();
    }

    @GET
    public List<ConfigurationView> getInstances(@QueryParam(value="anonymized") boolean anonymized) {
        if (anonymized) {
            return this.sharedConfigurationService.findAll().stream().map(this.configurationViewConverter::toAnonymizedView).collect(Collectors.toList());
        }
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.sharedConfigurationService.findAll().stream().map(this.configurationViewConverter::toView).collect(Collectors.toList());
    }

    @POST
    public ConfigurationView addInstance(ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.sharedConfigurationService.create(this.configurationViewConverter.fromView(configurationView));
        return this.configurationViewConverter.toView(configuration);
    }

    @GET
    @Timed
    @Path(value="{configurationInstanceId:((?!descriptors).)*}")
    public ConfigurationView getInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.sharedConfigurationService.findById(configurationInstanceId);
        return this.configurationViewConverter.toView(configuration);
    }

    @PUT
    @Timed
    @Path(value="{configurationInstanceId:((?!descriptors).)*}")
    public ConfigurationView updateInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId, ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.sharedConfigurationService.update(configurationInstanceId, this.configurationViewConverter.fromView(configurationView));
        return this.configurationViewConverter.toView(configuration);
    }

    @DELETE
    @Timed
    @Path(value="{configurationInstanceId}")
    public void deleteInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.sharedConfigurationService.delete(configurationInstanceId);
    }

    @Timed
    @Path(value="status")
    @POST
    public SharedConfigurationStatusResponse checkConnection(ConfigurationView configurationView) {
        Configuration configuration = this.getConfiguration(configurationView);
        SharedConfigurationStatusResponse response = this.sharedConfigurationStatusService.checkStatus(configuration);
        this.fixRestEasyProviders();
        return response;
    }

    @Timed
    @Path(value="hasScript")
    @POST
    public Boolean hasScript(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        return !(configuration instanceof ExportHook) && this.sharedConfigurationStatusService.hasScript(configuration);
    }

    @Timed
    @Path(value="autoconfigure")
    @POST
    public AutoconfigResponse autoconfigure(ConfigurationView configurationView) {
        Configuration configuration = this.getConfiguration(configurationView);
        AutoconfigResponse response = this.configurationAutoconfigService.autoconfigure(configuration);
        this.fixRestEasyProviders();
        return response;
    }

    @Timed
    @Path(value="isAutoconfigure")
    @POST
    public Boolean isAutoconfigure(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        return this.configurationAutoconfigService.isAutoconfigure(configuration);
    }

    @Timed
    @Path(value="referenceVariable/types")
    @GET
    public List<ReferencedType> getReferenceVariableTypes() {
        return DefaultCiValueProvider.getAllSupportedTypes();
    }

    private Configuration getConfiguration(ConfigurationView configurationView) {
        Configuration configuration = this.configurationViewConverter.fromView(configurationView);
        String id = configuration.getId();
        Optional<ConfigurationItem> original = id == null ? Optional.empty() : Optional.of(this.sharedConfigurationService.findById(id));
        PasswordVerificationUtils.replacePasswordPropertiesInCiIfNeededJava(original, (ConfigurationItem)configuration);
        return configuration;
    }

    private void fixRestEasyProviders() {
        if (ResteasyContext.getContextDataMap().isEmpty()) {
            ResteasyContext.getContextDataMap().put(Providers.class, ResteasyProviderFactory.getInstance());
        }
    }
}

