package com.xebialabs.xlrelease.security

import com.codahale.metrics.annotation.Timed
import grizzled.slf4j.Logging

class DefaultUserGroupService(userGroupRepository: UserGroupRepository)
  extends UserGroupService with Logging {

  @Timed
  override def findGroupsForUser(username: String): Set[String] = {
    userGroupRepository.findGroupsForUser(username)
  }

  @Timed
  override def createGroup(groupName: String): Unit = {
    userGroupRepository.createGroup(groupName)
  }

  @Timed
  override def deleteGroup(groupName: String): Unit = {
    userGroupRepository.deleteGroup(groupName)
  }

  @Timed
  override def addUserToGroup(username: String, groupName: String): Unit = {
    userGroupRepository.addUserToGroup(username, groupName)
  }

  @Timed
  override def removeUserFromGroup(username: String, groupName: String): Unit = {
    userGroupRepository.removeUserFromGroup(username, groupName)
  }

  @Timed
  override def updateGroupsMembershipForUser(username: String, groupNames: Set[String]): Unit = {
    userGroupRepository.updateGroupsMembershipForUser(username, groupNames)
  }
}
