/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.server.jetty;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.plumbing.CSPFilter;
import com.xebialabs.deployit.plumbing.IgnoreUrlFilter;
import com.xebialabs.deployit.plumbing.LogbackFilter;
import com.xebialabs.deployit.plumbing.MaintenanceModeAccessControlFilter;
import com.xebialabs.deployit.plumbing.ModifiedResourceFilter;
import com.xebialabs.deployit.plumbing.MultipartFilter;
import com.xebialabs.deployit.plumbing.RequestLocal;
import com.xebialabs.deployit.plumbing.SlowdownFilter;
import com.xebialabs.deployit.plumbing.UrlRedirectRewriteFilter;
import com.xebialabs.deployit.plumbing.VersionEnforcerFilter;
import com.xebialabs.deployit.plumbing.XLRequestLogImpl;
import com.xebialabs.deployit.plumbing.XssSecurityHeadersFilter;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServlet;
import com.xebialabs.xlplatform.endpoints.servlet.PekkoStreamServletInitializer;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.metrics.XlrMetricRegistry$;
import com.xebialabs.xlrelease.security.HttpSessionListenerWithTimeout;
import com.xebialabs.xlrelease.server.jetty.SSLConstants$;
import io.dropwizard.metrics.jetty11.InstrumentedHandler;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.SessionTrackingMode;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.springframework.boot.web.embedded.jetty.JettyServletWebServerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\u000f\u001f\u0001%B\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005w!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003E\u0011!Y\u0005A!b\u0001\n\u0003a\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u000bQ\u0003A\u0011A+\t\u000bm\u0003A\u0011\t/\t\u000b\r\u0004A\u0011\u000b3\t\u000bM\u0004A\u0011\u0002;\t\u000bY\u0004A\u0011B<\t\u000be\u0004A\u0011\u0002>\t\u000bq\u0004A\u0011B?\t\r}\u0004A\u0011BA\u0001\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAq!a\u0003\u0001\t\u0013\ti\u0001C\u0004\u0002\u0012\u0001!I!a\u0005\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u0012\u0001\u0011%\u0011Q\u0005\u0005\b\u0003S\u0001A\u0011BA\u0016\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003w\u0002A\u0011BA?\u0005\r\u0012V\r\\3bg\u0016TU\r\u001e;z'\u0016\u0014h\u000f\\3u/\u0016\u00147+\u001a:wKJ4\u0015m\u0019;pefT!a\b\u0011\u0002\u000b),G\u000f^=\u000b\u0005\u0005\u0012\u0013AB:feZ,'O\u0003\u0002$I\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003K\u0019\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u001d\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\u0005-:T\"\u0001\u0017\u000b\u0005}i#B\u0001\u00180\u0003!)WNY3eI\u0016$'B\u0001\u00192\u0003\r9XM\u0019\u0006\u0003eM\nAAY8pi*\u0011A'N\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta'A\u0002pe\u001eL!\u0001\u000f\u0017\u00039)+G\u000f^=TKJ4H.\u001a;XK\n\u001cVM\u001d<fe\u001a\u000b7\r^8ss\u0006\u00192/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\t1\b\u0005\u0002=\u007f5\tQH\u0003\u0002?I\u0005AA-\u001a9m_fLG/\u0003\u0002A{\t\u00192+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006!2/\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002\n\u0011\u0002\u001f7s\u0007>tg-[4\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0012\u0002\r\r|gNZ5h\u0013\tIeIA\u0005YYJ\u001cuN\u001c4jO\u0006Q\u0001\u0010\u001c:D_:4\u0017n\u001a\u0011\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM]\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\u0011\u0001+P\u0001\tg\u0016\u001cWO]5us&\u0011!k\u0014\u0002\u0013!\u0016\u0014X.[:tS>tWI\u001c4pe\u000e,'/A\nqKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005-bK&\f\u0005\u0002X\u00015\ta\u0004C\u0003:\u000f\u0001\u00071\bC\u0003C\u000f\u0001\u0007A\tC\u0003L\u000f\u0001\u0007Q*\u0001\rjgJ+w-[:uKJ$UMZ1vYR\u001cVM\u001d<mKR$\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0002A\u0006)1oY1mC&\u0011!m\u0018\u0002\b\u0005>|G.Z1o\u0003a\u0001xn\u001d;Qe>\u001cWm]:XK\n\f\u0005\u000f]\"p]R,\u0007\u0010\u001e\u000b\u0003K\"\u0004\"A\u00184\n\u0005\u001d|&\u0001B+oSRDQ![\u0005A\u0002)\f1bY8oi\u0016DHOU8piB\u00111.]\u0007\u0002Y*\u0011QN\\\u0001\u0007o\u0016\u0014\u0017\r\u001d9\u000b\u0005}y'B\u000196\u0003\u001d)7\r\\5qg\u0016L!A\u001d7\u0003\u001b]+'-\u00119q\u0007>tG/\u001a=u\u0003)\u0019X\r^;q\u0015\u0016$H/\u001f\u000b\u0003KVDQ!\u001b\u0006A\u0002)\f!c]3ukBdun\u001a2bG.4\u0015\u000e\u001c;feR\u0011Q\r\u001f\u0005\u0006S.\u0001\rA[\u0001\fg\u0016$X\u000f]*qe&tw\r\u0006\u0002fw\")\u0011\u000e\u0004a\u0001U\u0006q1/\u001a;va\u0006\u001b7-Z:t\u0019><GCA3\u007f\u0011\u0015IW\u00021\u0001k\u0003=\u0019X\r^;q\u0007>\u00148OR5mi\u0016\u0014HcA3\u0002\u0004!)\u0011N\u0004a\u0001U\u0006i2/\u001a;vab\u001b8oU3dkJLG/\u001f%fC\u0012,'o\u001d$jYR,'\u000fF\u0002f\u0003\u0013AQ![\bA\u0002)\fab]3ukB,&\u000f\u001c$jYR,'\u000fF\u0002f\u0003\u001fAQ!\u001b\tA\u0002)\f1c]3ukB\u001cFn\\<e_^tg)\u001b7uKJ$2!ZA\u000b\u0011\u0015I\u0017\u00031\u0001k\u00039\u0019X\r^;q\u0007N\u0003f)\u001b7uKJ$2!ZA\u000e\u0011\u0015I'\u00031\u0001k\u0003E\u0019X\r^;q\u000bb$XM\\:j_:\f\u0005/\u001b\u000b\u0004K\u0006\u0005\u0002\"B5\u0014\u0001\u0004Q\u0017\u0001F:fiV\u0004h+\u001a:tS>tWI\u001c4pe\u000e,'\u000fF\u0002f\u0003OAQ!\u001b\u000bA\u0002)\f\u0011c]3ukB\u0014V-];fgRdunY1m)\r)\u0017Q\u0006\u0005\u0006SV\u0001\rA[\u0001\u0015K:\f'\r\\3SKN|WO]2fg\u000e\u000b7\r[3\u0015\u0007\u0015\f\u0019\u0004C\u0003j-\u0001\u0007!.A\tf]\u0006\u0014G.Z${SBD\u0015M\u001c3mKJ$2!ZA\u001d\u0011\u0015Iw\u00031\u0001k\u0003EqWm^*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002J5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005\u0005r\u0017\u0002BA&\u0003\u0007\u0012abU3tg&|g\u000eS1oI2,'/A\rf]\u0006\u0014G.Z%ogR\u0014X/\\3oi\u0016$\u0007*\u00198eY\u0016\u0014HcA3\u0002R!)\u0011.\u0007a\u0001U\u0006\t2/\u001a;Qe>\u0004XM\u001d;z\u0013\u001atU\u000f\u001c7\u0015\u000b\u0015\f9&!\u001d\t\u000f\u0005e#\u00041\u0001\u0002\\\u0005\u00191.Z=\u0011\t\u0005u\u00131\u000e\b\u0005\u0003?\n9\u0007E\u0002\u0002b}k!!a\u0019\u000b\u0007\u0005\u0015\u0004&\u0001\u0004=e>|GOP\u0005\u0004\u0003Sz\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002n\u0005=$AB*ue&twMC\u0002\u0002j}Cq!a\u001d\u001b\u0001\u0004\tY&A\u0003wC2,X-A\u0014tKR,\b/T1j]R,g.\u00198dK6{G-Z!dG\u0016\u001c8oQ8oiJ|GNR5mi\u0016\u0014HcA3\u0002z!)\u0011n\u0007a\u0001U\u0006!2/\u001a;va6+H\u000e^5qCJ$h)\u001b7uKJ$2!ZA@\u0011\u0015IG\u00041\u0001k\u0001")
public class ReleaseJettyServletWebServerFactory
extends JettyServletWebServerFactory {
    private final ServerConfiguration serverConfiguration;
    private final XlrConfig xlrConfig;
    private final PermissionEnforcer permissionEnforcer;

    public ServerConfiguration serverConfiguration() {
        return this.serverConfiguration;
    }

    public XlrConfig xlrConfig() {
        return this.xlrConfig;
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public boolean isRegisterDefaultServlet() {
        return false;
    }

    public void postProcessWebAppContext(WebAppContext contextRoot) {
        this.setupJetty(contextRoot);
        this.setupLogbackFilter(contextRoot);
        this.setupSpring(contextRoot);
        this.setupAccessLog(contextRoot);
        this.setupCorsFilter(contextRoot);
        this.setupXssSecurityHeadersFilter(contextRoot);
        this.setupUrlFilter(contextRoot);
        this.setupCSPFilter(contextRoot);
        this.setupSlowdownFilter(contextRoot);
        this.setupExtensionApi(contextRoot);
        this.setupVersionEnforcer(contextRoot);
        this.setupRequestLocal(contextRoot);
        this.setupMaintenanceModeAccessControlFilter(contextRoot);
        this.setupMultipartFilter(contextRoot);
    }

    private void setupJetty(WebAppContext contextRoot) {
        contextRoot.setSessionHandler(this.newSessionHandler());
        contextRoot.setSecurityHandler((SecurityHandler)new ConstraintSecurityHandler());
        if (this.xlrConfig().metrics().enabled()) {
            this.enableInstrumentedHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_gzip_enabled()) {
            this.enableGzipHandler(contextRoot);
        }
        if (this.xlrConfig().server_http_cache_enabled() && Environment.isProduction()) {
            this.enableResourcesCache(contextRoot);
            return;
        }
    }

    private void setupLogbackFilter(WebAppContext contextRoot) {
        contextRoot.addFilter(LogbackFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void setupSpring(WebAppContext contextRoot) {
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PROPERTY(), this.serverConfiguration().getKeyStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.KEYSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getKeyStorePassword());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PROPERTY(), this.serverConfiguration().getTrustStorePath());
        this.setPropertyIfNull(SSLConstants$.MODULE$.TRUSTSTORE_PASSWORD_PROPERTY(), this.serverConfiguration().getTrustStorePassword());
        contextRoot.setInitParameter("contextClass", XmlWebApplicationContext.class.getName());
        contextRoot.addFilter(UrlRedirectRewriteFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        filter.setAsyncSupported(true);
        contextRoot.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST));
        FilterHolder encodingFilter = new FilterHolder(CharacterEncodingFilter.class);
        encodingFilter.setName("encodingFilter");
        encodingFilter.setInitParameter("encoding", "UTF-8");
        encodingFilter.setInitParameter("forceEncoding", "true");
        encodingFilter.setAsyncSupported(true);
        contextRoot.addFilter(encodingFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.setResourceBase(".");
        if (!this.xlrConfig().server_session_storage_enabled()) {
            contextRoot.addEventListener((EventListener)((Object)new HttpSessionListenerWithTimeout()));
            return;
        }
    }

    private void setupAccessLog(WebAppContext contextRoot) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        XLRequestLogImpl requestLogger = new XLRequestLogImpl("conf/logback-access.xml");
        requestLogHandler.setRequestLog((RequestLog)requestLogger);
        contextRoot.insertHandler((HandlerWrapper)requestLogHandler);
    }

    private void setupCorsFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().api_corsEnabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CrossOriginFilter());
            holder.setInitParameter("Access-Control-Allow-Origin", "*");
            holder.setInitParameter("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE, PUT");
            holder.setInitParameter("Access-Control-Allow-Headers", "3600");
            holder.setInitParameter("Access-Control-Max-Age", "x-requested-with, accept, origin, content-type");
            holder.setAsyncSupported(true);
            contextRoot.addFilter(holder, "/api/v1/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupXssSecurityHeadersFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new XssSecurityHeadersFilter());
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupUrlFilter(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new IgnoreUrlFilter());
        contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    private void setupSlowdownFilter(WebAppContext contextRoot) {
        if (Environment.isDevelopment()) {
            long slowDownInMs = this.xlrConfig().development_restSlowDownDelay().toMillis();
            if (slowDownInMs > 0L) {
                this.logger.warn((Object)("Configuring slow down filter with " + slowDownInMs + " milliseconds."));
                FilterHolder slowdownFilter = new FilterHolder(SlowdownFilter.class);
                slowdownFilter.setInitParameter("ms", String.valueOf(slowDownInMs));
                slowdownFilter.setAsyncSupported(true);
                contextRoot.addFilter(slowdownFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
                return;
            }
            return;
        }
    }

    private void setupCSPFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().server_http_csp_enabled()) {
            FilterHolder holder = new FilterHolder((Filter)new CSPFilter());
            holder.setAsyncSupported(true);
            holder.setInitParameter("policyDirectives", this.xlrConfig().server_http_csp_policyDirectives());
            contextRoot.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupExtensionApi(WebAppContext contextRoot) {
        String apiExtensionRootPath = this.xlrConfig().serverExtension_rootPath();
        String apiExtensionContext = String.format("%s/*", apiExtensionRootPath);
        ServletHolder extensionApiServletHolder = new ServletHolder(PekkoStreamServlet.class);
        extensionApiServletHolder.setDisplayName("ExtensionApiConnectorServlet");
        extensionApiServletHolder.setAsyncSupported(true);
        contextRoot.addEventListener((EventListener)new PekkoStreamServletInitializer());
        contextRoot.addServlet(extensionApiServletHolder, apiExtensionContext);
    }

    private void setupVersionEnforcer(WebAppContext contextRoot) {
        if (!Environment.isDevelopment()) {
            contextRoot.addFilter(VersionEnforcerFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
            return;
        }
    }

    private void setupRequestLocal(WebAppContext contextRoot) {
        contextRoot.addFilter(RequestLocal.class, "*", EnumSet.of(DispatcherType.REQUEST)).setAsyncSupported(true);
    }

    private void enableResourcesCache(WebAppContext contextRoot) {
        FilterHolder holder = new FilterHolder((Filter)new ModifiedResourceFilter());
        holder.setInitParameter("startTimestamp", String.valueOf(System.currentTimeMillis()));
        holder.setAsyncSupported(true);
        contextRoot.addFilter(holder, "/static/*", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-module.js", EnumSet.of(DispatcherType.REQUEST));
        contextRoot.addFilter(holder, "/ui-extensions/xlrelease-plugins.js", EnumSet.of(DispatcherType.REQUEST));
    }

    private void enableGzipHandler(WebAppContext contextRoot) {
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setSyncFlush(true);
        gzipHandler.setIncludedMethods(new String[]{"GET", "POST", "PUT"});
        gzipHandler.setMinGzipSize(this.xlrConfig().server_http_gzip_minSize().intValue());
        gzipHandler.setExcludedPaths((String[])CollectionConverters$.MODULE$.ListHasAsScala(this.xlrConfig().server_http_gzip_excludedPaths()).asScala().toSeq().toArray(ClassTag$.MODULE$.apply(String.class)));
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, this.xlrConfig().server_http_gzip_compression(), true));
        contextRoot.insertHandler((HandlerWrapper)gzipHandler);
    }

    private SessionHandler newSessionHandler() {
        SessionHandler sessionHandler = new SessionHandler();
        sessionHandler.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
        sessionHandler.setHttpOnly(true);
        if (!this.serverConfiguration().isSsl()) {
            this.logger.debug((Object)("Setting up Secure Cookie Enabled to - " + this.serverConfiguration().isSecureCookieEnabled()));
            sessionHandler.getSessionCookieConfig().setSecure(this.serverConfiguration().isSecureCookieEnabled());
        }
        sessionHandler.setSameSite(HttpCookie.SameSite.valueOf((String)this.xlrConfig().server_http_cookie_sameSite().getAttributeValue().toUpperCase()));
        return sessionHandler;
    }

    private void enableInstrumentedHandler(WebAppContext contextRoot) {
        InstrumentedHandler handler = new InstrumentedHandler(XlrMetricRegistry$.MODULE$.metricRegistry());
        contextRoot.insertHandler((HandlerWrapper)handler);
    }

    private void setPropertyIfNull(String key, String value) {
        if (value != null) {
            if (System.getProperty(key) == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Setting system property - " + key));
                }
                System.setProperty(key, value);
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not overriding already specified system property - " + key));
                return;
            }
            return;
        }
    }

    private void setupMaintenanceModeAccessControlFilter(WebAppContext contextRoot) {
        if (this.xlrConfig().maintenanceModeEnabled()) {
            boolean restrictApiAccess = this.xlrConfig().maintenanceModeRestrictApiAccess();
            FilterHolder filterHolder = new FilterHolder((Filter)new MaintenanceModeAccessControlFilter(this.permissionEnforcer(), restrictApiAccess));
            contextRoot.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            return;
        }
    }

    private void setupMultipartFilter(WebAppContext contextRoot) {
        FilterHolder multipartFilter = new FilterHolder(MultipartFilter.class);
        multipartFilter.setName("multipartFilter");
        contextRoot.addFilter(multipartFilter, "/*", EnumSet.of(DispatcherType.REQUEST));
    }

    public ReleaseJettyServletWebServerFactory(ServerConfiguration serverConfiguration, XlrConfig xlrConfig, PermissionEnforcer permissionEnforcer) {
        this.serverConfiguration = serverConfiguration;
        this.xlrConfig = xlrConfig;
        this.permissionEnforcer = permissionEnforcer;
    }
}

