/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseInformation;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.security.PermissionChecker$;
import com.xebialabs.xlrelease.security.PermissionContext;
import com.xebialabs.xlrelease.security.PermissionContextEnv;
import com.xebialabs.xlrelease.security.ReleasePermissionContext$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005f!\u0002(P\u0001>;\u0006\u0002\u0003>\u0001\u0005+\u0007I\u0011A>\t\u0011}\u0004!\u0011#Q\u0001\nqDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f!A\u0011q\b\u0001!\u0002\u0013\ti\u0001C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011q\f\u0001!\u0002\u0013\t)%\u0002\u0004\u0002b\u0001\u0001\u0011Q\u0004\u0005\n\u0003G\u0002!\u0019!C\u0005\u0003KB\u0001\"!\u001f\u0001A\u0003%\u0011q\r\u0005\b\u0003w\u0002A\u0011BA?\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!!#\u0001\t\u0013\tY\t\u0003\u0006\u0002\u0012\u0002A)\u0019!C\u0001\u0003'Cq!!&\u0001\t\u0003\n9\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003s\u0003A\u0011IA^\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!!2\u0001\t\u0003\n9\rC\u0004\u0002L\u0002!I!!4\t\u000f\u0005E\u0007\u0001\"\u0003\u0002T\"9\u0011q\u001b\u0001\u0005\n\u0005e\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\t\u0003O\u0004A\u0011A(\u0002j\"A\u0011q\u001e\u0001\u0005\u0002=\u000b\t\u0010\u0003\u0005\u0002z\u0002!\taTA~\u0011\u001d\u00119\u0002\u0001C\u0005\u00053AqAa\u0006\u0001\t\u0013\u0011i\u0002C\u0004\u0003\"\u0001!\tEa\t\t\u000f\t\u001d\u0002\u0001\"\u0003\u0003*!9!Q\u0006\u0001\u0005B\t=\u0002b\u0002B\u001a\u0001\u0011\u0005#Q\u0007\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0011!\u00119\u0006\u0001C\u0001\u001f\ne\u0003b\u0002B/\u0001\u0011\u0005#q\f\u0005\b\u0005G\u0002A\u0011\u0002B3\u0011\u001d\u0011I\u0007\u0001C!\u0005WBqAa\u001c\u0001\t\u0003\u0012\t\bC\u0004\u0003v\u0001!\tEa\u001e\t\u000f\tm\u0004\u0001\"\u0011\u0003~!9!Q\u0011\u0001\u0005B\t\u001d\u0005b\u0002BC\u0001\u0011%!1\u0014\u0005\b\u0005C\u0003A\u0011\u0002BR\u0011\u001d\u0011\u0019\f\u0001C!\u0005kCqA!/\u0001\t\u0003\u0012Y\f\u0003\u0005\u0003@\u0002!\ta\u0014Ba\u0011!\u0011)\r\u0001C\u0001\u001f\n\u001d\u0007b\u0002Bf\u0001\u0011%!Q\u001a\u0005\t\u0005#\u0004A\u0011A(\u0003T\"9!q\u001b\u0001\u0005B\te\u0007b\u0002Bl\u0001\u0011%!Q\u001c\u0005\b\u0005C\u0004A\u0011\tBr\u0011\u001d\u00119\u000f\u0001C!\u0005SD\u0001B!<\u0001\t\u0003y%q\u001e\u0005\b\u0005g\u0004A\u0011\tB{\u0011\u001d\u0011I\u0010\u0001C!\u0005wD\u0011Ba@\u0001\u0003\u0003%\ta!\u0001\t\u0013\r\u0015\u0001!%A\u0005\u0002\r\u001d\u0001\"CB\r\u0001\u0005\u0005I\u0011IB\u000e\u0011%\u0019Y\u0003AA\u0001\n\u0003\u0019i\u0003C\u0005\u00046\u0001\t\t\u0011\"\u0001\u00048!I11\t\u0001\u0002\u0002\u0013\u00053Q\t\u0005\n\u0007\u001f\u0002\u0011\u0011!C\u0001\u0007#B\u0011b!\u0016\u0001\u0003\u0003%\tea\u0016\t\u0013\rm\u0003!!A\u0005B\ru\u0003\"CB0\u0001\u0005\u0005I\u0011IB1\u0011%\u0019\u0019\u0007AA\u0001\n\u0003\u001a)g\u0002\u0006\u0004j=\u000b\t\u0011#\u0001P\u0007W2\u0011BT(\u0002\u0002#\u0005qj!\u001c\t\u000f\u0005\u0005\u0001\n\"\u0001\u0004\u0006\"I1q\f%\u0002\u0002\u0013\u00153\u0011\r\u0005\n\u0007\u000fC\u0015\u0011!CA\u0007\u0013C\u0011b!$I\u0003\u0003%\tia$\t\u0013\r]\u0005*!A\u0005\n\re%\u0001\u0007*fY\u0016\f7/\u001a)fe6L7o]5p]\u000e{g\u000e^3yi*\u0011\u0001+U\u0001\tg\u0016\u001cWO]5us*\u0011!kU\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001V+\u0002\u0013a,'-[1mC\n\u001c(\"\u0001,\u0002\u0007\r|Wn\u0005\u0004\u00011z\u0013'.\u001c\t\u00033rk\u0011A\u0017\u0006\u00027\u0006)1oY1mC&\u0011QL\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0003W\"A(\n\u0005\u0005|%!\u0005)fe6L7o]5p]\u000e{g\u000e^3yiB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0006g24GG\u001b\u0006\u0002O\u0006AqM]5{u2,G-\u0003\u0002jI\n9Aj\\4hS:<\u0007CA-l\u0013\ta'LA\u0004Qe>$Wo\u0019;\u0011\u00059<hBA8v\u001d\t\u0001H/D\u0001r\u0015\t\u00118/\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005Y\u0016B\u0001<[\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001_=\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005YT\u0016aA3omV\tA\u0010\u0005\u0002`{&\u0011ap\u0014\u0002\u0015!\u0016\u0014X.[:tS>t7i\u001c8uKb$XI\u001c<\u0002\t\u0015tg\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0005\u0015\u0011q\u0001\t\u0003?\u0002AQA_\u0002A\u0002q\f1C]3mK\u0006\u001cX-\u00138g_Jl\u0017\r^5p]N,\"!!\u0004\u0011\u0011\u0005=\u0011\u0011DA\u000f\u0003[i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\b[V$\u0018M\u00197f\u0015\r\t9BW\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000e\u0003#\u00111!T1q!\u0011\ty\"a\n\u000f\t\u0005\u0005\u00121\u0005\t\u0003ajK1!!\n[\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011FA\u0016\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u0005.\u0011\u000be\u000by#a\r\n\u0007\u0005E\"L\u0001\u0004PaRLwN\u001c\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H)\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002>\u0005]\"A\u0005*fY\u0016\f7/Z%oM>\u0014X.\u0019;j_:\fAC]3mK\u0006\u001cX-\u00138g_Jl\u0017\r^5p]N\u0004\u0013!E4m_\n\fG\u000eU3s[&\u001c8/[8ogV\u0011\u0011Q\t\t\t\u0003\u001f\tI\"a\u0012\u0002ZA!\u0011\u0011JA+\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013A\u00039fe6L7o]5p]*\u0019\u0001+!\u0015\u000b\u0007\u0005M3+\u0001\u0005eKBdw._5u\u0013\u0011\t9&a\u0013\u0003\u0015A+'/\\5tg&|g\u000eE\u0002Z\u00037J1!!\u0018[\u0005\u001d\u0011un\u001c7fC:\f!c\u001a7pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8tA\t1A+Y:l\u0013\u0012\fa\u0002^1tW\u0012\u000bG/\u0019'p_.,\b/\u0006\u0002\u0002hAA\u0011qBA\r\u0003S\ni\u0007E\u0002\u0002l!i\u0011\u0001\u0001\t\u0005\u0003_\n)(\u0004\u0002\u0002r)!\u00111OA\u001c\u0003\u0015\tX/\u001a:z\u0013\u0011\t9(!\u001d\u0003\u001bQ\u000b7o\u001b\"bg&\u001cG)\u0019;b\u0003=!\u0018m]6ECR\fGj\\8lkB\u0004\u0013A\u0005:fY\u0016\f7/Z%oM>\u0014X.\u0019;j_:$B!!\f\u0002\u0000!9\u0011\u0011Q\u0006A\u0002\u0005u\u0011!\u0003:fY\u0016\f7/Z%e\u0003MA\u0017m]$m_\n\fG\u000eU3s[&\u001c8/[8o)\u0011\tI&a\"\t\u000f\u00055C\u00021\u0001\u0002H\u0005Yq-\u001a;UCN\\G)\u0019;b)\u0011\ti'!$\t\u000f\u0005=U\u00021\u0001\u0002j\u00051A/Y:l\u0013\u0012\f!#[:DkJ\u0014XM\u001c;Vg\u0016\u0014\u0018\tZ7j]V\u0011\u0011\u0011L\u0001\nG\",7m\u001b,jK^$B!!'\u0002 B\u0019\u0011,a'\n\u0007\u0005u%L\u0001\u0003V]&$\bbBAA\u001f\u0001\u0007\u0011QD\u0001\nG\",7m[#eSR$B!!'\u0002&\"9\u0011\u0011\u0011\tA\u0002\u0005u\u0011!D2iK\u000e\\W\tZ5u)\u0006\u001c8\u000e\u0006\u0003\u0002\u001a\u0006-\u0006bBAA#\u0001\u0007\u0011QD\u0001\u0018G\",7m\u001b'pG.$\u0016m]6QKJl\u0017n]:j_:$B!!'\u00022\"9\u0011\u0011\u0011\nA\u0002\u0005u\u0011aH2iK\u000e\\W\tZ5u!J,7m\u001c8eSRLwN\u001c)fe6L7o]5p]R!\u0011\u0011TA\\\u0011\u001d\t\ti\u0005a\u0001\u0003;\t\u0011e\u00195fG.,E-\u001b;GC&dWO]3IC:$G.\u001a:QKJl\u0017n]:j_:$B!!'\u0002>\"9\u0011\u0011\u0011\u000bA\u0002\u0005u\u0011aC2b]\u0016#\u0017\u000e\u001e+bg.$B!!\u0017\u0002D\"9\u0011\u0011Q\u000bA\u0002\u0005u\u0011AD2b]ZKWm\u001e*fY\u0016\f7/\u001a\u000b\u0005\u00033\nI\rC\u0004\u0002\u0002Z\u0001\r!!\b\u00021%\u001cxk\u001c:lM2|w/\u0012=fGV$\u0018n\u001c8Po:,'\u000f\u0006\u0003\u0002Z\u0005=\u0007bBAA/\u0001\u0007\u0011QD\u0001\u0013SN\u001cUO\u001d:f]R,6/\u001a:Po:,'\u000f\u0006\u0003\u0002Z\u0005U\u0007bBAA1\u0001\u0007\u0011QD\u0001\u0014SN<vN]6gY><X\t_3dkRLwN\u001c\u000b\u0005\u00033\nY\u000eC\u0004\u0002\u0002f\u0001\r!!\b\u0002\u000b\rDWmY6\u0015\r\u0005e\u0015\u0011]Ar\u0011\u001d\tiE\u0007a\u0001\u0003\u000fBq!!:\u001b\u0001\u0004\ti\"\u0001\u0003dS&#\u0017!\u00045bgB+'/\\5tg&|g\u000e\u0006\u0004\u0002Z\u0005-\u0018Q\u001e\u0005\b\u0003\u001bZ\u0002\u0019AA$\u0011\u001d\t)o\u0007a\u0001\u0003;\tq\u0002[1t\u0007&\u0004VM]7jgNLwN\u001c\u000b\u0007\u00033\n\u00190!>\t\u000f\u00055C\u00041\u0001\u0002H!9\u0011q\u001f\u000fA\u0002\u0005u\u0011aC2p]R\f\u0017N\\3s\u0013\u0012\f\u0001b\u00195fG.\fe.\u001f\u000b\u0007\u00033\u000bi0a@\t\u000f\u0005\u0015X\u00041\u0001\u0002\u001e!9!\u0011A\u000fA\u0002\t\r\u0011a\u00039fe6L7o]5p]N\u0004R!\u0017B\u0003\u0003\u000fJ1Aa\u0002[\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0004;\t-\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\u0007\tE!,\u0001\u0006b]:|G/\u0019;j_:LAA!\u0006\u0003\u0010\t9a/\u0019:be\u001e\u001c\u0018!E4fiZKWm\u001e)fe6L7o]5p]R!\u0011q\tB\u000e\u0011\u001d\t\tI\ba\u0001\u0003;!B!a\u0012\u0003 !9\u00111P\u0010A\u0002\u0005M\u0012AC2iK\u000e\\\u0017IY8siR!\u0011\u0011\u0014B\u0013\u0011\u001d\t\t\t\ta\u0001\u0003;\t!\"[:X_J\\g\r\\8x)\u0011\tIFa\u000b\t\u000f\u0005\u0005\u0015\u00051\u0001\u0002\u001e\u0005\u00192\r[3dW\u0016#\u0017\u000e^!ui\u0006\u001c\u0007.\\3oiR!\u0011\u0011\u0014B\u0019\u0011\u001d\t)O\ta\u0001\u0003;\tQe\u00195fG.L5/\u00117m_^,G\rV8FI&$\u0018\t\u001e;bG\"lWM\u001c;t\u001f:$\u0016m]6\u0015\t\u0005e%q\u0007\u0005\b\u0003\u001f\u001b\u0003\u0019AA\u000f\u0003\u0011ywO\\:\u0015\t\u0005e#Q\b\u0005\b\u0003\u001f#\u0003\u0019AA\u000fQ\u0015!#\u0011\tB*!\u0015I&1\tB$\u0013\r\u0011)E\u0017\u0002\u0007i\"\u0014xn^:\u0011\t\t%#qJ\u0007\u0003\u0005\u0017RAA!\u0014\u0002R\u0005IQ\r_2faRLwN\\\u0005\u0005\u0005#\u0012YEA\tO_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\f#A!\u0016\u0002[%4\u0007\u0005^1tW&#\u0007%[:!]>$\bEZ8v]\u0012\u0004\u0013N\u001c\u0011sKB|7/\u001b;pef\u0004C-\u0019;bE\u0006\u001cX-A\riCN\u0004VM]7jgNLwN\u001c+p+B$\u0017\r^3UCN\\G\u0003BA-\u00057Bq!a$&\u0001\u0004\ti\"A\u0010dQ\u0016\u001c7.\u00123jiR\u000b7o[\"p]\u001aLw-\u001e:bi&|gNR1dKR$B!!'\u0003b!9\u0011\u0011\u0011\u0014A\u0002\u0005u\u0011!H2b]\u0016#\u0017\u000e\u001e+bg.\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u001a\u000b7-\u001a;\u0015\t\u0005e#q\r\u0005\b\u0003\u0003;\u0003\u0019AA5\u00035\u0019\u0007.Z2l\u000b\u0012LG\u000fR1uKR!\u0011\u0011\u0014B7\u0011\u001d\t)\u000f\u000ba\u0001\u0003;\t1d\u00195fG.,E-\u001b;CY\u0006\u001c7n\\;u!\u0016\u0014X.[:tS>tG\u0003BAM\u0005gBq!!!*\u0001\u0004\tI'A\u000edQ\u0016\u001c7NU3bgNLwM\u001c+bg.\u0004VM]7jgNLwN\u001c\u000b\u0005\u00033\u0013I\bC\u0004\u0002\u0002*\u0002\r!!\b\u0002/\rDWmY6SK\u0006\u001c8/[4o)\u0006\u001c8\u000eV8Vg\u0016\u0014HCBAM\u0005\u007f\u0012\t\tC\u0004\u0002\u0010.\u0002\r!!\u001b\t\u000f\t\r5\u00061\u0001\u0002j\u00059a.Z<Vg\u0016\u0014\u0018!G1sKV\u001bXM]:J]RCWmU1nKR\u000b7o\u001b+fC6$b!!\u0017\u0003\n\ne\u0005b\u0002BFY\u0001\u0007!QR\u0001\u0005i\u0006\u001c8\u000e\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\r\u0011\u0019*U\u0001\u0007I>l\u0017-\u001b8\n\t\t]%\u0011\u0013\u0002\u0005)\u0006\u001c8\u000eC\u0004\u0003\u00042\u0002\r!!\b\u0015\r\u0005e#Q\u0014BP\u0011\u001d\ty)\fa\u0001\u0003;AqAa!.\u0001\u0004\ti\"\u0001\u0007jgV\u001bXM]%o)\u0016\fW\u000e\u0006\u0004\u0002Z\t\u0015&\u0011\u0016\u0005\b\u0005Os\u0003\u0019AA\u000f\u0003\u0011)8/\u001a:\t\u000f\t-f\u00061\u0001\u0003.\u0006!A/Z1n!\u0011\u0011yIa,\n\t\tE&\u0011\u0013\u0002\u0005)\u0016\fW.A\u000bjg\u0006cGn\\<fIR{wk\u001c:l\u001f:$\u0016m]6\u0015\t\u0005e#q\u0017\u0005\b\u0003\u001f{\u0003\u0019AA5\u0003\u0015\u001a\u0007.Z2l%\u0016dWM^1oiR\u000b7o\u001b+sC:\u001c\u0018\u000e^5p]B+'/\\5tg&|g\u000e\u0006\u0003\u0002\u001a\nu\u0006bBAHa\u0001\u0007\u0011QD\u0001\u0011SN$\u0016m]6Va\u0012\fG/Z1cY\u0016$B!!\u0017\u0003D\"9\u0011qR\u0019A\u0002\u0005%\u0014\u0001F2iK\u000e\\G+Y:l\u0013N,\u0006\u000fZ1uC\ndW\r\u0006\u0003\u0002\u001a\n%\u0007bBAHe\u0001\u0007\u0011QD\u0001#Q\u0006\u001c\u0018\t\u001a<b]\u000e,G+Y:l)J\fgn]5uS>t\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\t\u0005e#q\u001a\u0005\b\u0003\u0003\u001b\u0004\u0019AA\u000f\u0003mA\u0017m\u001d+bg.$&/\u00198tSRLwN\u001c)fe6L7o]5p]R!\u0011\u0011\fBk\u0011\u001d\ty\t\u000ea\u0001\u0003;\tqd\u00195fG.D\u0015m\u001d)fe6L7o]5p]N$v.\u00169eCR,G+Y:l)\u0011\tIJa7\t\u000f\t-U\u00071\u0001\u0003\u000eR!\u0011\u0011\u0014Bp\u0011\u001d\tyI\u000ea\u0001\u0003;\t!d\u00195fG.L5/\u00117m_^,G\rV8X_J\\wJ\u001c+bg.$B!!'\u0003f\"9\u0011qR\u001cA\u0002\u0005u\u0011!H2iK\u000e\\\u0017j]!mY><X\r\u001a+p\u0007>lW.\u001a8u\u001f:$\u0016m]6\u0015\t\u0005e%1\u001e\u0005\b\u0003\u001fC\u0004\u0019AA\u000f\u0003a\u0019\u0007.Z2l\u0007\u0006twJ^3se&$WM\u00117bG.|W\u000f\u001e\u000b\u0005\u00033\u0013\t\u0010C\u0004\u0002\u0010f\u0002\r!!\b\u0002;\rDWmY6UCN\\GK]1og&$\u0018n\u001c8QKJl\u0017n]:j_:$B!!'\u0003x\"9\u0011q\u0012\u001eA\u0002\u0005%\u0014\u0001J2iK\u000e\\\u0017\t\u001a<b]\u000e,G+Y:l)J\fgn]5uS>t\u0007+\u001a:nSN\u001c\u0018n\u001c8\u0015\t\u0005e%Q \u0005\b\u0003\u001f[\u0004\u0019AA\u000f\u0003\u0011\u0019w\u000e]=\u0015\t\u0005\u001511\u0001\u0005\bur\u0002\n\u00111\u0001}\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"a!\u0003+\u0007q\u001cYa\u000b\u0002\u0004\u000eA!1qBB\u000b\u001b\t\u0019\tB\u0003\u0003\u0004\u0014\t=\u0011!C;oG\",7m[3e\u0013\u0011\u00199b!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007;\u0001Baa\b\u0004*5\u00111\u0011\u0005\u0006\u0005\u0007G\u0019)#\u0001\u0003mC:<'BAB\u0014\u0003\u0011Q\u0017M^1\n\t\u0005%2\u0011E\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0007_\u00012!WB\u0019\u0013\r\u0019\u0019D\u0017\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007s\u0019y\u0004E\u0002Z\u0007wI1a!\u0010[\u0005\r\te.\u001f\u0005\n\u0007\u0003\u0002\u0015\u0011!a\u0001\u0007_\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB$!\u0019\u0019Iea\u0013\u0004:5\u0011\u0011QC\u0005\u0005\u0007\u001b\n)B\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA-\u0007'B\u0011b!\u0011C\u0003\u0003\u0005\ra!\u000f\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0007;\u0019I\u0006C\u0005\u0004B\r\u000b\t\u00111\u0001\u00040\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00040\u0005AAo\\*ue&tw\r\u0006\u0002\u0004\u001e\u00051Q-];bYN$B!!\u0017\u0004h!I1\u0011\t$\u0002\u0002\u0003\u00071\u0011H\u0001\u0019%\u0016dW-Y:f!\u0016\u0014X.[:tS>t7i\u001c8uKb$\bCA0I'\u0015A5qNB>!\u001d\u0019\tha\u001e}\u0003\u000bi!aa\u001d\u000b\u0007\rU$,A\u0004sk:$\u0018.\\3\n\t\re41\u000f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BB?\u0007\u0007k!aa \u000b\t\r\u00055QE\u0001\u0003S>L1\u0001_B@)\t\u0019Y'A\u0003baBd\u0017\u0010\u0006\u0003\u0002\u0006\r-\u0005\"\u0002>L\u0001\u0004a\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0007#\u001b\u0019\n\u0005\u0003Z\u0003_a\b\"CBK\u0019\u0006\u0005\t\u0019AA\u0003\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00077\u0003Baa\b\u0004\u001e&!1qTB\u0011\u0005\u0019y%M[3di\u0002")
public class ReleasePermissionContext
implements PermissionContext,
Logging,
Product,
Serializable {
    private boolean isCurrentUserAdmin;
    private final PermissionContextEnv env;
    private final Map<String, Option<ReleaseInformation>> releaseInformations;
    private final Map<Permission, Object> globalPermissions;
    private final Map<String, TaskBasicData> taskDataLookup;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<PermissionContextEnv> unapply(ReleasePermissionContext x$0) {
        return ReleasePermissionContext$.MODULE$.unapply(x$0);
    }

    public static ReleasePermissionContext apply(PermissionContextEnv env) {
        return ReleasePermissionContext$.MODULE$.apply(env);
    }

    public static <A> Function1<PermissionContextEnv, A> andThen(Function1<ReleasePermissionContext, A> g) {
        return ReleasePermissionContext$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, ReleasePermissionContext> compose(Function1<A, PermissionContextEnv> g) {
        return ReleasePermissionContext$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleasePermissionContext releasePermissionContext = this;
        synchronized (releasePermissionContext) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public void checkAny(String ciId, Permission ... permissions) {
        this.checkAny(ciId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])permissions));
    }

    public PermissionContextEnv env() {
        return this.env;
    }

    private Map<String, Option<ReleaseInformation>> releaseInformations() {
        return this.releaseInformations;
    }

    private Map<Permission, Object> globalPermissions() {
        return this.globalPermissions;
    }

    private Map<String, TaskBasicData> taskDataLookup() {
        return this.taskDataLookup;
    }

    private Option<ReleaseInformation> releaseInformation(String releaseId) {
        Option result = (Option)this.releaseInformations().getOrElseUpdate((Object)releaseId, (Function0 & Serializable)() -> {
            block0: {
                this.logger().debug((Function0 & Serializable)() -> "Release information requested for releaseId: " + releaseId + ".");
                if (this.releaseInformations().size() <= 0) break block0;
                this.logger().error((Function0 & Serializable)() -> "Unexpected release information requested for releaseId: " + releaseId + ". Current entries: " + this.releaseInformations().keys());
            }
            return this.env().getReleaseInformation(releaseId);
        });
        return result;
    }

    @Override
    public boolean hasGlobalPermission(Permission permission) {
        return BoxesRunTime.unboxToBoolean((Object)this.globalPermissions().getOrElseUpdate((Object)permission, (Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            this.logger().debug((Function0 & Serializable)() -> "Requested check for global permission " + permission);
            return this.env().hasGlobalPermission(permission);
        }));
    }

    private TaskBasicData getTaskData(String taskId) {
        return (TaskBasicData)this.taskDataLookup().getOrElseUpdate((Object)taskId, (Function0 & Serializable)() -> this.env().getTaskData(taskId));
    }

    private boolean isCurrentUserAdmin$lzycompute() {
        ReleasePermissionContext releasePermissionContext = this;
        synchronized (releasePermissionContext) {
            if (!this.bitmap$0) {
                this.isCurrentUserAdmin = this.env().isCurrentUserAdmin();
                this.bitmap$0 = true;
            }
        }
        return this.isCurrentUserAdmin;
    }

    public boolean isCurrentUserAdmin() {
        if (!this.bitmap$0) {
            return this.isCurrentUserAdmin$lzycompute();
        }
        return this.isCurrentUserAdmin;
    }

    @Override
    public void checkView(String releaseId) {
        if (!this.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL)) {
            if (!this.isWorkflowExecutionOwner(releaseId)) {
                this.check(this.getViewPermission(releaseId), releaseId);
                return;
            }
            return;
        }
    }

    @Override
    public void checkEdit(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE;
        this.check(permissionToCheck, releaseId);
    }

    @Override
    public void checkEditTask(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit task on " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    @Override
    public void checkLockTaskPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot lock task on " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.LOCK_TEMPLATE_TASK : XLReleasePermissions.LOCK_RELEASE_TASK;
        this.check(permissionToCheck, releaseId);
    }

    @Override
    public void checkEditPreconditionPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit precondition on " + releaseId));
        });
        if (releaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE_PRECONDITION, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_PRECONDITION, XLReleasePermissions.EDIT_RELEASE_TASK}));
    }

    @Override
    public void checkEditFailureHandlerPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit failure handler on " + releaseId));
        });
        if (releaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE_FAILURE_HANDLER, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_FAILURE_HANDLER, XLReleasePermissions.EDIT_RELEASE_TASK}));
    }

    @Override
    public boolean canEditTask(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot edit task on " + releaseId));
        });
        Permission permissionToCheck = releaseInfo.isTemplate() ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK;
        return this.hasPermission(permissionToCheck, releaseId);
    }

    @Override
    public boolean canViewRelease(String releaseId) {
        return this.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL) || this.isWorkflowExecutionOwner(releaseId) || this.hasCiPermission(this.getViewPermission(releaseId), releaseId);
    }

    private boolean isWorkflowExecutionOwner(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$isWorkflowExecutionOwner$2(this, releaseId, x$1))));
    }

    private boolean isCurrentUserOwner(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$isCurrentUserOwner$2(this, x$2))));
    }

    private boolean isWorkflowExecution(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isWorkflowExecution())));
    }

    @Override
    public void check(Permission permission, String ciId) {
        boolean checkOwner;
        boolean bl = checkOwner = PermissionChecker$.MODULE$.isWorkflowRelatedPermission(permission) && this.isWorkflowExecution(ciId);
        if (checkOwner) {
            if (!this.isWorkflowExecutionOwner(ciId)) {
                throw PermissionDeniedException.withMessage((String)("You are not the owner of the workflow execution " + ciId));
            }
            return;
        }
        if (!this.hasPermission(permission, ciId)) {
            throw PermissionDeniedException.forPermission((Permission)permission, (String)ciId);
        }
    }

    @Override
    public boolean hasPermission(Permission permission, String ciId) {
        return this.hasGlobalPermission(permission) || this.hasCiPermission(permission, ciId);
    }

    @Override
    public boolean hasCiPermission(Permission permission, String containerId) {
        boolean bl;
        if (!PermissionChecker$.MODULE$.isPermissionApplicableTo(permission, containerId)) {
            bl = false;
        } else {
            Option<ReleaseInformation> option = this.releaseInformation(containerId);
            if (option instanceof Some) {
                Some some = (Some)option;
                ReleaseInformation r = (ReleaseInformation)some.value();
                bl = r.isArchived() ? this.env().hasArchivedReleasePermission(permission, containerId) : (PermissionChecker$.MODULE$.isWorkflowRelatedPermission(permission) && r.isWorkflowExecution() ? this.isWorkflowExecutionOwner(containerId) : this.env().hasEffectiveSecuredCiPermission(permission, containerId));
            } else if (None$.MODULE$.equals(option)) {
                bl = this.env().hasEffectiveSecuredCiPermission(permission, containerId);
            } else {
                throw new MatchError(option);
            }
        }
        boolean hasRequiredPermission = bl;
        return hasRequiredPermission;
    }

    public void checkAny(String ciId, Seq<Permission> permissions) {
        Object object = new Object();
        try {
            permissions.foreach((Function1 & Serializable)permission -> {
                ReleasePermissionContext.$anonfun$checkAny$1(this, ciId, object, permission);
                return BoxedUnit.UNIT;
            });
            throw PermissionChecker$.MODULE$.exceptionForPermissions(ciId, permissions);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            ex.value$mcV$sp();
            return;
        }
    }

    private Permission getViewPermission(String releaseId) {
        return (Permission)this.releaseInformation(releaseId).map((Function1 & Serializable)releaseInformation -> this.getViewPermission((ReleaseInformation)releaseInformation)).getOrElse((Function0 & Serializable)() -> XLReleasePermissions.VIEW_RELEASE);
    }

    private Permission getViewPermission(ReleaseInformation releaseInformation) {
        if (releaseInformation.isTemplate()) {
            return XLReleasePermissions.VIEW_TEMPLATE;
        }
        if (releaseInformation.isWorkflowExecution()) {
            return XLReleasePermissions.VIEW_WORKFLOW_EXECUTION;
        }
        return XLReleasePermissions.VIEW_RELEASE;
    }

    @Override
    public void checkAbort(String releaseId) {
        if (this.isWorkflow(releaseId)) {
            if (!this.isWorkflowExecutionOwner(releaseId) && !this.hasPermission(XLReleasePermissions.ABORT_WORKFLOW_EXECUTION, releaseId)) {
                throw PermissionDeniedException.withMessage((String)("You are not the owner of the workflow execution or do not have " + XLReleasePermissions.ABORT_WORKFLOW_EXECUTION + " permission on " + releaseId));
            }
            return;
        }
        if (!this.hasPermission(XLReleasePermissions.ABORT_RELEASE, releaseId)) {
            throw PermissionDeniedException.forPermission((Permission)XLReleasePermissions.ABORT_RELEASE, (String)releaseId);
        }
    }

    private boolean isWorkflow(String releaseId) {
        return BoxesRunTime.unboxToBoolean((Object)this.releaseInformation(releaseId).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isWorkflow())));
    }

    @Override
    public void checkEditAttachment(String ciId) {
        if (Ids.isTaskId((String)ciId)) {
            this.checkIsAllowedToEditAttachmentsOnTask(ciId);
            return;
        }
        this.checkEdit(Ids.releaseIdFrom((String)ciId));
    }

    @Override
    public void checkIsAllowedToEditAttachmentsOnTask(String taskId) {
        try {
            String releaseId = Ids.releaseIdFrom((String)taskId);
            if (!this.hasPermissionToUpdateTask(taskId) && !this.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK_ATTACHMENT, releaseId)) {
                throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Task owner', 'Member of task team', 'edit task' or 'edit task attachments'");
            }
        }
        catch (NotFoundException e) {
            throw PermissionDeniedException.withMessage((String)("You cannot upload attachments on archived task [" + taskId + "]"));
        }
    }

    private boolean owns(String taskId) throws NotFoundException {
        TaskBasicData taskData = this.getTaskData(taskId);
        String string = taskData.owner();
        String string2 = Permissions.getAuthenticatedUserName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean hasPermissionToUpdateTask(String taskId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (this.isCurrentUserAdmin() || this.canEditTask(releaseId) || this.owns(taskId)) {
            return true;
        }
        return Option$.MODULE$.apply((Object)this.getTaskData(taskId).team()).exists((Function1 & Serializable)team -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$hasPermissionToUpdateTask$1(this, taskId, team)));
    }

    @Override
    public void checkEditTaskConfigurationFacet(String releaseId) {
        if (!this.canEditTask(releaseId) && !this.canEditTaskConfigurationFacet(releaseId)) {
            throw PermissionDeniedException.withMessage((String)("You are not allowed to create facets on tasks of release [" + releaseId + "]"));
        }
    }

    private boolean canEditTaskConfigurationFacet(String releaseId) {
        return this.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK_CONFIGURATION_FACET, releaseId);
    }

    @Override
    public void checkEditDate(String ciId) {
        String releaseId = Ids.releaseIdFrom((String)ciId);
        if (Ids.isReleaseId((String)ciId) || Ids.isPhaseId((String)ciId)) {
            this.checkEdit(releaseId);
            return;
        }
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You do not have permission to edit dates on " + ciId));
        });
        .colon.colon permissionsToCheck = releaseInfo.isTemplate() ? new .colon.colon((Object)XLReleasePermissions.EDIT_TEMPLATE, (List)Nil$.MODULE$) : new .colon.colon((Object)XLReleasePermissions.EDIT_RELEASE_TASK, (List)new .colon.colon((Object)XLReleasePermissions.EDIT_TASK_DATES, (List)Nil$.MODULE$));
        this.checkAny(releaseId, (Seq<Permission>)permissionsToCheck);
    }

    @Override
    public void checkEditBlackoutPermission(String releaseId) {
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You do not have permission to edit blackout on " + releaseId));
        });
        if (releaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_TASK, XLReleasePermissions.EDIT_BLACKOUT}));
    }

    @Override
    public void checkReassignTaskPermission(String releaseId) {
        ReleaseInformation relaseInfo = (ReleaseInformation)this.releaseInformation(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You do not have permission to reassign task on " + releaseId));
        });
        if (relaseInfo.isTemplate()) {
            this.check(XLReleasePermissions.EDIT_TEMPLATE, releaseId);
            return;
        }
        this.checkAny(releaseId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_TASK, XLReleasePermissions.REASSIGN_RELEASE_TASK}));
    }

    @Override
    public void checkReassignTaskToUser(String taskId, String newUser) {
        block2: {
            try {
                String releaseId = Ids.releaseIdFrom((String)taskId);
                this.checkReassignTaskPermission(releaseId);
            }
            catch (PermissionDeniedException e) {
                if (this.areUsersInTheSameTaskTeam(taskId, newUser)) break block2;
                throw e;
            }
        }
    }

    @Override
    public boolean areUsersInTheSameTaskTeam(Task task, String newUser) {
        return this.areUsersInTheSameTaskTeam(task.getId(), newUser);
    }

    private boolean areUsersInTheSameTaskTeam(String taskId, String newUser) {
        Authentication currentAuthentication = Permissions.getAuthentication();
        TaskBasicData task = this.getTaskData(taskId);
        if (task.team() != null) {
            String releaseId = Ids.releaseIdFrom((String)taskId);
            Option<Team> teamOptional = this.env().findTeamByName(releaseId, task.team());
            return teamOptional.exists((Function1 & Serializable)team -> BoxesRunTime.boxToBoolean((boolean)ReleasePermissionContext.$anonfun$areUsersInTheSameTaskTeam$1(this, currentAuthentication, newUser, team)));
        }
        return false;
    }

    private boolean isUserInTeam(String user, Team team) {
        return team.hasMember(user) || team.hasAnyRole(this.env().getRolesFor(user)) || this.env().isExternalUserPrincipalIsFromTheGroupAssigned(user, team);
    }

    @Override
    public boolean isAllowedToWorkOnTask(String taskId) {
        TaskBasicData task = this.getTaskData(taskId);
        return task.isUpdatable() && this.hasPermissionToUpdateTask(taskId);
    }

    @Override
    public void checkRelevantTaskTransitionPermission(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        TaskBasicData task = this.getTaskData(taskId);
        if (task.isPlanned()) {
            if (!this.hasAdvanceTaskTransitionPermission(releaseId)) {
                throw PermissionDeniedException.withMessage((String)("You cannot make advance task transition for task=[" + taskId + "]. You need to have permission or be release owner"));
            }
            return;
        }
        if (!this.hasTaskTransitionPermission(taskId)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make task transition for task=[" + taskId + "]. You need to have permission or be either release owner or task owner"));
        }
    }

    public boolean isTaskUpdateable(String taskId) {
        TaskBasicData task = this.getTaskData(taskId);
        return task.isUpdatable();
    }

    public void checkTaskIsUpdatable(String taskId) {
        if (!this.isTaskUpdateable(taskId)) {
            throw new IllegalArgumentException("You can not work with a defunct or done in advance task");
        }
    }

    private boolean hasAdvanceTaskTransitionPermission(String releaseId) {
        return this.isCurrentUserAdmin() || this.canEditTask(releaseId) || this.hasCiPermission(XLReleasePermissions.ADVANCE_TASK_TRANSITION, releaseId);
    }

    public boolean hasTaskTransitionPermission(String taskId) {
        boolean allowReleaseOwnerTaskTransition = this.env().xlrConfig().isReleaseOwnerTaskTransitionAllowed();
        String releaseId = Ids.releaseIdFrom((String)taskId);
        return allowReleaseOwnerTaskTransition && this.isCurrentUserOwner(releaseId) || this.hasPermissionToUpdateTask(taskId) || this.hasCiPermission(XLReleasePermissions.TASK_TRANSITION, releaseId);
    }

    @Override
    public void checkHasPermissionsToUpdateTask(Task task) {
        this.checkHasPermissionsToUpdateTask(task.getId());
    }

    private void checkHasPermissionsToUpdateTask(String taskId) {
        if (!this.hasPermissionToUpdateTask(taskId)) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Task owner', 'Member of task team' or 'edit task'");
        }
    }

    @Override
    public void checkIsAllowedToWorkOnTask(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        this.checkHasPermissionsToUpdateTask(taskId);
    }

    @Override
    public void checkIsAllowedToCommentOnTask(String taskId) {
        String taskReleaseId = Ids.releaseIdFrom((String)taskId);
        ReleaseInformation releaseInfo = (ReleaseInformation)this.releaseInformation(taskReleaseId).getOrElse((Function0 & Serializable)() -> {
            throw PermissionDeniedException.withMessage((String)("You cannot comment task " + taskId));
        });
        if (releaseInfo.isArchived()) {
            throw PermissionDeniedException.withMessage((String)("You cannot comment on archived task [" + taskId + "]"));
        }
        if (!this.isCurrentUserAdmin()) {
            this.checkView(taskReleaseId);
            return;
        }
    }

    public void checkCanOverrideBlackout(String taskId) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (!this.hasCiPermission(XLReleasePermissions.EDIT_BLACKOUT, releaseId) && this.hasCiPermission(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId)) {
            throw PermissionDeniedException.forNodeAndPrivilege((String)taskId, (String)"'Edit task blackout'");
        }
    }

    @Override
    public void checkTaskTransitionPermission(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        if (!this.hasTaskTransitionPermission(taskId)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make task transition for task=[" + taskId + "]. You need to have permission or be either release owner or task owner"));
        }
    }

    @Override
    public void checkAdvanceTaskTransitionPermission(String taskId) {
        this.checkTaskIsUpdatable(taskId);
        TaskBasicData task = this.getTaskData(taskId);
        String releaseId = Ids.releaseIdFrom((String)taskId);
        if (task.isPlanned() && !this.hasAdvanceTaskTransitionPermission(releaseId)) {
            throw PermissionDeniedException.withMessage((String)("You cannot make advance task transition for task=[" + taskId + "]. You need to have permission or be release owner"));
        }
    }

    public ReleasePermissionContext copy(PermissionContextEnv env) {
        return new ReleasePermissionContext(env);
    }

    public PermissionContextEnv copy$default$1() {
        return this.env();
    }

    public String productPrefix() {
        return "ReleasePermissionContext";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.env();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReleasePermissionContext;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "env";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ReleasePermissionContext)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReleasePermissionContext releasePermissionContext = (ReleasePermissionContext)x$1;
        PermissionContextEnv permissionContextEnv = this.env();
        PermissionContextEnv permissionContextEnv2 = releasePermissionContext.env();
        if (permissionContextEnv == null) {
            if (permissionContextEnv2 != null) {
                return false;
            }
        } else if (!permissionContextEnv.equals(permissionContextEnv2)) return false;
        if (!releasePermissionContext.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$isWorkflowExecutionOwner$2(ReleasePermissionContext $this, String releaseId$8, ReleaseInformation x$1) {
        return x$1.isWorkflowExecution() && $this.isCurrentUserOwner(releaseId$8);
    }

    public static final /* synthetic */ boolean $anonfun$isCurrentUserOwner$2(ReleasePermissionContext $this, ReleaseInformation x$2) {
        return x$2.owner().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equalsIgnoreCase(Permissions.getAuthenticatedUserName()))) || $this.isCurrentUserAdmin();
    }

    public static final /* synthetic */ void $anonfun$checkAny$1(ReleasePermissionContext $this, String ciId$1, Object nonLocalReturnKey1$1, Permission permission) {
        if ($this.hasPermission(permission, ciId$1)) {
            throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasPermissionToUpdateTask$1(ReleasePermissionContext $this, String taskId$2, String team) {
        return $this.env().isMemberOrRoleOf(Ids.releaseIdFrom((String)taskId$2), team);
    }

    public static final /* synthetic */ boolean $anonfun$areUsersInTheSameTaskTeam$1(ReleasePermissionContext $this, Authentication currentAuthentication$1, String newUser$1, Team team) {
        return $this.isUserInTeam(currentAuthentication$1.getName(), team) && (newUser$1 == null || $this.isUserInTeam(newUser$1, team));
    }

    public ReleasePermissionContext(PermissionContextEnv env) {
        this.env = env;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.releaseInformations = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.globalPermissions = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.taskDataLookup = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

