package com.xebialabs.xlrelease.views;

import java.util.Date;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class ReleaseOverview {
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String id;
    private String type;
    private String title;
    private Date startDate;
    private Date endDate;
    private ReleaseStatus status;
    private Long plannedDuration;
    private boolean archived;
    private Integer riskScore;
    private Integer totalTasks;
    private Integer totalRemainingTasks;
    private Integer calculatedProgressPercent;
    private Flag flag;
    private ReleaseKind kind;

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

    public String getType() {
        return type;
    }

    public void setType(final String type) {
        this.type = type;
    }

    public Long getPlannedDuration() {
        return plannedDuration;
    }

    public void setPlannedDuration(final Long plannedDuration) {
        this.plannedDuration = plannedDuration;
    }

    public ReleaseStatus getStatus() {
        return status;
    }

    public void setStatus(final ReleaseStatus status) {
        this.status = status;
    }

    public boolean isArchived() {
        return archived;
    }

    public void setArchived(final boolean archived) {
        this.archived = archived;
    }

    public Integer getRiskScore() {
        return riskScore;
    }

    public void setRiskScore(final Integer riskScore) {
        this.riskScore = riskScore;
    }

    public Integer getTotalTasks() {
        return totalTasks;
    }

    public void setTotalTasks(final Integer totalTasks) {
        this.totalTasks = totalTasks;
    }

    public Integer getTotalRemainingTasks() {
        return totalRemainingTasks;
    }

    public void setTotalRemainingTasks(final Integer totalRemainingTasks) {
        this.totalRemainingTasks = totalRemainingTasks;
    }

    public Integer getCalculatedProgressPercent() {
        return calculatedProgressPercent;
    }

    public void setCalculatedProgressPercent(final Integer calculatedProgressPercent) {
        this.calculatedProgressPercent = calculatedProgressPercent;
    }

    public Flag getFlag() {
        return flag;
    }

    public void setFlag(final Flag flag) {
        this.flag = flag;
    }

    public ReleaseKind getKind() {
        return kind;
    }

    public void setKind(final ReleaseKind kind) {
        this.kind = kind;
    }
}
