package com.xebialabs.xlrelease.scheduler.strategies

import com.xebialabs.xlrelease.features.settings.JobSchedulerStrategySettings
import com.xebialabs.xlrelease.scheduler.Job
import com.xebialabs.xlrelease.scheduler.strategies.JobSchedulerStrategy.ScheduleResult

trait JobSchedulerStrategy[T <: JobSchedulerStrategySettings] {
  def schedule(configurationItem: T)(job: Job): ScheduleResult
}

object JobSchedulerStrategy {

  type DelayedJob = Job
  // Left: if job should be delayed, Right: job to be executed normally
  type ScheduleResult = Either[DelayedJob, Job]

}