package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Personal access tokens",
  description = "Release will use this setting to enable Personal Access Tokens for users that log in through SSO / OIDC. " +
    "It allows you to also control the maximum token expiry duration."
)
class PersonalAccessTokenFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Stable",
    isTransient = true,
    hidden = true,
    readonly = true)
  var category: String = _

  @BeanProperty
  @XLProperty(defaultValue = "user-security", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "general-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/personal-access-tokens-based-authentication.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "20", hidden = true)
  var weight: Integer = _

  @BeanProperty
  @XLProperty(label = "Enable Personal Access Tokens for SSO Users",
    description = "When checked, Personal Access Tokens support is enabled for SSO Users like OIDC. " +
      "The token will remain active when a user is deleted in the external system.",
    category = "input",
    defaultValue = "true")
  var enabled: Boolean = _

  @BeanProperty
  @XLProperty(label = "Maximum token expiration duration",
    description = "Release will utilize this setting to establish the maximum token expiration duration for tokens. " +
      "This option enables a Release Admin to prevent the creation of long-running or non-expiring tokens.",
    category = "input", nested = true)
  var maxTokenExpiration: MaxTokenExpirationDuration = _
}

@Metadata(virtual = true)
abstract class MaxTokenExpirationDuration extends BaseConfigurationItem {
  @BeanProperty
  @XLProperty(category = "Common", required = false, isTransient = true)
  var duration: Int = _
}

@Metadata(label = "No expiration")
class NoExpirationDuration extends MaxTokenExpirationDuration {
  setDuration(-1)
}

@Metadata(label = "7 days")
class WeekExpirationDuration extends MaxTokenExpirationDuration {
  setDuration(7)
}

@Metadata(label = "30 days")
class MonthExpirationDuration extends MaxTokenExpirationDuration {
  setDuration(30)
}

@Metadata(label = "60 days")
class TwoMonthsExpirationDuration extends MaxTokenExpirationDuration {
  setDuration(60)
}

@Metadata(label = "1 year")
class YearExpirationDuration extends MaxTokenExpirationDuration {
  setDuration(365)
}
