package com.xebialabs.xlrelease.api.v1.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.xlrelease.api.v1.SettingsApi;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;

import static com.xebialabs.deployit.security.permission.PlatformPermissions.ADMIN;
import static com.xebialabs.xlrelease.security.XLReleasePermissions.AUDIT_ALL;

@Controller
public class SettingsApiImpl implements SettingsApi {
    private final ConfigurationRepository configurationRepository;
    private final PermissionChecker permissions;

    @Autowired
    public SettingsApiImpl(final ConfigurationRepository configurationRepository, final PermissionChecker permissions) {
        this.configurationRepository = configurationRepository;
        this.permissions = permissions;
    }

    @Override
    public BaseConfiguration getSettings(final String id) {
        permissions.checkAny(ADMIN, AUDIT_ALL);
        return configurationRepository.read(id);
    }
}
