package com.xebialabs.deployit.plumbing

import ch.qos.logback.access.jetty.RequestLogImpl
import org.eclipse.jetty.http.{HttpFields, HttpURI, HttpVersion, MetaData}
import org.eclipse.jetty.server._
import org.eclipse.jetty.server.handler.ContextHandler
import org.eclipse.jetty.server.session.SessionHandler
import org.eclipse.jetty.util.component.LifeCycle
import org.eclipse.jetty.util.{Attributes, MultiMap}

import java.io.{BufferedReader, IOException, UnsupportedEncodingException}
import java.net.InetSocketAddress
import java.security.Principal
import java.{util => jutil}
import jakarta.servlet._
import jakarta.servlet.http.{Cookie, HttpServletResponse, HttpSession, HttpUpgradeHandler, Part, PushBuilder}

class XLRequestLogImpl (fileName: String) extends RequestLogImpl with LifeCycle {
  setFileName(fileName)

  override def log(jettyRequest: Request, jettyResponse: Response): Unit =
    super.log(new RemoteUserByAttributeRequestWrapper(jettyRequest), jettyResponse)

}

/**
  * Wraps the {@link org.eclipse.jetty.server.Request} providing a custom implementation of {@link #getRemoteUser()}
  * to get it from custom request attribute {@link LogbackAccessSecurityAttributesSaveFilter#remoteUserAttribute}.
  * All other methods are delegated to the original request.
  */
private class RemoteUserByAttributeRequestWrapper private[plumbing](val request: Request) extends Request(request.getHttpChannel, request.getHttpInput) {

  override def getRemoteUser: String = Option(request.getAttribute(LogbackAccessSecurityAttributesSaveFilter.remoteUserAttribute)).map(_.toString).getOrElse(request.getRemoteUser)

  override def getHttpFields: HttpFields = request.getHttpFields

  override def getTrailerHttpFields: HttpFields = request.getTrailerHttpFields

  override def getHttpInput: HttpInput = request.getHttpInput

  override def isPush: Boolean = request.isPush

  override def isPushSupported: Boolean = request.isPushSupported

  override def newPushBuilder: PushBuilder = request.newPushBuilder

  override def addEventListener(listener: jutil.EventListener): Unit = request.addEventListener(listener)

  override def extractFormParameters(params: MultiMap[String]): Unit = request.extractFormParameters(params)

  override def getAsyncContext: AsyncContext = request.getAsyncContext

  override def getHttpChannelState: HttpChannelState = request.getHttpChannelState

  override def getAttribute(name: String): Object = request.getAttribute(name)

  override def getAttributeNames: jutil.Enumeration[String] = request.getAttributeNames

  override def getAttributes: Attributes = request.getAttributes

  override def getAuthentication: Authentication = request.getAuthentication

  override def getAuthType: String = request.getAuthType

  override def getCharacterEncoding: String = request.getCharacterEncoding

  override def getHttpChannel: HttpChannel = request.getHttpChannel

  override def getContentLength: Int = request.getContentLength

  override def getContentLengthLong: Long = request.getContentLengthLong

  override def getContentRead: Long = request.getContentRead

  override def getContentType: String = request.getContentType

  override def getContext: ContextHandler#Context = request.getContext

  override def getContextPath: String = request.getContextPath

  override def getCookies: Array[Cookie] = request.getCookies

  override def getDateHeader(name: String): Long = request.getDateHeader(name)

  override def getDispatcherType: DispatcherType = request.getDispatcherType

  override def getHeader(name: String): String = request.getHeader(name)

  override def getHeaderNames: jutil.Enumeration[String] = request.getHeaderNames

  override def getHeaders(name: String): jutil.Enumeration[String] = request.getHeaders(name)

  override def getInputState: Int = request.getInputState

  @throws[IOException]
  override def getInputStream: ServletInputStream = request.getInputStream

  override def getIntHeader(name: String): Int = request.getIntHeader(name)

  override def getLocale: jutil.Locale = request.getLocale

  override def getLocales: jutil.Enumeration[jutil.Locale] = request.getLocales

  override def getLocalAddr: String = request.getLocalAddr

  override def getLocalName: String = request.getLocalName

  override def getLocalPort: Int = request.getLocalPort

  override def getMethod: String = request.getMethod

  override def getParameter(name: String): String = request.getParameter(name)

  override def getParameterMap: jutil.Map[String, Array[String]] = request.getParameterMap

  override def getParameterNames: jutil.Enumeration[String] = request.getParameterNames

  override def getParameterValues(name: String): Array[String] = request.getParameterValues(name)

  override def getQueryParameters: MultiMap[String] = request.getQueryParameters

  override def setQueryParameters(queryParameters: MultiMap[String]): Unit = request.setQueryParameters(queryParameters)

  override def setContentParameters(contentParameters: MultiMap[String]): Unit = request.setContentParameters(contentParameters)

  override def resetParameters(): Unit = request.resetParameters()

  override def getPathInfo: String = request.getPathInfo

  override def getPathTranslated: String = request.getPathTranslated

  override def getProtocol: String = request.getProtocol

  override def getHttpVersion: HttpVersion = request.getHttpVersion

  override def getQueryEncoding: String = request.getQueryEncoding

  override def getQueryString: String = request.getQueryString

  @throws[IOException]
  override def getReader: BufferedReader = request.getReader

  override def getRealPath(path: String): String = request.getRealPath(path)

  override def getRemoteInetSocketAddress: InetSocketAddress = request.getRemoteInetSocketAddress

  override def getRemoteAddr: String = request.getRemoteAddr

  override def getRemoteHost: String = request.getRemoteHost

  override def getRemotePort: Int = request.getRemotePort

  override def getRequestDispatcher(path: String): RequestDispatcher = request.getRequestDispatcher(path)

  override def getRequestedSessionId: String = request.getRequestedSessionId

  override def getRequestURI: String = request.getRequestURI

  override def getRequestURL: StringBuffer = request.getRequestURL

  override def getResponse: Response = request.getResponse

  override def getRootURL: java.lang.StringBuilder = request.getRootURL

  override def getScheme: String = request.getScheme

  override def getServerName: String = request.getServerName

  override def getServerPort: Int = request.getServerPort

  override def getServletContext: ServletContext = request.getServletContext

  override def getServletName: String = request.getServletName

  override def getServletPath: String = request.getServletPath

  override def getServletResponse: ServletResponse = request.getServletResponse

  override def changeSessionId: String = request.changeSessionId

  override def getSession: HttpSession = request.getSession

  override def getSession(create: Boolean): HttpSession = request.getSession(create)

  override def getSessionHandler: SessionHandler = request.getSessionHandler

  override def getTimeStamp: Long = request.getTimeStamp

  override def getHttpURI: HttpURI = request.getHttpURI

  override def getOriginalURI: String = request.getOriginalURI

  override def setHttpURI(uri: HttpURI): Unit = request.setHttpURI(uri)

  override def getUserIdentity: UserIdentity = request.getUserIdentity

  override def getResolvedUserIdentity: UserIdentity = request.getResolvedUserIdentity

  override def getUserIdentityScope: UserIdentity.Scope = request.getUserIdentityScope

  override def getUserPrincipal: Principal = request.getUserPrincipal

  override def isHandled: Boolean = request.isHandled

  override def isAsyncStarted: Boolean = request.isAsyncStarted

  override def isAsyncSupported: Boolean = request.isAsyncSupported

  override def isRequestedSessionIdFromCookie: Boolean = request.isRequestedSessionIdFromCookie

  override def isRequestedSessionIdFromUrl: Boolean = request.isRequestedSessionIdFromUrl

  override def isRequestedSessionIdFromURL: Boolean = request.isRequestedSessionIdFromURL

  override def isRequestedSessionIdValid: Boolean = request.isRequestedSessionIdValid

  override def isSecure: Boolean = request.isSecure

  override def setSecure(secure: Boolean): Unit = request.setSecure(secure)

  override def isUserInRole(role: String): Boolean = request.isUserInRole(role)

  override def setMetaData(request: MetaData.Request): Unit = this.request.setMetaData(request)

  override def getMetaData: MetaData.Request = request.getMetaData

  override def hasMetaData: Boolean = request.hasMetaData

  override def removeAttribute(name: String): Unit = request.removeAttribute(name)

  override def removeEventListener(listener: jutil.EventListener): Unit = request.removeEventListener(listener)

  override def setAsyncSupported(supported: Boolean, source: Any): Unit = request.setAsyncSupported(supported, source)

  override def setAttribute(name: String, value: Any): Unit = request.setAttribute(name, value)

  override def setAttributes(attributes: Attributes): Unit = request.setAttributes(attributes)

  override def setAuthentication(authentication: Authentication): Unit = request.setAuthentication(authentication)

  @throws[UnsupportedEncodingException]
  override def setCharacterEncoding(encoding: String): Unit = request.setCharacterEncoding(encoding)

  override def setCharacterEncodingUnchecked(encoding: String): Unit = request.setCharacterEncodingUnchecked(encoding)

  override def setContentType(contentType: String): Unit = request.setContentType(contentType)

  override def setContext(context: ContextHandler#Context, pathInContext: String): Unit = request.setContext(context, pathInContext)

  override def takeNewContext: Boolean = request.takeNewContext

  override def setCookies(cookies: Array[Cookie]): Unit = request.setCookies(cookies)

  override def setDispatcherType(`type`: DispatcherType): Unit = request.setDispatcherType(`type`)

  override def setHandled(h: Boolean): Unit = request.setHandled(h)

  override def setMethod(method: String): Unit = request.setMethod(method)

  override def isHead: Boolean = request.isHead

  override def setQueryEncoding(queryEncoding: String): Unit = request.setQueryEncoding(queryEncoding)

  override def setRemoteAddr(addr: InetSocketAddress): Unit = request.setRemoteAddr(addr)

  override def setRequestedSessionId(requestedSessionId: String): Unit = request.setRequestedSessionId(requestedSessionId)

  override def setRequestedSessionIdFromCookie(requestedSessionIdCookie: Boolean): Unit = request.setRequestedSessionIdFromCookie(requestedSessionIdCookie)

  override def setSession(session: HttpSession): Unit = request.setSession(session)

  override def setSessionHandler(sessionHandler: SessionHandler): Unit = request.setSessionHandler(sessionHandler)

  override def setTimeStamp(ts: Long): Unit = request.setTimeStamp(ts)

  override def setUserIdentityScope(scope: UserIdentity.Scope): Unit = request.setUserIdentityScope(scope)

  @throws[IllegalStateException]
  override def startAsync: AsyncContext = request.startAsync

  @throws[IllegalStateException]
  override def startAsync(servletRequest: ServletRequest, servletResponse: ServletResponse): AsyncContext = request.startAsync(servletRequest, servletResponse)

  override def toString: String = request.toString

  @throws[IOException]
  @throws[ServletException]
  override def authenticate(response: HttpServletResponse): Boolean = request.authenticate(response)

  @throws[IOException]
  @throws[ServletException]
  override def getPart(name: String): Part = request.getPart(name)

  @throws[IOException]
  @throws[ServletException]
  override def getParts: jutil.Collection[Part] = request.getParts

  @throws[ServletException]
  override def login(username: String, password: String): Unit = request.login(username, password)

  @throws[ServletException]
  override def logout(): Unit = request.logout()

  override def mergeQueryParameters(oldQuery: String, newQuery: String): Unit = request.mergeQueryParameters(oldQuery, newQuery)

  @throws[IOException]
  @throws[ServletException]
  override def upgrade[T <: HttpUpgradeHandler](handlerClass: Class[T]): T = request.upgrade(handlerClass)

  override def getRequestId: String = ???

  override def getProtocolRequestId: String = ???

  override def getServletConnection: ServletConnection = ???
}
