/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.views.TeamView;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/teams")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TeamResource {
    private final PermissionChecker permissions;
    private final ReleaseActorService releaseActorService;
    private final TeamService teamService;
    private final TeamMemberViewConverter teamMemberViewConverter;

    @Autowired
    public TeamResource(PermissionChecker permissions, ReleaseActorService releaseActorService, TeamService teamService, TeamMemberViewConverter teamMemberViewConverter) {
        this.permissions = permissions;
        this.releaseActorService = releaseActorService;
        this.teamService = teamService;
        this.teamMemberViewConverter = teamMemberViewConverter;
    }

    @GET
    @Timed
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}")
    public List<TeamView> getTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId) {
        this.permissions.checkViewTeams(teamContainerId);
        return this.teamService.getEffectiveTeams(teamContainerId).stream().map(team -> new TeamView((Team)team, this.teamMemberViewConverter)).sorted(Comparator.comparing(TeamView::getTeamName)).collect(Collectors.toList());
    }

    @POST
    @Timed
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}/new")
    public TeamView addTeam(@PathParam(value="teamContainerId") @IdParam String teamContainerId, TeamView teamView) {
        this.permissions.checkEditTeams(teamContainerId, Collections.singletonList(teamView));
        Checks.checkArgument((boolean)this.isReleaseAdminTeamPresent(teamContainerId, Collections.singletonList(teamView)), (String)"Cannot add team %s in %s, missing 'Release Admin' team", (Object[])new Object[]{teamView, teamContainerId});
        Team team = teamView.toTeam();
        team = Ids.isReleaseId((String)teamContainerId) ? this.releaseActorService.addTeam(teamContainerId, team) : this.teamService.addTeam(teamContainerId, team);
        return new TeamView(team, this.teamMemberViewConverter);
    }

    @DELETE
    @Timed
    @Path(value="/{teamId:.*Team[^/-]*}")
    public void deleteTeam(@PathParam(value="teamId") @IdParam String teamId) {
        String teamContainerId = Ids.getParentId((String)teamId);
        this.permissions.checkDeleteTeams(teamContainerId, Collections.singletonList(teamId));
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.releaseActorService.deleteTeam(teamId);
        } else {
            this.teamService.deleteTeam(teamContainerId, teamId);
        }
    }

    @DELETE
    @Timed
    @Path(value="/{teamContainerId:.*(Release|Folder)[^/-]*}")
    public void deleteAllOwnTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId) {
        this.permissions.checkDeleteOwnTeams(teamContainerId);
        if (Ids.isReleaseId((String)teamContainerId)) {
            this.releaseActorService.updateTeams(teamContainerId, Collections.emptyList());
        } else {
            this.teamService.deleteTeamsFromPlatform(teamContainerId);
        }
    }

    @PUT
    @Timed
    @Path(value="{teamId:.*Team[^/-]*}")
    public TeamView updateTeam(@PathParam(value="teamId") @IdParam String teamId, TeamView newTeam) {
        String teamContainerId = Ids.getParentId((String)teamId);
        this.permissions.checkEditTeams(teamContainerId, Collections.singletonList(newTeam));
        Team team = Ids.isReleaseId((String)teamContainerId) ? this.releaseActorService.updateTeam(teamId, newTeam.toTeam()) : this.teamService.updateTeam(teamId, newTeam.toTeam());
        return new TeamView(team, this.teamMemberViewConverter);
    }

    @POST
    @Timed
    @Path(value="{teamContainerId:.*(Release|Folder)[^/-]*}")
    public List<TeamView> updateTeams(@PathParam(value="teamContainerId") @IdParam String teamContainerId, List<TeamView> updatedListOfTeams) {
        this.permissions.checkEditTeams(teamContainerId, updatedListOfTeams);
        Checks.checkArgument((boolean)this.isReleaseAdminTeamPresent(teamContainerId, updatedListOfTeams), (String)"Cannot save teams %s in %s, missing 'Release Admin' team", (Object[])new Object[]{updatedListOfTeams, teamContainerId});
        List<Team> submittedTeams = updatedListOfTeams.stream().map(TeamView::toTeam).collect(Collectors.toList());
        List<Team> updatedTeams = Ids.isReleaseId((String)teamContainerId) ? this.releaseActorService.updateTeams(teamContainerId, submittedTeams) : this.teamService.saveTeamsToPlatform(teamContainerId, submittedTeams);
        return updatedTeams.stream().map(team -> new TeamView((Team)team, this.teamMemberViewConverter)).collect(Collectors.toList());
    }

    private boolean isReleaseAdminTeamPresent(String containerId, List<TeamView> updatedListOfTeams) {
        return this.isReleaseAdminTeamPresent(this.getTeams(containerId)) || this.isReleaseAdminTeamPresent(updatedListOfTeams);
    }

    private boolean isReleaseAdminTeamPresent(List<TeamView> teamViewList) {
        return teamViewList.stream().anyMatch(team -> "Release Admin".equals(team.getTeamName()));
    }
}

