package com.xebialabs.xlrelease.security.authentication.policy

import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.security.authentication.PersonalAuthenticationToken
import grizzled.slf4j.Logging
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

@Component
class PATUserProfileCreationPolicy extends UserProfileCreationPolicy with Logging {

  override def order(): Int = 30

  override def policyApplies(authentication: Authentication): Boolean = authentication.isInstanceOf[PersonalAuthenticationToken]

  override def createProfile(authentication: Authentication): UserProfile = null //For all personal authentication tokens, user profile should be there already

}
