package com.xebialabs.xlrelease.security.authentication.policy

import com.xebialabs.xlrelease.security.authentication.{PersonalAuthenticationToken, RunnerAuthenticationToken}
import org.springframework.security.core.Authentication
import org.springframework.stereotype.Component

@Component
class PATUserGroupMembershipCreationPolicy extends UserGroupMembershipCreationPolicy {

  override def order(): Int = 10

  override def policyApplies(authentication: Authentication): Boolean = {
    null != authentication && (authentication.isInstanceOf[RunnerAuthenticationToken] || authentication.isInstanceOf[PersonalAuthenticationToken])
  }

  override def updateUserGroupMembership(authentication: Authentication): Unit = {
    // no-op
  }
}
