package com.xebialabs.xlrelease.security

import com.xebialabs.deployit.engine.api.dto.{Ordering, Paging}
import com.xebialabs.deployit.security.Role
import com.xebialabs.xlrelease.security.ReleaseRoleService._
import com.xebialabs.xlrelease.views.RolePrincipalsView
import org.springframework.data.domain.{Page, Pageable}

import java.util
import scala.annotation.varargs

trait ReleaseRoleService {

  def getGlobalRoles(): util.List[Role] = this.getGlobalRoles(null, null, null)

  def getGlobalRoles(rolePattern: String, paging: Paging, order: Ordering): util.List[Role]

  def getGlobalRolePrincipalViews(pageable: Pageable): Page[RolePrincipalsView]

  def getGlobalRole(roleName: String): Option[Role]

  def getGlobalRolePrincipalsView(roleName: String): RolePrincipalsView

  def globalRoleExists(roleName: String): Boolean

  @varargs
  def create(roles: Role*): Unit = create(null, roles: _*)

  @varargs
  def create(onConfigurationItem: String, roles: Role*): Unit

  @varargs
  def update(roles: Role*): Unit = update(null, roles: _*)

  @varargs
  def update(onConfigurationItem: String, roles: Role*): Unit

  def renameGlobalRole(oldName: String, newName: String): Unit

  def deleteGlobalRole(roleName: String): Unit

  @varargs
  def createGlobalRoleAndRolePermissions(requests: RoleCreateRequest*): Unit

  @varargs
  def updateGlobalRoleAndRolePermissions(requests: RoleUpdateRequest*): Unit

  @varargs
  def createGlobalRolePermissions(rolePermissions: RolePermissionCreateRequest*): Unit

  @varargs
  def updateGlobalRolePermissions(rolePermissions: RolePermissionUpdateRequest*): Unit

  def getAllGlobalRolePermissions(): GlobalRolePermissions

  def getRolePermissions(roleId: RoleId): PermissionNames
}

object ReleaseRoleService {
  type RoleId = String
  type PermissionNames = util.Set[String]
  type GlobalRolePermissions = util.Map[RoleId, PermissionNames]

  case class RoleCreateRequest(roleName: String, rolePrincipals: util.Set[String], rolePermissions: util.Set[String])

  case class RoleUpdateRequest(roleId: String, roleName: String, rolePrincipals: util.Set[String], rolePermissions: util.Set[String])

  sealed trait RolePermissionChange {
    def roleName: String
    def permissionNames: util.Set[String]
  }

  case class RolePermissionCreateRequest(roleId: String, roleName: String, permissionNames: util.Set[String]) extends RolePermissionChange

  case class RolePermissionUpdateRequest(roleId: String, roleName: String, permissionNames: util.Set[String]) extends RolePermissionChange

}
