package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Personal access tokens",
  description = "Release will use this setting to enable Personal Access Tokens for users that log in through SSO / OIDC. " +
    "It allows you to also control the maximum token expiry duration."
)
class PersonalAccessTokenFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(defaultValue = "Stable",
    isTransient = true,
    hidden = true,
    readonly = true)
  var category: String = _

  @BeanProperty
  @XLProperty(defaultValue = "user-security", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "general-settings", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/personal-access-tokens-based-authentication.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "20", hidden = true)
  var weight: Integer = _

  @BeanProperty
  @XLProperty(label = "Enable Personal Access Tokens for SSO Users",
    description = "When checked, Personal Access Tokens support is enabled for SSO Users like OIDC. " +
      "The token will remain active when a user is deleted in the external system.",
    category = "input",
    defaultValue = "true")
  var enabled: Boolean = _
}
