package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty


@Metadata(label = "System throughput",
  description = "Depending on your usage profile, changing the internal scheduling of jobs may improve performance. Consult Digital.ai Support before changing this setting.")
class JobSchedulerFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Job execution strategies", category = "input", nested = true,
    description = "An algorithm for job (task) execution that determines whether jobs should be performed immediately or delayed, aiming to enhance the overall system throughput",
  )
  var strategy: JobSchedulerStrategySettings = _

  @BeanProperty
  @XLProperty(defaultValue = "board", hidden = true)
  var displayIcon: String = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @BeanProperty
  @XLProperty(defaultValue = "how-to/configure-experimental-settings.html", hidden = true)
  var documentationPage: String = _

  @XLProperty(defaultValue = "10", hidden = true)
  var weight: Integer = _

}
