package com.xebialabs.deployit.plumbing;

import com.xebialabs.xlrelease.config.XlrConfig;
import jakarta.servlet.*;
import org.eclipse.jetty.server.Request;

import java.io.IOException;

public class MultipartFilter implements Filter {

    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"),
            XlrConfig.getInstance().server().upload().maxSizeBytes(), -1L, 0);

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
            request.setAttribute(Request.__MULTIPART_CONFIG_ELEMENT, MULTI_PART_CONFIG);
        }
        chain.doFilter(request, response);
    }
}
