/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImporter;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.UploadService;
import com.xebialabs.xlrelease.views.AttachmentView;
import com.xebialabs.xlrelease.views.ImportResult;
import com.xebialabs.xlrelease.views.TemplateLogoView;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/upload")
@Consumes(value={"multipart/form-data"})
@Produces(value={"text/html; charset=utf-8"})
@Controller
public class UploadResource {
    private static final String JSON_SUFFIX = ".json";
    private PermissionChecker permissionChecker;
    private TemplateImporter templateImporter;
    private UploadService uploadService;

    @Autowired
    public UploadResource(PermissionChecker permissionChecker, TemplateImporter templateImporter, UploadService uploadService) {
        this.permissionChecker = permissionChecker;
        this.templateImporter = templateImporter;
        this.uploadService = uploadService;
    }

    public UploadResource() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Timed
    @Path(value="templates/zip")
    public List<ImportResult> importTemplates(@Context HttpServletRequest request, @QueryParam(value="folderId") String folderId) throws IOException {
        List<ImportResult> list;
        if (Ids.isNullId((String)folderId)) {
            this.permissionChecker.check(XLReleasePermissions.CREATE_TEMPLATE);
        } else {
            this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        }
        Optional<Part> templateInformation = request.getParts().stream().filter(this::filterFilePart).findFirst();
        if (!templateInformation.isPresent()) throw new IllegalArgumentException("Missing file");
        Part template = templateInformation.get();
        boolean isJson = template.getName().toLowerCase().endsWith(JSON_SUFFIX);
        boolean isDsl = template.getName().toLowerCase().endsWith(".zip");
        InputStream is = template.getInputStream();
        try {
            list = this.templateImporter.importTemplate(is, new TemplateImportContext(folderId, isJson, false, isDsl, null));
            if (is == null) return list;
        }
        catch (Throwable throwable) {
            try {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ServletException e) {
                throw new BadRequestException("Expected multipart content");
            }
        }
        is.close();
        return list;
    }

    @POST
    @Timed
    @Path(value="attachment/{ciId}")
    public List<AttachmentView> addAttachment(@PathParam(value="ciId") @IdParam String ciId, @Context HttpServletRequest request) throws IOException {
        this.permissionChecker.checkEditAttachment(ciId);
        try {
            List<AttachmentView> returnedViews = this.uploadService.addAttachment(ciId, request.getParts().stream().filter(this::filterFilePart).iterator()).stream().map(AttachmentView::new).toList();
            if (returnedViews.isEmpty()) {
                throw new BadRequestException("Expected file upload");
            }
            return returnedViews;
        }
        catch (ServletException e) {
            throw new BadRequestException("Expected multipart content");
        }
        catch (IllegalStateException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    @POST
    @Timed
    @Path(value="logo/{templateId:.*Release[^/-]*}")
    public TemplateLogoView addLogo(@PathParam(value="templateId") @IdParam String templateId, @Context HttpServletRequest request) throws IOException {
        this.permissionChecker.check(XLReleasePermissions.EDIT_TEMPLATE, templateId);
        request.setAttribute("org.eclipse.jetty.multipartConfig", (Object)new MultipartConfigElement(System.getProperty("java.io.tmpdir"), (long)TemplateLogo.getDefaultMaxLogoSize(), -1L, 0));
        try {
            int logoCount = request.getParts().stream().filter(this::filterFilePart).toList().size();
            if (logoCount > 1) {
                throw new BadRequestException("Can not upload more than one file");
            }
            if (logoCount == 0) {
                throw new BadRequestException("No logo file provided");
            }
            return new TemplateLogoView(this.uploadService.addLogo(templateId, request.getParts().stream().filter(this::filterFilePart).iterator()));
        }
        catch (ServletException | IllegalArgumentException e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private Boolean filterFilePart(Part part) {
        return part.getSubmittedFileName() != null && !part.getSubmittedFileName().isEmpty();
    }
}

