package com.xebialabs.xlrelease.service

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.xlrelease.api.v1.forms.{ReleaseOrderMode, ReleasesFilters}
import com.xebialabs.xlrelease.domain.status.ReleaseStatus
import com.xebialabs.xlrelease.domain.utils.ReleaseIdInDatabase
import com.xebialabs.xlrelease.domain.{Release, ReleaseKind}
import com.xebialabs.xlrelease.reports.filters.ReportFilter
import com.xebialabs.xlrelease.repository.Page
import com.xebialabs.xlrelease.search._
import com.xebialabs.xlrelease.security.XLReleasePermissions.VIEW_TEMPLATE
import com.xebialabs.xlrelease.views.{ReleaseOverviewResultsView, TemplateFilters, TemplateOverviewResultsView}

import java.util.{Date, List => JList}
import scala.annotation.varargs

trait ReleaseSearchService {
  val DEFAULT_NUMBER_OF_RELEASES_PER_PAGE: Long = 15L
  val DEFAULT_RELEASE_LOAD_DEPTH: Int = 1

  def count(releasesFilters: ReleasesFilters): ReleaseCountResults

  def getReleaseDateRange(releasesFilters: ReleasesFilters): ReleaseDateRangeResults

  def fullSearch(releasesFilters: ReleasesFilters, currentPage: Page, archivePage: Page): ReleaseFullSearchResult

  def search(releaseFilter: ReleasesFilters, offset: Long, numberPerPage: Long, pageIsOffset: Boolean): ReleaseSearchResult =
    search(releaseFilter, offset, numberPerPage, pageIsOffset, DEFAULT_RELEASE_LOAD_DEPTH, filterOnPermissions = true, includeOriginTemplateData = false)

  def search(releasesFilters: ReleasesFilters, page: Long, numberByPage: Long): ReleaseSearchResult =
    search(releasesFilters, page, numberByPage, DEFAULT_RELEASE_LOAD_DEPTH)

  def search(releasesFilters: ReleasesFilters, page: Long, numberByPage: Long, depth: Int): ReleaseSearchResult =
    search(releasesFilters, page, numberByPage, pageIsOffset = false, depth, filterOnPermissions = true, includeOriginTemplateData = false)

  def search(releasesFilters: ReleasesFilters, page: Long, numberByPage: Long, depth: Int, includeOriginTemplateData: Boolean): ReleaseSearchResult =
    search(releasesFilters, page, numberByPage, pageIsOffset = false, depth, filterOnPermissions = true, includeOriginTemplateData)

  def search(releasesFilters: ReleasesFilters,
             page: Long,
             numberByPage: Long,
             pageIsOffset: Boolean = false,
             depth: Int,
             filterOnPermissions: Boolean,
             includeOriginTemplateData: Boolean): ReleaseSearchResult

  def releasesOverview(releasesFilters: ReleasesFilters,
                       page: Long,
                       numberByPage: Long): ReleaseOverviewResultsView

  def templatesOverview(templateFilters: TemplateFilters, page: Long, numberByPage: Long): TemplateOverviewResultsView


  /*
   * Boolean - true if release is found in archived database
   */
  def searchAllIdsWithoutPermissionsCheck(filters: Seq[ReportFilter],
                                          order: Option[ReleaseOrderMode],
                                          page: Option[Long] = None,
                                          numberByPage: Option[Long] = None
                                         ): Seq[ReleaseIdInDatabase]

  def searchReleasesByReleaseIds(releaseIds: Seq[String]): Seq[Release]

  def searchTemplates(templateFilters: TemplateFilters, page: Long, numberByPage: Long, depth: Int, enforcePermission: Boolean = true): ReleaseSearchResult

  def searchReleasesByTitle(releaseTitle: String, releaseKind: ReleaseKind, page: Long, numberByPage: Long, depth: Int): JList[Release]

  @varargs
  def findAllReleaseIdsAndTitlesByStatus(statuses: ReleaseStatus*): Map[String, String]

  def findAllTemplateIdsAndTitles(page: Long, numberByPage: Long, folderId: Option[String], matchTemplate: Option[String]): PlanItemSearchResult =
    findAllTemplateIdsAndTitles(page, numberByPage, folderId, VIEW_TEMPLATE, matchTemplate)

  def findAllTemplateIdsAndTitles(page: Long, numberByPage: Long, folderId: Option[String], permission: Permission, matchTemplate: Option[String]): PlanItemSearchResult

  def findTemplateTitleById(templateId: String): PlanItemSearchResult =
    findTemplateTitleById(VIEW_TEMPLATE, templateId)

  def findTemplateTitleById(permission: Permission, templateId: String): PlanItemSearchResult

  def findNonArchivedExpiredReleaseIds(date: Date, pageSize: Int): Seq[String]

  def getTitle(releaseId: String): Option[String]

  def findAllTemplateIds: JList[String]

  def findAllActiveReleaseIds: JList[String]

  def findAllPendingReleaseIds: JList[String]

  def existsByName(candidateName: String): Boolean

  def countReleases(filters: Seq[ReportFilter]): ReleaseCountResults
}
