package com.xebialabs.xlrelease.features.settings

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.configuration.FeatureSettings
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import scala.beans.BeanProperty

@Metadata(label = "Plugin development",
  description = "Flag to control server instance used for development purpose."
)
class PluginDevelopmentFeatureSettings extends FeatureSettings {
  @BeanProperty
  @XLProperty(label = "Enable reload of Jython modules without system restart",
    description = "Not recommended for production environment.",
    category = "input",
    defaultValue = "false")
  var enableJythonModuleReload: Boolean = _

  @BeanProperty
  @XLProperty(defaultValue = "experimental", hidden = true)
  var displayPage: String = _

  @XLProperty(defaultValue = "40", hidden = true)
  var weight: Integer = _

  @BeanProperty
  @XLProperty(defaultValue = "#", hidden = true)
  var documentationPage: String = _
}
