package com.xebialabs.deployit.plumbing;

import java.io.IOException;
import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletResponse;

public class XssSecurityHeadersFilter implements Filter {

    private static final String X_XSS_PROTECTION_HEADER = "X-XSS-Protection";
    private static final String X_XSS_HEADER_VALUE = "1; mode=block";

    private static final String CONTENT_TYPE_OPTIONS_HEADER = "X-Content-Type-Options";
    private static final String CONTENT_TYPE_OPTIONS_DISABLED_VALUE = "nosniff";

    @Override
    public void init(final FilterConfig filterConfig) {}

    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        ((HttpServletResponse) response).setHeader(X_XSS_PROTECTION_HEADER, X_XSS_HEADER_VALUE);
        ((HttpServletResponse) response).setHeader(CONTENT_TYPE_OPTIONS_HEADER, CONTENT_TYPE_OPTIONS_DISABLED_VALUE);
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {}

}
