package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.ServerConfiguration
import com.xebialabs.deployit.security.UserService
import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization
import com.xebialabs.xlrelease.security.XLReleasePermissions
import com.xebialabs.xlrelease.service.UserProfileService
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

// This is not a spring bean - UpgraderHelper will autowire its dependencies
class UserInitializer @Autowired()(serverConfiguration: ServerConfiguration,
                                   userService: UserService,
                                   userProfileService: UserProfileService)
  extends RepositoryInitialization with Logging with ClassNameToString {

  override def getComponent: String = XL_RELEASE_COMPONENT

  override def doInitialize(): Unit = {
    logger.debug("Initializing admin user")
    createAdminUser()
  }

  private def createAdminUser(): Unit = {
    val userId = XLReleasePermissions.ADMIN_USERNAME
    val password = serverConfiguration.getAdminPassword
    userService.create(userId, password)
    userProfileService.ensureCreated(userId)
  }

}
