package com.xebialabs.xlrelease.domain.tasks.script;

import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.tasks.task.DefaultTaskUpdater;

import java.util.Set;

@Component
public class ScriptTaskUpdater extends DefaultTaskUpdater {

    @Override
    public Class<? extends Task> getTaskClass() {
        return ScriptTask.class;
    }

    private void updateScript(ScriptTask original, ScriptTask updated) {
        original.setScript(updated.getScript());
        original.setIgnoreScriptVariableInterpolation(updated.isScriptInterpolationOff());
    }

    @Override
    public Changes update(Task original, Task updated, Set<TaskUpdateDirective> updateDirectives) {
        Changes changes = super.update(original, updated, updateDirectives);
        if (hasDirectiveToUpdateAllProperties(original, updateDirectives) ||
            updateDirectives.contains(TaskUpdateDirective.UPDATE_TASK_SCRIPT)
        ) {
            changes.update(original);
            updateScript((ScriptTask) original, (ScriptTask) updated);
        }
        return changes;
    }
}
