/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.api.v1.views.TeamMemberView;
import com.xebialabs.xlrelease.builder.TeamBuilder;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.views.converters.TeamMemberViewConverter;
import java.util.List;
import java.util.stream.Collectors;

public class TeamView {
    @JsonSerialize(using=DomainIdSerializer.class)
    @JsonDeserialize(using=DomainIdDeserializer.class)
    private String id;
    private String teamName;
    private List<TeamMemberView> members = Lists.newArrayList();
    private List<String> permissions = Lists.newArrayList();
    private boolean systemTeam;

    public TeamView() {
    }

    public TeamView(Team team, TeamMemberViewConverter teamMemberViewConverter) {
        this.id = team.getId();
        this.teamName = team.getTeamName();
        this.members.addAll(team.getMembers().stream().map(t -> teamMemberViewConverter.toView((String)t, TeamMemberView.MemberType.PRINCIPAL)).collect(Collectors.toList()));
        this.members.addAll(team.getRoles().stream().map(role -> teamMemberViewConverter.toView((String)role, TeamMemberView.MemberType.ROLE)).collect(Collectors.toList()));
        this.permissions = team.getPermissions();
        this.systemTeam = team.isSystemTeam();
    }

    public String getId() {
        return this.id;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public List<TeamMemberView> getMembers() {
        return this.members;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public boolean isSystemTeam() {
        return this.systemTeam;
    }

    public Team toTeam() {
        List principals = this.members.stream().filter(member -> member.getType() == TeamMemberView.MemberType.PRINCIPAL).map(TeamMemberView::getName).collect(Collectors.toList());
        List roles = this.members.stream().filter(member -> member.getType() == TeamMemberView.MemberType.ROLE).map(TeamMemberView::getName).collect(Collectors.toList());
        return TeamBuilder.newTeam().withId(this.id).withTeamName(this.teamName).withMembers(principals).withRoles(roles).withPermissions(this.permissions).build();
    }
}

