/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import akka.actor.ActorRef;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.JobConfirmationActor;
import com.xebialabs.xlrelease.actors.JobConfirmed;
import com.xebialabs.xlrelease.actors.MonitorJobConfirmation;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.features.JobSchedulerFeature$;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.DefaultJobQueue;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobProvider;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRunnerQueue;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.support.akka.spring.SpringExtension;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.slf4j.Marker;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Primary
@Component
@ScalaSignature(bytes="\u0006\u0005\t}c\u0001\u0002\u0012$\u00011B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u0002\u0011)\u0019!C\u0001\u0015\"A\u0011\u000b\u0001B\u0001B\u0003%1\n\u0003\u0005S\u0001\t\u0005\t\u0015!\u0003T\u0011!I\u0006A!A!\u0002\u0013Q\u0006\"\u00023\u0001\t\u0003)\u0007\u0002C6\u0001\u0011\u000b\u0007I\u0011\u00027\t\u000fQ\u0004!\u0019!C\u0005k\"9\u0011q\u0007\u0001!\u0002\u00131\bbBA\u001d\u0001\u0011\u0005\u00131\b\u0005\b\u0003'\u0002A\u0011IA+\u0011\u001d\ty\u0006\u0001C#\u0003CBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002,\u0002!I!!,\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u0011Q\u0018\u0001\u0005B\u0005}\u0006bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003'\u0004A\u0011BAk\u0011\u001d\t9\u000f\u0001C!\u0003SDq!!<\u0001\t\u0003\ny\u000fC\u0004\u0002t\u0002!\t%!>\t\u000f\u0005e\b\u0001\"\u0011\u0002|\"9\u0011q \u0001\u0005B\t\u0005\u0001b\u0002B\u0003\u0001\u0011\u0005#q\u0001\u0005\b\u0005\u0017\u0001A\u0011\tB\u0007\u0011\u001d\u0011y\u0001\u0001C!\u0005\u001bAqA!\u0005\u0001\t\u0003\u0012\u0019\u0002C\u0004\u0003\u0016\u0001!\tEa\u0006\t\u000f\t}\u0001\u0001\"\u0003\u0003\u000e!9!\u0011\u0005\u0001\u0005\n\t\r\u0002b\u0002B\u0014\u0001\u0011%!\u0011\u0006\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005k\u0011qcQ1qC\nLG.\u001b;z\u0003^\f'/\u001a&pEF+X-^3\u000b\u0005\u0011*\u0013!C:dQ\u0016$W\u000f\\3s\u0015\t1s%A\u0005yYJ,G.Z1tK*\u0011\u0001&K\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AK\u0001\u0004G>l7\u0001A\n\u0007\u00015\u001atGO\u001f\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!T'D\u0001$\u0013\t14E\u0001\u0005K_\n\fV/Z;f!\t!\u0004(\u0003\u0002:G\tq!+\u001e8oKJ\u0014VmZ5tiJL\bC\u0001\u001b<\u0013\ta4EA\u0006K_\n\u0004&o\u001c<jI\u0016\u0014\bC\u0001 D\u001b\u0005y$B\u0001!B\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0011\u0015\u0001C4sSjTH.\u001a3\n\u0005\u0011{$a\u0002'pO\u001eLgnZ\u0001\tU>\u0014\u0017+^3vKB\u0011AgR\u0005\u0003\u0011\u000e\u0012q\u0002R3gCVdGOS8c#V,W/Z\u0001\u0014U>\u0014'+\u001e8oKJ\u0014V\r]8tSR|'/_\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*J\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001)N\u0005MQuN\u0019*v]:,'OU3q_NLGo\u001c:z\u0003QQwN\u0019*v]:,'OU3q_NLGo\u001c:zA\u0005\u0019\"/\u001a7fCN,\u0017i\u0019;peN+'O^5dKB\u0011AkV\u0007\u0002+*\u0011a+J\u0001\u0007C\u000e$xN]:\n\u0005a+&a\u0005*fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0017aD:qe&tw-\u0012=uK:\u001c\u0018n\u001c8\u0011\u0005m\u0013W\"\u0001/\u000b\u0005us\u0016AB:qe&twM\u0003\u0002`A\u0006!\u0011m[6b\u0015\t\tW%A\u0004tkB\u0004xN\u001d;\n\u0005\rd&aD*qe&tw-\u0012=uK:\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\u00151w\r[5k!\t!\u0004\u0001C\u0003F\r\u0001\u0007a\tC\u0003J\r\u0001\u00071\nC\u0003S\r\u0001\u00071\u000bC\u0003Z\r\u0001\u0007!,\u0001\u0005bGR|'OU3g+\u0005i\u0007C\u00018s\u001b\u0005y'B\u00019r\u0003\u0015\t7\r^8s\u0015\u0005y\u0016BA:p\u0005!\t5\r^8s%\u00164\u0017\u0001\u0004:v]:,'/U;fk\u0016\u001cX#\u0001<\u0011\r]t\u0018\u0011AA\u0019\u001b\u0005A(BA={\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wr\fA!\u001e;jY*\tQ0\u0001\u0003kCZ\f\u0017BA@y\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003\u0007\tYC\u0004\u0003\u0002\u0006\u0005\u0015b\u0002BA\u0004\u0003?qA!!\u0003\u0002\u001c9!\u00111BA\r\u001d\u0011\ti!a\u0006\u000f\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005,\u0003\u0019a$o\\8u}%\t!&\u0003\u0002)S%\u0011aeJ\u0005\u0004\u0003;)\u0013A\u0002:v]:,'/\u0003\u0003\u0002\"\u0005\r\u0012A\u00023p[\u0006LgNC\u0002\u0002\u001e\u0015JA!a\n\u0002*\u00059\u0001/Y2lC\u001e,'\u0002BA\u0011\u0003GIA!!\f\u00020\tA!+\u001e8oKJLEM\u0003\u0003\u0002(\u0005%\u0002c\u0001\u001b\u00024%\u0019\u0011QG\u0012\u0003\u001d){'MU;o]\u0016\u0014\u0018+^3vK\u0006i!/\u001e8oKJ\fV/Z;fg\u0002\n\u0011C]3hSN$XM\u001d&pEJ+hN\\3s)\u0011\ti$a\u0011\u0011\u00079\ny$C\u0002\u0002B=\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002F)\u0001\r!a\u0012\u0002\u0013)|'MU;o]\u0016\u0014\b\u0003BA%\u0003\u001fj!!a\u0013\u000b\t\u0005u\u0011Q\n\u0006\u0004\u0003C)\u0013\u0002BA)\u0003\u0017\u0012\u0011BS8c%Vtg.\u001a:\u0002'Ut'/Z4jgR,'OS8c%Vtg.\u001a:\u0015\t\u0005]\u0013Q\f\t\u0004]\u0005e\u0013bAA._\t!QK\\5u\u0011\u001d\t)e\u0003a\u0001\u0003\u000f\n1aZ3u)\u0011\t\u0019'a\u001c\u0011\u000b9\n)'!\u001b\n\u0007\u0005\u001dtF\u0001\u0004PaRLwN\u001c\t\u0004i\u0005-\u0014bAA7G\t\u0019!j\u001c2\t\u000f\u0005ED\u00021\u0001\u0002\u0002\u0005A!/\u001e8oKJLE\rK\u0002\r\u0003k\u0002B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003wz\u0013AC1o]>$\u0018\r^5p]&!\u0011qPA=\u0005\u001d!\u0018-\u001b7sK\u000e\fa\u0002Z3mCf|%OU3tKJ4X\r\u0006\u0004\u0002d\u0005\u0015\u0015\u0011\u0016\u0005\b\u0003\u000fk\u0001\u0019AAE\u0003\rQwN\u0019\u0019\u0005\u0003\u0017\u000b)\nE\u00035\u0003\u001b\u000b\t*C\u0002\u0002\u0010\u000e\u0012q\u0001V1tW*{'\r\u0005\u0003\u0002\u0014\u0006UE\u0002\u0001\u0003\r\u0003/\u000b))!A\u0001\u0002\u000b\u0005\u0011\u0011\u0014\u0002\u0004?\u0012\n\u0014\u0003BAN\u0003C\u00032ALAO\u0013\r\tyj\f\u0002\b\u001d>$\b.\u001b8h!\u0011\t\u0019+!*\u000e\u0005\u00055\u0013\u0002BAT\u0003\u001b\u0012A\u0001V1tW\"9\u0011\u0011O\u0007A\u0002\u0005\u0005\u0011A\u0003:fg\u0016\u0014h/\u001a&pER1\u00111MAX\u0003gCq!!-\u000f\u0001\u0004\tI'A\u0006q_N\u001c\u0018N\u00197f\u0015>\u0014\u0007bBA9\u001d\u0001\u0007\u0011\u0011A\u0001\be\u0016\u001cXM\u001d<f)\u0019\tI'!/\u0002<\"9\u0011\u0011W\bA\u0002\u0005%\u0004bBA9\u001f\u0001\u0007\u0011\u0011A\u0001\bG>tg-\u001b:n)\u0019\ti$!1\u0002D\"9\u0011\u0011\u000f\tA\u0002\u0005\u0005\u0001bBAc!\u0001\u0007\u0011qY\u0001\u0006U>\u0014\u0017\n\u001a\t\u0005\u0003\u0007\tI-\u0003\u0003\u0002L\u0006=\"!\u0002&pE&#\u0017AF8gM\u0016\u0014Hk\u001c&pEJ+hN\\3s#V,W/Z:\u0015\t\u0005]\u0013\u0011\u001b\u0005\b\u0003\u000f\u000b\u0002\u0019AA5\u0003e\u0011X-\\8wK\u001a\u0013x.\u001c&pEJ+hN\\3s#V,W/Z:\u0015\t\u0005]\u0013q\u001b\u0005\b\u00033\u0014\u0002\u0019AAn\u0003%\u0001(/\u001a3jG\u0006$X\r\u0005\u0004\u0002^\u0006\r\u0018\u0011N\u0007\u0003\u0003?T1!!9{\u0003!1WO\\2uS>t\u0017\u0002BAs\u0003?\u0014\u0011\u0002\u0015:fI&\u001c\u0017\r^3\u0002\rM,(-\\5u)\u0011\t9&a;\t\u000f\u0005\u001d5\u00031\u0001\u0002j\u0005q1/\u001e2nSR,\u00050[:uS:<G\u0003BA,\u0003cDq!a\"\u0015\u0001\u0004\tI'A\ttk\nl\u0017\u000e\u001e\"s_\u0006$7-Y:uK\u0012$B!a\u0016\u0002x\"9\u0011qQ\u000bA\u0002\u0005%\u0014a\u0002:fa2\f7-\u001a\u000b\u0005\u0003/\ni\u0010C\u0004\u0002\bZ\u0001\r!!\u001b\u0002\r\u0019Lg.[:i)\u0011\t9Fa\u0001\t\u000f\u0005\u0015w\u00031\u0001\u0002H\u0006A1-\u00198dK2Le\r\u0006\u0003\u0002X\t%\u0001bBAm1\u0001\u0007\u00111\\\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003/\nAa\u001d;pa\u0006I\u0011n\u001d*v]:Lgn\u001a\u000b\u0003\u0003{\tAa]5{KR\u0011!\u0011\u0004\t\u0004]\tm\u0011b\u0001B\u000f_\t\u0019\u0011J\u001c;\u0002%I,w-[:uKJTuN\u0019*v]:,'o]\u0001\u0012GJ,\u0017\r^3Sk:tWM])vKV,G\u0003BA,\u0005KAq!!\b\u001f\u0001\u0004\t9%A\tsK6|g/\u001a*v]:,'/U;fk\u0016$B!a\u0016\u0003,!9\u0011QD\u0010A\u0002\u0005\u001d\u0013\u0001F;qI\u0006$X\rV1tWN#\u0018\r^;t\u0019&tW\r\u0006\u0003\u0002X\tE\u0002bBADA\u0001\u0007\u0011\u0011N\u0001\nk:\u0014Vm]3sm\u0016$B!a\u0016\u00038!9\u0011qQ\u0011A\u0002\u0005%\u0004f\u0001\u0001\u0003<A!!Q\bB&\u001b\t\u0011yD\u0003\u0003\u0003B\t\r\u0013AC:uKJ,w\u000e^=qK*!!Q\tB$\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'B\u0001B%\u0003\ry'oZ\u0005\u0005\u0005\u001b\u0012yDA\u0005D_6\u0004xN\\3oi\"\u001a\u0001A!\u0015\u0011\t\tM#1L\u0007\u0003\u0005+RA!a\u001f\u0003X)!!\u0011\fB\"\u0003\u001d\u0019wN\u001c;fqRLAA!\u0018\u0003V\t9\u0001K]5nCJL\b")
public class CapabilityAwareJobQueue
implements JobQueue,
RunnerRegistry,
JobProvider,
Logging {
    private ActorRef actorRef;
    private final DefaultJobQueue jobQueue;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private final SpringExtension springExtension;
    private final ConcurrentHashMap<String, JobRunnerQueue> runnerQueues;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    private ActorRef actorRef$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$0) {
                this.actorRef = this.springExtension.actorOf(JobConfirmationActor.class, this.springExtension.actorOf$default$2(), this.springExtension.actorOf$default$3(), this.springExtension.actorOf$default$4());
                this.bitmap$0 = true;
            }
        }
        return this.actorRef;
    }

    private ActorRef actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private ConcurrentHashMap<String, JobRunnerQueue> runnerQueues() {
        return this.runnerQueues;
    }

    @Override
    public boolean registerJobRunner(JobRunner jobRunner) {
        boolean updateInQueue;
        Option runnerQueue = Option$.MODULE$.apply((Object)this.runnerQueues().get(jobRunner.getId()));
        boolean bl = updateInQueue = runnerQueue.isEmpty() || runnerQueue.nonEmpty() && ((JobRunnerQueue)runnerQueue.get()).isOutdated(jobRunner);
        if (updateInQueue) {
            this.logger().debug((Function0 & Serializable)() -> "Going to register runner[" + jobRunner.getId() + "]");
            this.createRunnerQueue(jobRunner);
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Runner already in queue, skipping registration for runner[" + jobRunner.getId() + "]");
        }
        return updateInQueue;
    }

    @Override
    public void unregisterJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to un-register runner[" + jobRunner.getId() + "]");
        this.removeRunnerQueue(jobRunner);
    }

    @Override
    public final Option<Job> get(String runnerId) {
        Option s;
        Option option;
        while ((option = (s = Option$.MODULE$.apply((Object)this.runnerQueues().get(runnerId)))) instanceof Some) {
            Some some = (Some)option;
            JobRunnerQueue runnerQueue = (JobRunnerQueue)some.value();
            Option option2 = Option$.MODULE$.apply((Object)runnerQueue.poll());
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Job possibleJob = (Job)some2.value();
                Job job = possibleJob;
                if (job instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job;
                    return new Some((Object)stopWorkerThread);
                }
                if (job instanceof FailJob) {
                    FailJob failJob = (FailJob)job;
                    return new Some((Object)failJob);
                }
                if (job instanceof TaskJob) {
                    TaskJob taskJob = (TaskJob)job;
                    Option<Job> reservedJob = this.delayOrReserve(taskJob, runnerId);
                    Option<Job> option3 = reservedJob;
                    if (None$.MODULE$.equals(option3)) continue;
                    return option3;
                }
                throw new MatchError((Object)job);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "No runner queue found for " + runnerId;
            this.logger().warn((Function0 & Serializable)() -> msg);
            throw new NotFoundException(msg, new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    public Option<Job> delayOrReserve(TaskJob<? extends Task> job, String runnerId) {
        Either<Job, Job> maybeDelayed = JobSchedulerFeature$.MODULE$.strategy().schedule(job);
        Either<Job, Job> either = maybeDelayed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Job delayedTaskJob = (Job)left.value();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.replace(delayedTaskJob)).recover((PartialFunction)new Serializable(this, delayedTaskJob){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ CapabilityAwareJobQueue $outer;
                private final Job delayedTaskJob$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    this.$outer.logger().error((Function0 & Serializable)() -> "Unable to replace job " + $this.delayedTaskJob$1, (Function0 & Serializable)() -> A1);
                    return (B1)BoxedUnit.UNIT;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.delayedTaskJob$1 = delayedTaskJob$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.CapabilityAwareJobQueue$$anonfun$delayOrReserve$2 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
                }
            });
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Job job2 = (Job)right.value();
            return this.reserveJob(job2, runnerId);
        }
        throw new MatchError(either);
    }

    private Option<Job> reserveJob(Job possibleJob, String runnerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.reserve(possibleJob, runnerId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> "giving " + reservedJob);
            this.updateTaskStatusLine(reservedJob);
            return new Some((Object)reservedJob);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof OptimisticLockingFailureException) {
                this.logger().debug((Function0 & Serializable)() -> "Unable to reserve job " + possibleJob);
                return None$.MODULE$;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                FailJob failJob = new FailJob(possibleJob, (Option<String>)new Some((Object)throwable2.getMessage()));
                this.runnerQueues().get(LocalJobRunner$.MODULE$.getId()).offer(failJob);
                return None$.MODULE$;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    private Job reserve(Job possibleJob, String runnerId) {
        Job job = this.jobQueue.reserve(possibleJob, runnerId);
        this.removeFromJobRunnerQueues(x$1 -> x$1.id() == possibleJob.id());
        MonitorJobConfirmation x$12 = new MonitorJobConfirmation(job);
        ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$12);
        this.actorRef().$bang((Object)x$12, x$2);
        return job;
    }

    @Override
    public boolean confirm(String runnerId, long jobId) {
        boolean result;
        block1: {
            JobConfirmed x$1 = new JobConfirmed(jobId);
            ActorRef x$2 = this.actorRef().$bang$default$2((Object)x$1);
            this.actorRef().$bang((Object)x$1, x$2);
            Tuple2<Object, Option<TaskJob<?>>> tuple2 = this.jobQueue.confirm(runnerId, jobId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            Option taskJob = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)result2), (Object)taskJob);
            result = tuple22._1$mcZ$sp();
            Option taskJob2 = (Option)tuple22._2();
            if (!result || !taskJob2.isDefined()) break block1;
            this.updateTaskStatusLine((Job)taskJob2.get());
        }
        return result;
    }

    private void offerToJobRunnerQueues(Job job) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeFromJobRunnerQueues(Predicate<Job> predicate) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.cancelIf(predicate);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void submit(Job job) {
        this.jobQueue.submit(job);
        this.updateTaskStatusLine(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.jobQueue.submitExisting(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitBroadcasted(Job job) {
        this.jobQueue.submitBroadcasted(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void replace(Job job) {
        this.jobQueue.replace(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void finish(long jobId) {
        this.jobQueue.finish(jobId);
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.jobQueue.cancelIf(predicate);
        this.removeFromJobRunnerQueues(predicate);
    }

    @Override
    public void start() {
        this.registerJobRunners();
        this.jobQueue.start();
    }

    @Override
    public void stop() {
        this.jobQueue.stop();
    }

    @Override
    public boolean isRunning() {
        return this.jobQueue.isRunning();
    }

    @Override
    public int size() {
        return this.jobQueue.size();
    }

    private void registerJobRunners() {
        List<? extends JobRunner> jobRunners = this.jobRunnerRepository().findAll();
        jobRunners.forEach(runner -> this.createRunnerQueue((JobRunner)runner));
    }

    private void createRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
        JobRunnerQueue runnerQueue = new JobRunnerQueue((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(runner.getCapabilities()).asScala().toSet(), runner.capacity(), runner.evictionTime(), runner.idleTimeToLive());
        this.runnerQueues().put(runner.getId(), runnerQueue);
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.jobQueue.localJobs().iterator()).asScala().foreach((Function1 & Serializable)job -> {
            runnerQueue.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
    }

    private void updateTaskStatusLine(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            taskJob.jobStatusLine().foreach((Function1 & Serializable)statusLine -> {
                this.releaseActorService.updateTaskStatusLine(taskJob.taskId(), statusLine);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void unReserve(Job job) {
        Job unReservedJob = this.jobQueue.unReserve(job);
        this.updateTaskStatusLine(unReservedJob);
        this.replace(unReservedJob);
    }

    public CapabilityAwareJobQueue(DefaultJobQueue jobQueue, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, SpringExtension springExtension) {
        this.jobQueue = jobQueue;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.springExtension = springExtension;
        Logging.$init$((Logging)this);
        this.runnerQueues = new ConcurrentHashMap();
        this.createRunnerQueue(LocalJobRunner$.MODULE$);
    }
}

