package com.xebialabs.xlrelease.utils

import com.xebialabs.deployit.booter.local.utils.Strings.isNotBlank
import org.springframework.data.domain.Sort

import javax.ws.rs.core.UriInfo
import scala.jdk.CollectionConverters._

object SortSupport {

  def toSort(uriInfo: UriInfo): Sort = {
    val params = uriInfo.getQueryParameters
    val sortParams = params.get("sort").asScala
    var sort: Sort = Sort.unsorted()
    if (sortParams != null) {
      sortParams.foreach(s => {
        val splitted = s.split(",")
        val (property, order) = splitted.size match {
          case 1 => (splitted(0), "asc")
          case 2 => (splitted(0), splitted(1))
        }
        if (isNotBlank(property)) {
          order.toLowerCase() match {
            case "desc" => sort = sort.and(Sort.by(Sort.Direction.DESC, property))
            case _ => sort = sort.and(Sort.by(Sort.Direction.ASC, property))
          }
        }
      })
    }
    sort
  }
}
