package com.xebialabs.xlrelease.scheduler.workers

import com.xebialabs.xlrelease.actors.ReleaseActorService
import com.xebialabs.xlrelease.scheduler.workers.Worker._
import com.xebialabs.xlrelease.scheduler.{FailJob, TaskJob}
import com.xebialabs.xlrelease.user.User.SYSTEM
import org.springframework.stereotype.Component

@Component
class FailJobWorker(releaseActorService: ReleaseActorService) extends Worker {

  override def execute: ExecuteJob = {
    case FailJob(job, maybeErrorMessage) => job match {
      case taskJob: TaskJob[_] =>
        val comment: String = maybeErrorMessage match {
          case Some(errorMessage: String) => errorMessage
          case _ => ""
        }
        FailTaskJobExecutionResult(taskJob.taskId, comment, taskJob.taskRef.getExecutionId)
      case _ => DoNothingExecutionResult
    }
  }

  override def processResult: ProcessJobResult = {
    case result: FailJobExecutionResult => result match {
      case FailTaskJobExecutionResult(taskId, executionId, message) =>
        releaseActorService.failTaskWithRetry(taskId, message, SYSTEM, Option.empty, executionId)
      case DoNothingExecutionResult => ()
    }
  }
}
