package com.xebialabs.xlrelease.dispatcher

import akka.dispatch.DispatcherPrerequisites
import akka.xlrelease.stuff.XlrDispatcherPrerequisites
import com.typesafe.config.Config

import java.util.concurrent.ForkJoinPool

class XlrDispatcherConfigurator(config: Config, prerequisites: DispatcherPrerequisites, otherPrerequisites: DispatcherPrerequisites)
  extends akka.dispatch.DispatcherConfigurator(config, otherPrerequisites) {

  def this(config: Config, prerequisites: DispatcherPrerequisites) = {
    this(config, prerequisites, XlrDispatcherPrerequisites(
      prerequisites.threadFactory match {
        case forkJoinThreadFactory: ForkJoinPool.ForkJoinWorkerThreadFactory => new XlrDispatcherForkJoinWorkerThreadFactory(forkJoinThreadFactory)
        case _ => new XlrDispatcherThreadFactory(prerequisites.threadFactory)
      },
      prerequisites.eventStream,
      prerequisites.scheduler,
      prerequisites.dynamicAccess,
      prerequisites.settings,
      prerequisites.mailboxes,
      prerequisites.defaultExecutionContext
    ))
  }
}
